/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.injector.util;

import java.lang.reflect.Field;
import org.jboss.injection.injector.util.AbstractAccessibleObjectBeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldInjectionPoint<T, V>
extends AbstractAccessibleObjectBeanProperty<Field, T, V> {
    public FieldInjectionPoint(Field field) {
        super(field);
    }

    @Override
    public void set(T target, V value) {
        Field field = (Field)this.getAccessibleObject();
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            boolean equalLoaders;
            String msg = "failed to set value " + value + " on field " + field;
            ClassLoader fieldLoader = field.getType().getClassLoader();
            ClassLoader valueLoader = value == null ? null : value.getClass().getClassLoader();
            boolean bl = equalLoaders = fieldLoader == null && valueLoader == null ? true : fieldLoader.equals(valueLoader);
            if (!equalLoaders) {
                msg = msg + "; Reason: ClassLoaders of value: " + valueLoader + " and target field " + fieldLoader + " are not equal";
            }
            throw new IllegalArgumentException(msg);
        }
    }
}

