/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection.inject.naming;

import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.injection.inject.spi.InjectionPoint;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextInjectionPoint<V>
implements InjectionPoint<Context, V> {
    private static final Logger log = Logger.getLogger(ContextInjectionPoint.class);
    private final String jndiName;

    public ContextInjectionPoint(String jndiName) {
        if (jndiName == null) {
            throw new IllegalArgumentException("JNDI name can not be null");
        }
        this.jndiName = jndiName;
    }

    @Override
    public void set(Context context, V value) {
        try {
            log.debugf("Binding [%s] at [%s] in context [%s]", new Object[]{value.toString().replace('\n', ' '), this.jndiName, context});
            Util.rebind((Context)context, (String)this.jndiName, value);
        }
        catch (NamingException e) {
            throw new RuntimeException("Failed to bind value [" + value + "] into context [" + context + "] with jndi name [" + this.jndiName + "]", e);
        }
    }

    public String toString() {
        return "ContextInjectionPoint{jndiName='" + this.jndiName + '\'' + '}';
    }
}

