/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.client;

import java.util.Collection;
import java.util.EventListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.tm.TransactionManagerLocator;

public class ServerVMClientUserTransaction
implements UserTransaction {
    private static final ServerVMClientUserTransaction singleton = new ServerVMClientUserTransaction();
    private final TransactionManager tm;
    private final Collection<UserTransactionStartedListener> listeners = new CopyOnWriteArrayList<UserTransactionStartedListener>();

    public static ServerVMClientUserTransaction getSingleton() {
        return singleton;
    }

    private ServerVMClientUserTransaction() {
        this(TransactionManagerLocator.locateTransactionManager());
    }

    public ServerVMClientUserTransaction(TransactionManager tm) {
        this.tm = tm;
    }

    public boolean isServer() {
        return this.tm != null;
    }

    public void registerTxStartedListener(UserTransactionStartedListener txStartedListener) {
        if (txStartedListener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.listeners.add(txStartedListener);
    }

    public void unregisterTxStartedListener(UserTransactionStartedListener txStartedListener) {
        if (txStartedListener == null) {
            throw new IllegalArgumentException("Null listener");
        }
        this.listeners.remove(txStartedListener);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.tm.begin();
        for (UserTransactionStartedListener listener : this.listeners) {
            listener.userTransactionStarted();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.tm.commit();
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.tm.setTransactionTimeout(seconds);
    }

    public static interface UserTransactionStartedListener
    extends EventListener {
        public void userTransactionStarted() throws SystemException;
    }
}

