/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.arquillian.embedded;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

final class SecurityActions {
    private SecurityActions() {
        throw new UnsupportedOperationException("No instantiation");
    }

    public static List<Field> getFieldsWithAnnotation(final Class<?> clz, final Class<? extends Annotation> annotationClass) {
        List<Field> declaredAccessableFields = AccessController.doPrivileged(new PrivilegedAction<List<Field>>(){

            @Override
            public List<Field> run() {
                ArrayList<Field> foundFields = new ArrayList<Field>(1);
                for (Class nextClz = clz; nextClz != Object.class; nextClz = nextClz.getSuperclass()) {
                    for (Field field : nextClz.getDeclaredFields()) {
                        if (!field.isAnnotationPresent(annotationClass)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        foundFields.add(field);
                    }
                }
                return foundFields;
            }
        });
        return declaredAccessableFields;
    }
}

