/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jca.as.converters.LocalTxDataSource;
import org.jboss.jca.as.converters.NoTxDataSource;
import org.jboss.jca.as.converters.XaDataSource;

public interface DataSources {
    public List<LocalTxDataSource> getLocalTxDataSource();

    public List<NoTxDataSource> getNoTxDataSource();

    public List<XaDataSource> getXaDataSource();

    public static enum Tag {
        UNKNOWN(null),
        NO_TX_DATASOURCE("no-tx-datasource"),
        LOCAL_TX_DATASOURCE("local-tx-datasource"),
        XA_DATASOURCE("xa-datasource");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

