/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jca.as.converters.ConnectionFactories;
import org.jboss.jca.as.converters.ConnectionFactoriesImpl;
import org.jboss.jca.as.converters.LegacyConnectionFactoryImp;
import org.jboss.jca.as.converters.NoTxConnectionFactory;
import org.jboss.jca.as.converters.TxConnectionFactory;
import org.jboss.jca.as.converters.wls.api.metadata.AdminObjectGroup;
import org.jboss.jca.as.converters.wls.api.metadata.AdminObjectInstance;
import org.jboss.jca.as.converters.wls.api.metadata.ConfigProperties;
import org.jboss.jca.as.converters.wls.api.metadata.ConfigProperty;
import org.jboss.jca.as.converters.wls.api.metadata.ConnectionDefinition;
import org.jboss.jca.as.converters.wls.api.metadata.ConnectionDefinitionProperties;
import org.jboss.jca.as.converters.wls.api.metadata.ConnectionInstance;
import org.jboss.jca.as.converters.wls.api.metadata.PoolParams;
import org.jboss.jca.as.converters.wls.api.metadata.TransactionSupport;
import org.jboss.jca.as.converters.wls.api.metadata.WeblogicConnector;
import org.jboss.jca.as.converters.wls.metadata.ConnectionDefinitionPropertiesImpl;
import org.jboss.jca.as.converters.wls.metadata.WeblogicRaPasrer;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class WlsRaConverter {
    public void convert(InputStream in, OutputStream out) throws Exception {
        WeblogicRaPasrer parser = new WeblogicRaPasrer();
        WeblogicConnector wlsConnector = parser.parse(in);
        ConnectionFactories ds = this.transform(wlsConnector);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(ds.toString())));
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        serializer.transform(new DOMSource(doc), new StreamResult(out));
    }

    private ConnectionFactories transform(WeblogicConnector ra) throws Exception {
        ArrayList<NoTxConnectionFactory> noTxConnectionFactory = new ArrayList<NoTxConnectionFactory>();
        ArrayList<TxConnectionFactory> txConnectionFactory = new ArrayList<TxConnectionFactory>();
        if (ra.getOutboundResourceAdapter() == null || ra.getOutboundResourceAdapter().getConnectionDefinitionGroup() == null || ra.getOutboundResourceAdapter().getConnectionDefinitionGroup().size() == 0) {
            return null;
        }
        ConnectionDefinitionProperties defaultCdProps = ra.getOutboundResourceAdapter().getDefaultConnectionProperties();
        for (ConnectionDefinition conDef : ra.getOutboundResourceAdapter().getConnectionDefinitionGroup()) {
            ConnectionDefinitionProperties groupCdProps = this.mergedCdProps(defaultCdProps, conDef.getDefaultConnectionProperties());
            if (conDef.getConnectionInstance() == null) continue;
            for (ConnectionInstance conInstance : conDef.getConnectionInstance()) {
                ConnectionDefinitionProperties myCdProps = this.mergedCdProps(groupCdProps, conInstance.getConnectionProperties());
                if (myCdProps.getTransactionSupport().equals((Object)TransactionSupport.NoTransaction)) {
                    noTxConnectionFactory.add(this.buildNoTxConnectionFactory(conInstance.getJndiName(), myCdProps, ra));
                    continue;
                }
                txConnectionFactory.add(this.buildTxConnectionFactory(conInstance.getJndiName(), myCdProps, ra));
            }
        }
        return new ConnectionFactoriesImpl(noTxConnectionFactory, txConnectionFactory);
    }

    private NoTxConnectionFactory buildNoTxConnectionFactory(String jndiName, ConnectionDefinitionProperties myCdProps, WeblogicConnector ra) throws Exception {
        Map<String, String> rarProps = this.transformConfigProperties(ra.getProperties());
        Map<String, String> connProps = this.transformConfigProperties(myCdProps.getProperties());
        LegacyConnectionFactoryImp noTxCf = new LegacyConnectionFactoryImp(jndiName, "wls.rar", rarProps, "FIXME", "FIXME", connProps, TransactionSupportEnum.NoTransaction);
        this.transformAdminObjects(noTxCf, ra);
        this.transformResourceAdapter(noTxCf, myCdProps);
        noTxCf.buildResourceAdapterImpl();
        return noTxCf;
    }

    private TxConnectionFactory buildTxConnectionFactory(String jndiName, ConnectionDefinitionProperties myCdProps, WeblogicConnector ra) throws Exception {
        Map<String, String> rarProps = this.transformConfigProperties(ra.getProperties());
        Map<String, String> connProps = this.transformConfigProperties(myCdProps.getProperties());
        LegacyConnectionFactoryImp txCf = myCdProps.getTransactionSupport().equals((Object)TransactionSupport.LocalTransaction) ? new LegacyConnectionFactoryImp(jndiName, "wls.rar", rarProps, "FIXME", "FIXME", connProps, TransactionSupportEnum.LocalTransaction) : new LegacyConnectionFactoryImp(jndiName, "wls.rar", rarProps, "FIXME", "FIXME", connProps, TransactionSupportEnum.XATransaction);
        this.transformAdminObjects(txCf, ra);
        this.transformResourceAdapter(txCf, myCdProps);
        txCf.buildResourceAdapterImpl();
        return txCf;
    }

    private void transformResourceAdapter(LegacyConnectionFactoryImp lcf, ConnectionDefinitionProperties myCdProps) throws Exception {
        lcf.buildCommonPool(myCdProps.getPoolParams().getInitialCapacity(), myCdProps.getPoolParams().getMaxCapacity(), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.INTERLEAVING);
        lcf.buildTimeOut(new Long(myCdProps.getPoolParams().getConnectionReserveTimeoutSeconds() * 1000), new Long(myCdProps.getPoolParams().getConnectionReserveTimeoutSeconds().intValue()), 5, new Long(myCdProps.getPoolParams().getTestFrequencySeconds() * 1000), 0);
    }

    private ConnectionDefinitionProperties mergedCdProps(ConnectionDefinitionProperties oldCdProps, ConnectionDefinitionProperties newCdProps) {
        PoolParams poolParams = newCdProps.getPoolParams() == null ? oldCdProps.getPoolParams() : newCdProps.getPoolParams();
        ConfigProperties props = newCdProps.getProperties() == null ? oldCdProps.getProperties() : newCdProps.getProperties();
        TransactionSupport trans = oldCdProps.getTransactionSupport();
        if (newCdProps.getTransactionSupport() != null && newCdProps.getTransactionSupport() != TransactionSupport.NotDefined) {
            trans = newCdProps.getTransactionSupport();
        }
        return new ConnectionDefinitionPropertiesImpl(poolParams, null, trans, newCdProps.getAuthenticationMechanism(), newCdProps.getReauthenticationSupport(), props, newCdProps.getResAuth());
    }

    private Map<String, String> transformConfigProperties(ConfigProperties props) {
        if (props == null || props.getProperty() == null || props.getProperty().size() == 0) {
            return null;
        }
        HashMap<String, String> newprops = new HashMap<String, String>();
        for (ConfigProperty cp : props.getProperty()) {
            newprops.put(cp.getName(), cp.getValue());
        }
        return newprops;
    }

    private void transformAdminObjects(LegacyConnectionFactoryImp lcf, WeblogicConnector ra) throws Exception {
        if (ra.getAdminObjects() == null || ra.getAdminObjects().getAdminObjectGroup() == null || ra.getAdminObjects().getAdminObjectGroup().size() == 0) {
            return;
        }
        HashMap<String, String> defaultProps = new HashMap<String, String>();
        if (ra.getAdminObjects().getDefaultProperties() != null && ra.getAdminObjects().getDefaultProperties().getProperty() != null) {
            for (ConfigProperty cp : ra.getAdminObjects().getDefaultProperties().getProperty()) {
                defaultProps.put(cp.getName(), cp.getValue());
            }
        }
        for (AdminObjectGroup aog : ra.getAdminObjects().getAdminObjectGroup()) {
            if (aog.getAdminObjectInstance() == null || aog.getAdminObjectInstance().size() == 0) {
                return;
            }
            HashMap<String, String> aogProps = new HashMap<String, String>();
            aogProps.putAll(defaultProps);
            if (aog.getDefaultProperties() != null && aog.getDefaultProperties().getProperty() != null) {
                for (ConfigProperty cp : aog.getDefaultProperties().getProperty()) {
                    aogProps.put(cp.getName(), cp.getValue());
                }
            }
            for (AdminObjectInstance aoi : aog.getAdminObjectInstance()) {
                HashMap<String, String> aoiProps = null;
                if (aoi.getProperties() != null && aoi.getProperties().getProperty() != null) {
                    aoiProps = new HashMap();
                    aoiProps.putAll(aogProps);
                    for (ConfigProperty cp : aoi.getProperties().getProperty()) {
                        aoiProps.put(cp.getName(), cp.getValue());
                    }
                } else {
                    aoiProps = aogProps;
                }
                lcf.buildAdminObejcts(aog.getAdminObjectClass(), "java:jboss/" + aoi.getJndiName(), "FIXME", aoiProps, true, true);
            }
        }
    }
}

