/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.as.converters.ParserException;

public abstract class AbstractParser {
    protected Boolean elementAsBoolean(XMLStreamReader reader) throws XMLStreamException, ParserException {
        String elementtext = this.rawElementText(reader);
        String stringValue = this.getSubstitutionValue(elementtext);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return stringValue == null || stringValue.length() == 0 ? Boolean.TRUE : Boolean.valueOf(stringValue.trim());
        }
        throw new ParserException(reader.getLocalName());
    }

    protected Boolean attributeAsBoolean(XMLStreamReader reader, String attributeName, Boolean defaultValue) throws XMLStreamException, ParserException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        String stringValue = this.getSubstitutionValue(attributeString);
        if (stringValue == null || stringValue.length() == 0 || stringValue.trim().equalsIgnoreCase("true") || stringValue.trim().equalsIgnoreCase("false")) {
            return attributeString == null ? defaultValue : Boolean.valueOf(reader.getAttributeValue("", attributeName).trim());
        }
        throw new ParserException(reader.getLocalName());
    }

    protected String elementAsString(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = this.rawElementText(reader);
        return this.getSubstitutionValue(elementtext);
    }

    private String rawElementText(XMLStreamReader reader) throws XMLStreamException {
        String elementtext = reader.getElementText();
        elementtext = elementtext == null ? null : elementtext.trim();
        return elementtext;
    }

    protected String attributeAsString(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        String attributeString = this.rawAttributeText(reader, attributeName);
        return this.getSubstitutionValue(attributeString);
    }

    protected Integer attributeAsInt(XMLStreamReader reader, String attributeName) throws XMLStreamException {
        String attributeString = this.getSubstitutionValue(this.rawAttributeText(reader, attributeName));
        return attributeString != null ? Integer.valueOf(this.getSubstitutionValue(attributeString)) : null;
    }

    private String rawAttributeText(XMLStreamReader reader, String attributeName) {
        String attributeString = reader.getAttributeValue("", attributeName) == null ? null : reader.getAttributeValue("", attributeName).trim();
        return attributeString;
    }

    protected Integer elementAsInteger(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Integer integerValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            integerValue = Integer.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(reader.getLocalName());
        }
        return integerValue;
    }

    protected Long elementAsLong(XMLStreamReader reader) throws XMLStreamException, ParserException {
        Long longValue = null;
        String elementtext = this.rawElementText(reader);
        try {
            longValue = Long.valueOf(this.getSubstitutionValue(elementtext));
        }
        catch (NumberFormatException nfe) {
            throw new ParserException(reader.getLocalName());
        }
        return longValue;
    }

    private String getSubstitutionValue(String input) throws XMLStreamException {
        if (input == null || input.trim().equals("")) {
            return input;
        }
        while (input.indexOf("${") != -1) {
            int from = input.indexOf("${");
            int to = input.indexOf("}");
            int dv = input.indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = "";
            String defaultValue = "";
            String s = input.substring(from + 2, to);
            if (dv == -1) {
                systemProperty = "/".equals(s) ? File.separator : (":".equals(s) ? File.pathSeparator : SecurityActions.getSystemProperty(s));
            } else {
                s = input.substring(from + 2, dv);
                systemProperty = SecurityActions.getSystemProperty(s);
                defaultValue = input.substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            if (from != 0) {
                prefix = input.substring(0, from);
            }
            if (to + 1 < input.length() - 1) {
                postfix = input.substring(to + 1);
            }
            if (systemProperty != null && !systemProperty.trim().equals("")) {
                input = prefix + systemProperty + postfix;
                continue;
            }
            if (!defaultValue.trim().equals("")) {
                input = prefix + defaultValue + postfix;
                continue;
            }
            input = prefix + postfix;
        }
        return input;
    }

    private static class SecurityActions {
        private SecurityActions() {
        }

        static String getSystemProperty(final String name) {
            if (System.getSecurityManager() == null) {
                return System.getProperty(name);
            }
            return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return System.getProperty(name);
                }
            });
        }
    }
}

