/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.converters;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.jca.as.converters.AbstractParser;
import org.jboss.jca.as.converters.ConnectionFactories;
import org.jboss.jca.as.converters.ConnectionFactoriesImpl;
import org.jboss.jca.as.converters.DataSources;
import org.jboss.jca.as.converters.LegacyConnectionFactoryImp;
import org.jboss.jca.as.converters.NoTxConnectionFactory;
import org.jboss.jca.as.converters.ParserException;
import org.jboss.jca.as.converters.TxConnectionFactory;
import org.jboss.jca.as.converters.UnknownTagException;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.logging.Logger;

public class LegacyCfParser
extends AbstractParser {
    private static final String DEFAULT_SECURITY_DOMAIN = "other";
    private static Logger log = Logger.getLogger(LegacyCfParser.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionFactories parse(InputStream xmlInputStream) throws Exception {
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        reader = inputFactory.createXMLStreamReader(xmlInputStream);
        try {
            ConnectionFactories connectionFactories = this.parse(reader);
            return connectionFactories;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void skipParse(XMLStreamReader reader) throws Exception {
        int level = 1;
        block4: while (reader.hasNext() && level > 0) {
            switch (reader.next()) {
                case 2: {
                    --level;
                    continue block4;
                }
                case 1: {
                    ++level;
                    continue block4;
                }
            }
        }
        log.info((Object)("Skipping: " + reader.getLocalName()));
    }

    private void notSupport(XMLStreamReader reader) throws Exception {
        log.info((Object)("So far not support " + reader.getLocalName()));
    }

    private ConnectionFactories parse(XMLStreamReader reader) throws Exception {
        int iterate;
        ConnectionFactories connectionFactories = null;
        try {
            iterate = reader.nextTag();
        }
        catch (XMLStreamException e) {
            iterate = reader.nextTag();
        }
        block1 : switch (iterate) {
            case 2: {
                break;
            }
            case 1: {
                switch (Tag.forName(reader.getLocalName())) {
                    case DATASOURCES: {
                        this.notSupport(reader);
                        return null;
                    }
                    case CONNECTION_FACTORIES: {
                        connectionFactories = this.parseConnectionFactories(reader);
                        break block1;
                    }
                }
                throw new UnknownTagException(reader.getLocalName());
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return connectionFactories;
    }

    private ConnectionFactories parseConnectionFactories(XMLStreamReader reader) throws Exception {
        ArrayList<NoTxConnectionFactory> noTxConnectionFactory = new ArrayList<NoTxConnectionFactory>();
        ArrayList<TxConnectionFactory> txConnectionFactory = new ArrayList<TxConnectionFactory>();
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (Tag.forName(reader.getLocalName()) == Tag.CONNECTION_FACTORIES) {
                        return new ConnectionFactoriesImpl(noTxConnectionFactory, txConnectionFactory);
                    }
                    if (DataSources.Tag.forName(reader.getLocalName()) != DataSources.Tag.UNKNOWN) break;
                    throw new UnknownTagException(reader.getLocalName());
                }
                case 1: {
                    switch (ConnectionFactories.Tag.forName(reader.getLocalName())) {
                        case NO_TX_CONNECTION_FACTORY: {
                            noTxConnectionFactory.add(this.parseNoTxConnectionFactory(reader));
                            break block0;
                        }
                        case TX_CONNECTION_FACTORY: {
                            txConnectionFactory.add(this.parseTxConnectionFactory(reader));
                            break block0;
                        }
                    }
                    this.skipParse(reader);
                }
            }
        }
        throw new ParserException(reader.getLocalName());
    }

    private NoTxConnectionFactory parseNoTxConnectionFactory(XMLStreamReader reader) throws Exception {
        HashMap<String, String> configProperty = new HashMap<String, String>();
        String rarName = null;
        String connectionDefinition = null;
        String poolName = null;
        String jndiName = null;
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        Boolean prefill = Defaults.PREFILL;
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        Long backgroundValidationMillis = null;
        Boolean useFastFail = Defaults.USE_FAST_FAIL;
        String securityDomainManaged = "";
        String securityDomainAndApplicationManaged = "";
        boolean applicationManaged = true;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ConnectionFactories.Tag.forName(reader.getLocalName()) == ConnectionFactories.Tag.NO_TX_CONNECTION_FACTORY) {
                        LegacyConnectionFactoryImp cfImpl = new LegacyConnectionFactoryImp(jndiName, rarName, configProperty, poolName, connectionDefinition, configProperty, TransactionSupportEnum.NoTransaction);
                        cfImpl.buildTimeOut(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, null);
                        cfImpl.buildSecurity(securityDomainManaged, securityDomainAndApplicationManaged, applicationManaged);
                        cfImpl.buildValidation(backgroundValidation, backgroundValidationMillis, useFastFail);
                        cfImpl.buildCommonPool(minPoolSize, maxPoolSize, prefill, null, Defaults.NO_TX_SEPARATE_POOL, Defaults.INTERLEAVING);
                        cfImpl.buildResourceAdapterImpl();
                        return cfImpl;
                    }
                    if (NoTxConnectionFactory.Tag.forName(reader.getLocalName()) != NoTxConnectionFactory.Tag.UNKNOWN) break;
                    throw new UnknownTagException(reader.getLocalName());
                }
                case 1: {
                    switch (NoTxConnectionFactory.Tag.forName(reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            securityDomainManaged = this.elementAsString(reader);
                            applicationManaged = false;
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            securityDomainAndApplicationManaged = this.elementAsString(reader);
                            applicationManaged = false;
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block0;
                        }
                        case RAR_NAME: {
                            rarName = this.elementAsString(reader);
                            break block0;
                        }
                        case CONNECTION_DEFINITION: {
                            this.elementAsString(reader);
                            connectionDefinition = "FIXME_MCF_CLASS_NAME";
                            break block0;
                        }
                        case JNDI_NAME: {
                            poolName = this.elementAsString(reader);
                            if (poolName.startsWith("java:")) {
                                poolName = poolName.substring(5);
                            }
                            jndiName = "java:jboss/" + poolName;
                            break block0;
                        }
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            backgroundValidationMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                    }
                    this.skipParse(reader);
                    break;
                }
            }
        }
        throw new ParserException();
    }

    private TxConnectionFactory parseTxConnectionFactory(XMLStreamReader reader) throws Exception {
        HashMap<String, String> configProperty = new HashMap<String, String>();
        String rarName = null;
        String connectionDefinition = null;
        String poolName = null;
        String jndiName = null;
        Integer minPoolSize = null;
        Integer maxPoolSize = null;
        Boolean prefill = Defaults.PREFILL;
        Long blockingTimeoutMillis = null;
        Long idleTimeoutMinutes = null;
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Integer xaResourceTimeout = null;
        Boolean backgroundValidation = Defaults.BACKGROUND_VALIDATION;
        Long backgroundValidationMillis = null;
        Boolean useFastFail = Defaults.USE_FAST_FAIL;
        TransactionSupportEnum transactionSupport = TransactionSupportEnum.LocalTransaction;
        Boolean noTxSeparatePool = Defaults.NO_TX_SEPARATE_POOL;
        Boolean interleaving = Defaults.INTERLEAVING;
        String securityDomainManaged = "";
        String securityDomainAndApplicationManaged = "";
        boolean applicationManaged = true;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ConnectionFactories.Tag.forName(reader.getLocalName()) == ConnectionFactories.Tag.TX_CONNECTION_FACTORY) {
                        LegacyConnectionFactoryImp cfImpl = new LegacyConnectionFactoryImp(jndiName, rarName, configProperty, poolName, connectionDefinition, configProperty, transactionSupport);
                        cfImpl.buildTimeOut(blockingTimeoutMillis, idleTimeoutMinutes, allocationRetry, allocationRetryWaitMillis, xaResourceTimeout);
                        cfImpl.buildSecurity(securityDomainManaged, securityDomainAndApplicationManaged, applicationManaged);
                        cfImpl.buildValidation(backgroundValidation, backgroundValidationMillis, useFastFail);
                        cfImpl.buildCommonPool(minPoolSize, maxPoolSize, prefill, null, noTxSeparatePool, interleaving);
                        cfImpl.buildResourceAdapterImpl();
                        return cfImpl;
                    }
                    if (TxConnectionFactory.Tag.forName(reader.getLocalName()) != TxConnectionFactory.Tag.UNKNOWN) break;
                    throw new UnknownTagException(reader.getLocalName());
                }
                case 1: {
                    switch (TxConnectionFactory.Tag.forName(reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            securityDomainManaged = this.elementAsString(reader);
                            applicationManaged = false;
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            securityDomainAndApplicationManaged = this.elementAsString(reader);
                            applicationManaged = false;
                            break block0;
                        }
                        case CONFIG_PROPERTY: {
                            configProperty.put(this.attributeAsString(reader, "name"), this.elementAsString(reader));
                            break block0;
                        }
                        case RAR_NAME: {
                            rarName = this.elementAsString(reader);
                            break block0;
                        }
                        case CONNECTION_DEFINITION: {
                            this.elementAsString(reader);
                            connectionDefinition = "FIXME_MCF_CLASS_NAME";
                            break block0;
                        }
                        case JNDI_NAME: {
                            poolName = this.elementAsString(reader);
                            if (poolName.startsWith("java:")) {
                                poolName = poolName.substring(5);
                            }
                            jndiName = "java:jboss/" + poolName;
                            break block0;
                        }
                        case MAX_POOL_SIZE: {
                            maxPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            minPoolSize = this.elementAsInteger(reader);
                            break block0;
                        }
                        case PREFILL: {
                            prefill = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY: {
                            allocationRetry = this.elementAsInteger(reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            allocationRetryWaitMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            blockingTimeoutMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            idleTimeoutMinutes = this.elementAsLong(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION: {
                            backgroundValidation = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            backgroundValidationMillis = this.elementAsLong(reader);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            useFastFail = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case LOCAL_TRANSACTION: {
                            transactionSupport = TransactionSupportEnum.LocalTransaction;
                            break block0;
                        }
                        case XA_TRANSACTION: {
                            transactionSupport = TransactionSupportEnum.XATransaction;
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            noTxSeparatePool = this.elementAsBoolean(reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            xaResourceTimeout = this.elementAsInteger(reader);
                            break block0;
                        }
                        case TRACK_CONNECTION_BY_TX: {
                            interleaving = false;
                            break block0;
                        }
                    }
                    this.skipParse(reader);
                    break;
                }
            }
        }
        throw new ParserException();
    }

    public static enum Tag {
        UNKNOWN(null),
        DATASOURCES("datasources"),
        CONNECTION_FACTORIES("connection-factories");

        private final String name;
        private static final Map<String, Tag> MAP;

        private Tag(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        public static Tag forName(String localName) {
            Tag element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            for (Tag element : Tag.values()) {
                String name = element.getLocalName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

