/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.tracer;

import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.jca.as.tracer.TraceEventStatus;
import org.jboss.jca.core.tracer.TraceEvent;

public class TraceEventHelper {
    public static Map<String, Map<String, List<TraceEvent>>> filterEvents(List<TraceEvent> data) throws Exception {
        TreeMap<String, Map<String, List<TraceEvent>>> result = new TreeMap<String, Map<String, List<TraceEvent>>>();
        for (TraceEvent te : data) {
            ArrayList<TraceEvent> l;
            TreeMap<String, ArrayList<TraceEvent>> m = (TreeMap<String, ArrayList<TraceEvent>>)result.get(te.getPool());
            if (m == null) {
                m = new TreeMap<String, ArrayList<TraceEvent>>();
            }
            if ((l = (ArrayList<TraceEvent>)m.get(te.getConnectionListener())) == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            m.put(te.getConnectionListener(), l);
            result.put(te.getPool(), m);
        }
        return result;
    }

    public static List<TraceEvent> getEvents(FileReader fr) throws Exception {
        return TraceEventHelper.getEvents(TraceEventHelper.getData(fr));
    }

    public static Map<String, TraceEventStatus> getStatus(Map<String, List<TraceEvent>> input, boolean ignoreDelist) {
        TreeMap<String, TraceEventStatus> result = new TreeMap<String, TraceEventStatus>();
        for (Map.Entry<String, List<TraceEvent>> entry : input.entrySet()) {
            result.put(entry.getKey(), TraceEventHelper.getStatus(entry.getValue(), ignoreDelist));
        }
        return result;
    }

    public static TraceEventStatus getStatus(List<TraceEvent> data, boolean ignoreDelist) {
        TraceEventStatus explicit = null;
        HashSet<String> knownConnections = new HashSet<String>();
        boolean gotCl = false;
        boolean inTx = false;
        boolean gotClear = false;
        block14: for (TraceEvent te : data) {
            switch (te.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (gotCl) {
                        explicit = TraceEventStatus.RED;
                    }
                    gotCl = true;
                    continue block14;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (!gotCl) {
                        explicit = TraceEventStatus.RED;
                    }
                    gotCl = false;
                    continue block14;
                }
                case 14: {
                    explicit = TraceEventStatus.RED;
                    continue block14;
                }
                case 20: {
                    if (inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = true;
                    continue block14;
                }
                case 22: {
                    if (inTx) {
                        explicit = TraceEventStatus.YELLOW;
                    }
                    inTx = true;
                    continue block14;
                }
                case 21: 
                case 23: {
                    explicit = inTx ? TraceEventStatus.RED : TraceEventStatus.YELLOW;
                    inTx = true;
                    continue block14;
                }
                case 30: 
                case 32: 
                case 34: {
                    if (!inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = false;
                    if (knownConnections.size() <= 0 || explicit == TraceEventStatus.RED) continue block14;
                    explicit = TraceEventStatus.YELLOW;
                    continue block14;
                }
                case 31: 
                case 33: {
                    explicit = !inTx ? TraceEventStatus.RED : TraceEventStatus.YELLOW;
                    inTx = false;
                    if (knownConnections.size() <= 0 || explicit == TraceEventStatus.RED) continue block14;
                    explicit = TraceEventStatus.YELLOW;
                    continue block14;
                }
                case 40: {
                    knownConnections.add(te.getPayload());
                    continue block14;
                }
                case 41: {
                    knownConnections.remove(te.getPayload());
                    continue block14;
                }
                case 42: {
                    gotClear = true;
                    continue block14;
                }
                case 50: {
                    continue block14;
                }
            }
            System.err.println("TraceEventHelper: Unknown code: " + te);
        }
        if (explicit != null) {
            return explicit;
        }
        if (gotCl) {
            return TraceEventStatus.RED;
        }
        if (inTx && !ignoreDelist) {
            return TraceEventStatus.RED;
        }
        if (knownConnections.size() > 0) {
            return TraceEventStatus.RED;
        }
        if (gotClear) {
            return TraceEventStatus.RED;
        }
        return TraceEventStatus.GREEN;
    }

    public static TraceEventStatus mergeStatus(List<TraceEventStatus> data) {
        TraceEventStatus result = TraceEventStatus.GREEN;
        for (TraceEventStatus tes : data) {
            if (tes == TraceEventStatus.YELLOW) {
                result = TraceEventStatus.YELLOW;
                continue;
            }
            if (tes != TraceEventStatus.RED) continue;
            return TraceEventStatus.RED;
        }
        return result;
    }

    public static boolean isStartState(TraceEvent te) {
        return te.getType() == 0 || te.getType() == 1 || te.getType() == 2 || te.getType() == 3 || te.getType() == 14;
    }

    public static boolean isEndState(TraceEvent te) {
        return te.getType() == 10 || te.getType() == 11 || te.getType() == 12 || te.getType() == 13 || te.getType() == 14;
    }

    public static boolean isRed(TraceEvent te) {
        return te.getType() == 42 || te.getType() == 14;
    }

    public static boolean isYellow(TraceEvent te) {
        return false;
    }

    public static Map<String, List<TraceEvent>> split(List<TraceEvent> data) {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        long start = 0L;
        ArrayList<TraceEvent> l = new ArrayList<TraceEvent>();
        for (int i = 0; i < data.size(); ++i) {
            TraceEvent te = data.get(i);
            l.add(te);
            if (start == 0L) {
                start = te.getTimestamp();
            }
            if (!TraceEventHelper.isEndState(te)) continue;
            result.put(Long.toString(start) + "-" + Long.toString(te.getTimestamp()), l);
            start = 0L;
            l = new ArrayList();
        }
        if (l.size() > 0) {
            result.put(Long.toString(start) + "-" + Long.toString(((TraceEvent)l.get(l.size() - 1)).getTimestamp()), l);
        }
        return result;
    }

    public static boolean hasException(List<TraceEvent> events) {
        for (TraceEvent te : events) {
            if (te.getType() != 50) continue;
            return true;
        }
        return false;
    }

    public static String exceptionDescription(TraceEvent te) {
        if (te.getType() != 50) {
            return "";
        }
        char[] data = te.getPayload().toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            sb = c == '|' ? sb.append('\n') : (c == '/' ? sb.append('\r') : (c == '\\' ? sb.append('\t') : (c == '_' ? sb.append(' ') : sb.append(c))));
        }
        return sb.toString();
    }

    public static String prettyPrint(TraceEvent te) {
        if (te.getType() != 50) {
            return te.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("IJTRACER");
        sb.append("-");
        sb.append(te.getPool());
        sb.append("-");
        sb.append(te.getThreadId());
        sb.append("-");
        sb.append(te.getType());
        sb.append("-");
        sb.append(te.getTimestamp());
        sb.append("-");
        sb.append(te.getConnectionListener());
        sb.append("-");
        sb.append("DATA");
        return sb.toString();
    }

    static boolean hasMoreApplicationEvents(List<TraceEvent> events, int index) {
        if (index < 0 || index >= events.size()) {
            return false;
        }
        for (int j = index; j < events.size(); ++j) {
            TraceEvent te = events.get(j);
            if (te.getType() != 40 && te.getType() != 41) continue;
            return true;
        }
        return false;
    }

    private static List<String> getData(FileReader fr) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(fr);
        String s = r.readLine();
        while (s != null) {
            if (s.indexOf("IJTRACER") != -1) {
                result.add(s.substring(s.indexOf("IJTRACER")));
            }
            s = r.readLine();
        }
        return result;
    }

    private static List<TraceEvent> getEvents(List<String> data) throws Exception {
        ArrayList<TraceEvent> result = new ArrayList<TraceEvent>();
        for (String s : data) {
            result.add(TraceEvent.parse((String)s));
        }
        return result;
    }
}

