/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.tracer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.jca.as.tracer.SDeditGenerator;
import org.jboss.jca.as.tracer.TraceEventHelper;
import org.jboss.jca.as.tracer.TraceEventStatus;
import org.jboss.jca.core.tracer.TraceEvent;

public class HTMLReport {
    static void writeString(FileWriter fw, String s) throws Exception {
        for (int i = 0; i < s.length(); ++i) {
            fw.write(s.charAt(i));
        }
    }

    static void writeEOL(FileWriter fw) throws Exception {
        fw.write(10);
    }

    private static void generateTopLevelIndexHTML(Set<String> poolNames, Map<String, TraceEventStatus> statuses, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>IronJacamar tracer report</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "Generated: " + new Date());
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Pool</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (String name : poolNames) {
            TraceEventStatus status = statuses.get(name);
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + name + "/index.html\"><div style=\"color: ");
            if (status != null) {
                HTMLReport.writeString(fw, status.getColor());
            } else {
                HTMLReport.writeString(fw, TraceEventStatus.GREEN.getColor());
            }
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, name);
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Lifecycle</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (String name : poolNames) {
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + name + "/lifecycle.html\">");
            HTMLReport.writeString(fw, name);
            HTMLReport.writeString(fw, "</a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generatePoolIndexHTML(String poolName, Map<String, TraceEventStatus> statuses, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Pool: " + poolName + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>ConnectionListeners</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (Map.Entry<String, TraceEventStatus> entry : statuses.entrySet()) {
            String directory = entry.getKey();
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + directory + "/index.html\"><div style=\"color: ");
            HTMLReport.writeString(fw, entry.getValue().getColor());
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, directory);
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Lifecycle</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"lifecycle.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateConnectionListenerIndexHTML(String identifier, List<TraceEvent> data, boolean ignoreDelist, String root, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>ConnectionListener: " + identifier + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Reports</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        Map<String, List<TraceEvent>> m = TraceEventHelper.split(data);
        for (Map.Entry<String, List<TraceEvent>> entry : m.entrySet()) {
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + entry.getKey() + "/index.html\"><div style=\"color: ");
            TraceEventStatus status = TraceEventHelper.getStatus(entry.getValue(), ignoreDelist);
            HTMLReport.writeString(fw, status.getColor());
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, entry.getKey());
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
            OutputStreamWriter cl = null;
            try {
                File f = new File(root + "/" + entry.getKey());
                f.mkdirs();
                cl = new FileWriter(f.getAbsolutePath() + "/" + "index.html");
                HTMLReport.generateConnectionListenerReportHTML(f.getCanonicalPath(), identifier, entry.getValue(), ignoreDelist, (FileWriter)cl);
            }
            finally {
                if (cl != null) {
                    try {
                        cl.flush();
                        cl.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (status != TraceEventStatus.GREEN) continue;
            OutputStreamWriter sdedit = null;
            try {
                File f = new File(root + "/" + entry.getKey());
                f.mkdirs();
                sdedit = new FileWriter(f.getAbsolutePath() + "/" + identifier + ".sdx");
                SDeditGenerator.generateSDedit(entry.getValue(), (FileWriter)sdedit);
            }
            finally {
                if (sdedit == null) continue;
                try {
                    sdedit.flush();
                    sdedit.close();
                }
                catch (Exception e) {}
            }
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateConnectionListenerReportHTML(String root, String identifier, List<TraceEvent> data, boolean ignoreDelist, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>ConnectionListener: " + identifier + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>" + data.get(0).getManagedConnectionPool() + "</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>From:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>" + data.get(0).getTimestamp() + "</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>To:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>" + data.get(data.size() - 1).getTimestamp() + "</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Thread:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>" + data.get(0).getThreadId() + "</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Status:</b></td>");
        HTMLReport.writeEOL(fw);
        TraceEventStatus status = TraceEventHelper.getStatus(data, ignoreDelist);
        HTMLReport.writeString(fw, "<td><div style=\"color: " + status.getColor() + ";\">");
        HTMLReport.writeString(fw, status.getDescription());
        HTMLReport.writeString(fw, "</div></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Sequence diagram</h2>");
        HTMLReport.writeEOL(fw);
        if (status == TraceEventStatus.GREEN) {
            HTMLReport.writeString(fw, "<image src=\"");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".png\" alt=\"SDedit image\"/>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<p/>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "Generate the image by: <i>sdedit -t png -o ");
            HTMLReport.writeString(fw, root);
            HTMLReport.writeString(fw, "/");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".png ");
            HTMLReport.writeString(fw, root);
            HTMLReport.writeString(fw, "/");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".sdx ");
            HTMLReport.writeString(fw, "</i>");
            HTMLReport.writeEOL(fw);
        } else {
            HTMLReport.writeString(fw, "See Description or Data for recorded data");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "<h2>Description</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<thead align=\"left\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<th>Timestamp</th>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<th>Description</th>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</thead>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tbody>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : data) {
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>");
            if (TraceEventHelper.isRed(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: red;\">");
            } else if (TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: yellow;\">");
            }
            HTMLReport.writeString(fw, Long.toString(te.getTimestamp()));
            if (TraceEventHelper.isRed(te) || TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "</div>");
            }
            HTMLReport.writeString(fw, "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>");
            if (TraceEventHelper.isRed(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: red;\">");
            } else if (TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: yellow;\">");
            }
            HTMLReport.writeString(fw, TraceEvent.asText((TraceEvent)te));
            if (TraceEventHelper.isRed(te) || TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "</div>");
            }
            HTMLReport.writeString(fw, "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</tbody>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        if (TraceEventHelper.hasException(data)) {
            HTMLReport.writeString(fw, "<h2>Exception</h2>");
            HTMLReport.writeEOL(fw);
            for (TraceEvent te : data) {
                if (te.getType() != 50) continue;
                HTMLReport.writeString(fw, "<pre>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, TraceEventHelper.exceptionDescription(te));
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "</pre>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "<p/>");
                HTMLReport.writeEOL(fw);
            }
        }
        HTMLReport.writeString(fw, "<h2>Data</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<pre>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : data) {
            HTMLReport.writeString(fw, TraceEventHelper.prettyPrint(te));
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</pre>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateLifecycleHTML(String poolName, List<TraceEvent> events, Set<String> activeCLs, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Lifecycle: " + poolName + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Timestamp</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Event</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ConnectionListener</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : events) {
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getTimestamp() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getManagedConnectionPool() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + TraceEvent.asText((TraceEvent)te) + "</td>");
            HTMLReport.writeEOL(fw);
            if (!"NONE".equals(te.getConnectionListener())) {
                if (activeCLs.contains(te.getConnectionListener())) {
                    HTMLReport.writeString(fw, "<td><a href=\"" + te.getConnectionListener() + "/index.html\">" + te.getConnectionListener() + "</a></td>");
                } else {
                    HTMLReport.writeString(fw, "<td>" + te.getConnectionListener() + "</td>");
                }
            } else {
                HTMLReport.writeString(fw, "<td></td>");
            }
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Pool</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"index.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Usage: HTMLReport [-ignore-delist] <file> [<output>]");
            return;
        }
        boolean ignoreDelist = false;
        int argCount = 0;
        if ("-ignore-delist".equals(args[0])) {
            ignoreDelist = true;
            ++argCount;
        }
        File logFile = new File(args[argCount]);
        FileReader logReader = null;
        String rootDirectory = "report";
        if (args.length > argCount + 1) {
            rootDirectory = args[argCount + 1];
        }
        File root = new File(rootDirectory);
        try {
            File f;
            String path;
            logReader = new FileReader(logFile);
            root.mkdirs();
            List<TraceEvent> events = TraceEventHelper.getEvents(logReader, root);
            Map<String, Map<String, List<TraceEvent>>> filteredPool = TraceEventHelper.filterPoolEvents(events);
            Map<String, List<TraceEvent>> filteredLifecycle = TraceEventHelper.filterLifecycleEvents(events);
            TreeMap<String, TraceEventStatus> topLevelStatus = new TreeMap<String, TraceEventStatus>();
            for (Map.Entry<String, Map<String, List<TraceEvent>>> entry : filteredPool.entrySet()) {
                Collection<List<TraceEvent>> values = entry.getValue().values();
                ArrayList<TraceEventStatus> status = new ArrayList<TraceEventStatus>();
                for (List<TraceEvent> l : values) {
                    status.add(TraceEventHelper.getStatus(l, ignoreDelist));
                }
                topLevelStatus.put(entry.getKey(), TraceEventHelper.mergeStatus(status));
            }
            OutputStreamWriter topLevel = null;
            try {
                topLevel = new FileWriter(root.getAbsolutePath() + "/" + "index.html");
                HTMLReport.generateTopLevelIndexHTML(filteredLifecycle.keySet(), topLevelStatus, (FileWriter)topLevel);
            }
            finally {
                if (topLevel != null) {
                    try {
                        topLevel.flush();
                        topLevel.close();
                    }
                    catch (Exception e) {}
                }
            }
            for (String poolName : filteredLifecycle.keySet()) {
                Map<String, List<TraceEvent>> data = filteredPool.get(poolName);
                OutputStreamWriter pool = null;
                try {
                    path = root.getAbsolutePath() + "/" + poolName;
                    f = new File(path);
                    f.mkdirs();
                    TreeMap<String, TraceEventStatus> status = new TreeMap<String, TraceEventStatus>();
                    if (data != null) {
                        for (Map.Entry<String, List<TraceEvent>> dataEntry : data.entrySet()) {
                            status.put(dataEntry.getKey(), TraceEventHelper.getStatus(dataEntry.getValue(), ignoreDelist));
                            String identifier = dataEntry.getKey();
                            OutputStreamWriter cl = null;
                            try {
                                String clPath = path + "/" + identifier;
                                File clF = new File(clPath);
                                clF.mkdirs();
                                cl = new FileWriter(clF.getAbsolutePath() + "/" + "index.html");
                                HTMLReport.generateConnectionListenerIndexHTML(identifier, dataEntry.getValue(), ignoreDelist, clPath, (FileWriter)cl);
                            }
                            finally {
                                if (cl == null) continue;
                                try {
                                    cl.flush();
                                    cl.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                    pool = new FileWriter(f.getAbsolutePath() + "/" + "index.html");
                    HTMLReport.generatePoolIndexHTML(poolName, status, (FileWriter)pool);
                }
                finally {
                    if (pool == null) continue;
                    try {
                        pool.flush();
                        pool.close();
                    }
                    catch (Exception e) {}
                }
            }
            HashSet<String> activeCLs = new HashSet<String>();
            for (Map<String, List<TraceEvent>> m : filteredPool.values()) {
                activeCLs.addAll(m.keySet());
            }
            for (Map.Entry<String, List<TraceEvent>> entry : filteredLifecycle.entrySet()) {
                OutputStreamWriter lifecycle = null;
                try {
                    path = root.getAbsolutePath() + "/" + entry.getKey();
                    f = new File(path);
                    f.mkdirs();
                    lifecycle = new FileWriter(path + "/" + "lifecycle.html");
                    HTMLReport.generateLifecycleHTML(entry.getKey(), entry.getValue(), activeCLs, (FileWriter)lifecycle);
                }
                finally {
                    if (lifecycle == null) continue;
                    try {
                        lifecycle.flush();
                        lifecycle.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (logReader != null) {
                try {
                    logReader.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

