/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.tracer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.jca.as.tracer.SDeditGenerator;
import org.jboss.jca.as.tracer.TraceEventHelper;
import org.jboss.jca.as.tracer.TraceEventStatus;
import org.jboss.jca.core.tracer.TraceEvent;

public class HTMLReport {
    static void writeString(FileWriter fw, String s) throws Exception {
        for (int i = 0; i < s.length(); ++i) {
            fw.write(s.charAt(i));
        }
    }

    static void writeEOL(FileWriter fw) throws Exception {
        fw.write(10);
    }

    private static void generateTopLevelIndexHTML(Set<String> poolNames, Map<String, TraceEventStatus> statuses, TraceEventStatus ccmStatus, Map<String, TraceEventStatus> ccmPoolStatuses, TraceEvent version, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>IronJacamar tracer report</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>IronJacamar tracer report</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Generated:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + new Date() + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Data:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>IronJacamar " + (version != null ? version.getPool() : "Unknown") + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>By:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>IronJacamar 1.2.4.Final</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Pool</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (String name : poolNames) {
            TraceEventStatus status = statuses.get(name);
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + name + "/index.html\"><div style=\"color: ");
            if (status != null) {
                HTMLReport.writeString(fw, status.getColor());
            } else {
                HTMLReport.writeString(fw, TraceEventStatus.GREEN.getColor());
            }
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, name);
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Lifecycle</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (String name : poolNames) {
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + name + "/lifecycle.html\">");
            HTMLReport.writeString(fw, name);
            HTMLReport.writeString(fw, "</a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Cached connection manager</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<li><a href=\"CachedConnectionManager/ccm.html\"><div style=\"color: ");
        HTMLReport.writeString(fw, ccmStatus.getColor());
        HTMLReport.writeString(fw, ";\">Main report</div></a></li>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (String name : poolNames) {
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + name + "/ccm.html\"><div style=\"color: ");
            TraceEventStatus ps = ccmPoolStatuses.get(name);
            if (ps != null) {
                HTMLReport.writeString(fw, ps.getColor());
            } else {
                HTMLReport.writeString(fw, TraceEventStatus.GREEN.getColor());
            }
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, name);
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Reference</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<li><a href=\"toc-c.html\">Connection</div></a></li>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<li><a href=\"toc-cl.html\">ConnectionListener</div></a></li>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<li><a href=\"toc-mcp.html\">Managed Connection Pool</div></a></li>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generatePoolIndexHTML(String poolName, TraceEventStatus overallStatus, Set<String> mcps, Map<String, TraceEventStatus> statuses, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>Pool: " + poolName + "</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Pool: " + poolName + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Status:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><div style=\"color: " + overallStatus.getColor() + ";\">");
        HTMLReport.writeString(fw, overallStatus.getDescription());
        HTMLReport.writeString(fw, "</div></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>");
        Iterator<String> mcpIt = mcps.iterator();
        while (mcpIt.hasNext()) {
            String mcp = mcpIt.next();
            HTMLReport.writeString(fw, mcp);
            if (!mcpIt.hasNext()) continue;
            HTMLReport.writeString(fw, "<br/>");
        }
        HTMLReport.writeString(fw, "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>ConnectionListeners</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (Map.Entry<String, TraceEventStatus> entry : statuses.entrySet()) {
            String directory = entry.getKey();
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + directory + "/index.html\"><div style=\"color: ");
            HTMLReport.writeString(fw, entry.getValue().getColor());
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, directory);
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Lifecycle</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"lifecycle.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Cached connection manager</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"ccm.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateConnectionListenerIndexHTML(String identifier, List<TraceEvent> data, boolean ignoreDelist, boolean ignoreTracking, String root, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>ConnectionListener: " + identifier + "</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>ConnectionListener: " + identifier + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Pool:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + data.get(0).getPool() + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + data.get(0).getManagedConnectionPool() + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Status:</b></td>");
        HTMLReport.writeEOL(fw);
        TraceEventStatus status = TraceEventHelper.getStatus(data, ignoreDelist, ignoreTracking);
        HTMLReport.writeString(fw, "<td><div style=\"color: " + status.getColor() + ";\">");
        HTMLReport.writeString(fw, status.getDescription());
        HTMLReport.writeString(fw, "</div></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Reports</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        Map<String, List<TraceEvent>> m = TraceEventHelper.split(data);
        for (Map.Entry<String, List<TraceEvent>> entry : m.entrySet()) {
            HTMLReport.writeString(fw, "<li>");
            HTMLReport.writeString(fw, "<a href=\"" + entry.getKey() + "/index.html\"><div style=\"color: ");
            status = TraceEventHelper.getStatus(entry.getValue(), ignoreDelist, ignoreTracking);
            HTMLReport.writeString(fw, status.getColor());
            HTMLReport.writeString(fw, ";\">");
            HTMLReport.writeString(fw, entry.getKey());
            HTMLReport.writeString(fw, "</div></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</li>");
            HTMLReport.writeEOL(fw);
            OutputStreamWriter cl = null;
            try {
                File f = new File(root + "/" + entry.getKey());
                f.mkdirs();
                cl = new FileWriter(f.getAbsolutePath() + "/" + "index.html");
                HTMLReport.generateConnectionListenerReportHTML(f.getCanonicalPath(), identifier, entry.getValue(), ignoreDelist, ignoreTracking, (FileWriter)cl);
            }
            finally {
                if (cl != null) {
                    try {
                        cl.flush();
                        cl.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (status != TraceEventStatus.GREEN) continue;
            OutputStreamWriter sdedit = null;
            try {
                File f = new File(root + "/" + entry.getKey());
                f.mkdirs();
                sdedit = new FileWriter(f.getAbsolutePath() + "/" + identifier + ".sdx");
                SDeditGenerator.generateSDedit(entry.getValue(), (FileWriter)sdedit);
            }
            finally {
                if (sdedit == null) continue;
                try {
                    sdedit.flush();
                    sdedit.close();
                }
                catch (Exception e) {}
            }
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateConnectionListenerReportHTML(String root, String identifier, List<TraceEvent> data, boolean ignoreDelist, boolean ignoreTracking, FileWriter fw) throws Exception {
        long startTime = data.get(0).getTimestamp();
        long endTime = data.get(data.size() - 1).getTimestamp();
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>ConnectionListener: " + identifier + " (" + startTime + "-" + endTime + ")</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>ConnectionListener: " + identifier + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Pool:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + data.get(0).getPool() + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + data.get(0).getManagedConnectionPool() + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>From:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + startTime + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>To:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + endTime + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Thread:</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td>" + data.get(0).getThreadId() + "</td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Status:</b></td>");
        HTMLReport.writeEOL(fw);
        TraceEventStatus status = TraceEventHelper.getStatus(data, ignoreDelist, ignoreTracking);
        HTMLReport.writeString(fw, "<td><div style=\"color: " + status.getColor() + ";\">");
        HTMLReport.writeString(fw, status.getDescription());
        HTMLReport.writeString(fw, "</div></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Sequence diagram</h2>");
        HTMLReport.writeEOL(fw);
        if (status == TraceEventStatus.GREEN) {
            HTMLReport.writeString(fw, "<image src=\"");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".png\" alt=\"SDedit image\"/>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<p/>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "Generate the image by: <i>sdedit -t png -o ");
            HTMLReport.writeString(fw, root);
            HTMLReport.writeString(fw, "/");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".png ");
            HTMLReport.writeString(fw, root);
            HTMLReport.writeString(fw, "/");
            HTMLReport.writeString(fw, identifier);
            HTMLReport.writeString(fw, ".sdx ");
            HTMLReport.writeString(fw, "</i>");
            HTMLReport.writeEOL(fw);
        } else {
            HTMLReport.writeString(fw, "See Description or Data for recorded data");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "<h2>Description</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<thead align=\"left\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<th>Timestamp</th>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<th>Description</th>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</thead>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tbody>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : data) {
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>");
            if (TraceEventHelper.isRed(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: red;\">");
            } else if (TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: yellow;\">");
            }
            HTMLReport.writeString(fw, Long.toString(te.getTimestamp()));
            if (TraceEventHelper.isRed(te) || TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "</div>");
            }
            HTMLReport.writeString(fw, "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>");
            if (TraceEventHelper.isRed(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: red;\">");
            } else if (TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "<div style=\"color: yellow;\">");
            }
            HTMLReport.writeString(fw, TraceEvent.asText((TraceEvent)te));
            if (TraceEventHelper.isRed(te) || TraceEventHelper.isYellow(te)) {
                HTMLReport.writeString(fw, "</div>");
            }
            HTMLReport.writeString(fw, "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</tbody>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        if (TraceEventHelper.hasException(data)) {
            HTMLReport.writeString(fw, "<h2>Exception</h2>");
            HTMLReport.writeEOL(fw);
            for (TraceEvent te : data) {
                if (te.getType() != 50) continue;
                HTMLReport.writeString(fw, "<pre>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, TraceEventHelper.exceptionDescription(te.getPayload1()));
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "</pre>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "<p/>");
                HTMLReport.writeEOL(fw);
            }
        }
        HTMLReport.writeString(fw, "<h2>Data</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<pre>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : data) {
            HTMLReport.writeString(fw, TraceEventHelper.prettyPrint(te));
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</pre>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateLifecycleHTML(String poolName, List<TraceEvent> events, Set<String> activeCLs, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>Lifecycle: " + poolName + "</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Lifecycle: " + poolName + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Timestamp</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Event</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ConnectionListener</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : events) {
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getTimestamp() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getManagedConnectionPool() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + TraceEvent.asText((TraceEvent)te) + "</td>");
            HTMLReport.writeEOL(fw);
            if (!"NONE".equals(te.getConnectionListener())) {
                if (activeCLs.contains(te.getConnectionListener())) {
                    HTMLReport.writeString(fw, "<td><a href=\"" + te.getConnectionListener() + "/index.html\">" + te.getConnectionListener() + "</a></td>");
                } else {
                    HTMLReport.writeString(fw, "<td>" + te.getConnectionListener() + "</td>");
                }
            } else {
                HTMLReport.writeString(fw, "<td></td>");
            }
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Pool</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"index.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Cached connection manager</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"ccm.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Data</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<pre>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : events) {
            HTMLReport.writeString(fw, TraceEventHelper.prettyPrint(te));
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</pre>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateCCMHTML(List<TraceEvent> events, TraceEventStatus status, String path, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>CachedConnectionManager</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>CachedConnectionManager</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Status:</b></td><td><div style=\"color: ");
        HTMLReport.writeString(fw, status.getColor());
        HTMLReport.writeString(fw, ";\">");
        HTMLReport.writeString(fw, status.getDescription());
        HTMLReport.writeString(fw, "</div></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Timestamp</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Event</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Key</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Call stack</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : events) {
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getTimestamp() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + TraceEvent.asText((TraceEvent)te) + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getPayload1() + "</td>");
            HTMLReport.writeEOL(fw);
            String callstack = te.getPayload1();
            callstack = te.getType() == 90 ? callstack + "-push" : callstack + "-pop";
            callstack = callstack + ".txt";
            HTMLReport.writeString(fw, "<td><a href=\"" + callstack + "\">Link</a></td>");
            HTMLReport.writeEOL(fw);
            OutputStreamWriter report = null;
            try {
                report = new FileWriter(path + "/" + callstack);
                HTMLReport.writeString((FileWriter)report, TraceEventHelper.exceptionDescription(te.getPayload2()));
                HTMLReport.writeEOL((FileWriter)report);
            }
            finally {
                if (report != null) {
                    try {
                        report.flush();
                        report.close();
                    }
                    catch (Exception e) {}
                }
            }
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateCCMPoolHTML(String poolName, List<TraceEvent> events, TraceEventStatus status, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>CCM: " + poolName + "</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>CCM: " + poolName + "</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Status:</b></td><td><div style=\"color: ");
        HTMLReport.writeString(fw, status.getColor());
        HTMLReport.writeString(fw, ";\">");
        HTMLReport.writeString(fw, status.getDescription());
        HTMLReport.writeString(fw, "</div></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Timestamp</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Event</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ConnectionListener</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Connection</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Key</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : events) {
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getTimestamp() + "</td>");
            HTMLReport.writeEOL(fw);
            if (!"NONE".equals(te.getManagedConnectionPool())) {
                HTMLReport.writeString(fw, "<td>" + te.getManagedConnectionPool() + "</td>");
            } else {
                HTMLReport.writeString(fw, "<td></td>");
            }
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + TraceEvent.asText((TraceEvent)te) + "</td>");
            HTMLReport.writeEOL(fw);
            if (!"NONE".equals(te.getConnectionListener())) {
                HTMLReport.writeString(fw, "<td><a href=\"" + te.getConnectionListener() + "/index.html\">" + te.getConnectionListener() + "</a></td>");
            } else {
                HTMLReport.writeString(fw, "<td></td>");
            }
            HTMLReport.writeEOL(fw);
            if (!"NONE".equals(te.getPayload1())) {
                HTMLReport.writeString(fw, "<td>" + te.getPayload1() + "</td>");
            } else {
                HTMLReport.writeString(fw, "<td></td>");
            }
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getPayload2() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Pool</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"index.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Lifecycle</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"lifecycle.html\">Report</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h2>Data</h2>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<pre>");
        HTMLReport.writeEOL(fw);
        for (TraceEvent te : events) {
            HTMLReport.writeString(fw, TraceEventHelper.prettyPrint(te));
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</pre>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"../index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateToCConnection(Map<String, List<TraceEvent>> events, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>Reference: Connection</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Reference: Connection</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<ul>");
        HTMLReport.writeEOL(fw);
        for (String string : events.keySet()) {
            HTMLReport.writeString(fw, "<li><a href=\"#" + string + "\">" + string + "</a></li>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</ul>");
        HTMLReport.writeEOL(fw);
        for (Map.Entry entry : events.entrySet()) {
            HTMLReport.writeString(fw, "<a name=\"" + (String)entry.getKey() + "\"><h2>" + (String)entry.getKey() + "</h2></a>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<table>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td><b>Timestamp</b></td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td><b>ConnectionListener</b></td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool</b></td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td><b>Pool</b></td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
            for (TraceEvent te : (List)entry.getValue()) {
                HTMLReport.writeString(fw, "<tr>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "<td>" + te.getTimestamp() + "</td>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "<td><a href=\"" + te.getPool() + "/" + te.getConnectionListener() + "/index.html\">" + te.getConnectionListener() + "</a></td>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "<td>" + te.getManagedConnectionPool() + "</td>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "<td><a href=\"" + te.getPool() + "/index.html\">" + te.getPool() + "</a></td>");
                HTMLReport.writeEOL(fw);
                HTMLReport.writeString(fw, "</tr>");
                HTMLReport.writeEOL(fw);
            }
            HTMLReport.writeString(fw, "</table>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<p/>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateToCConnectionListener(Map<String, List<TraceEvent>> events, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>Reference: ConnectionListener</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Reference: ConnectionListener</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ConnectionListener</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Pool</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        for (Map.Entry<String, List<TraceEvent>> entry : events.entrySet()) {
            TraceEvent te = entry.getValue().get(0);
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td><a href=\"" + te.getPool() + "/" + te.getConnectionListener() + "/index.html\">" + te.getConnectionListener() + "</a></td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getManagedConnectionPool() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td><a href=\"" + te.getPool() + "/index.html\">" + te.getPool() + "</a></td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    private static void generateToCManagedConnectionPool(Map<String, List<TraceEvent>> events, FileWriter fw) throws Exception {
        HTMLReport.writeString(fw, "<html>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<title>Reference: Managed Connection Pool</title>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</head>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<body style=\"background: #D7D7D7;\">");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<h1>Reference: Managed Connection Pool</h1>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<tr>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>ManagedConnectionPool</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<td><b>Pool</b></td>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</tr>");
        HTMLReport.writeEOL(fw);
        for (Map.Entry<String, List<TraceEvent>> entry : events.entrySet()) {
            TraceEvent te = entry.getValue().get(0);
            HTMLReport.writeString(fw, "<tr>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td>" + te.getManagedConnectionPool() + "</td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "<td><a href=\"" + te.getPool() + "/index.html\">" + te.getPool() + "</a></td>");
            HTMLReport.writeEOL(fw);
            HTMLReport.writeString(fw, "</tr>");
            HTMLReport.writeEOL(fw);
        }
        HTMLReport.writeString(fw, "</table>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<p/>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "<a href=\"index.html\">Back</a>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</body>");
        HTMLReport.writeEOL(fw);
        HTMLReport.writeString(fw, "</html>");
        HTMLReport.writeEOL(fw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args == null || args.length < 1) {
            System.out.println("Usage: HTMLReport [-ignore-delist] [-ignore-tracking] <file> [<output>]");
            return;
        }
        boolean ignoreDelist = false;
        boolean ignoreTracking = false;
        int argCount = 0;
        if ("-ignore-delist".equals(args[argCount])) {
            ignoreDelist = true;
            ++argCount;
        }
        if ("-ignore-tracking".equals(args[argCount])) {
            ignoreTracking = true;
            ++argCount;
        }
        File logFile = new File(args[argCount]);
        FileReader logReader = null;
        String rootDirectory = "report";
        if (args.length > argCount + 1) {
            rootDirectory = args[argCount + 1];
        }
        File root = new File(rootDirectory);
        try {
            String path;
            File f;
            String path2;
            logReader = new FileReader(logFile);
            root.mkdirs();
            List<TraceEvent> events = TraceEventHelper.getEvents(logReader, root);
            Map<String, Map<String, List<TraceEvent>>> filteredPool = TraceEventHelper.filterPoolEvents(events);
            Map<String, List<TraceEvent>> filteredLifecycle = TraceEventHelper.filterLifecycleEvents(events);
            List<TraceEvent> filteredCCM = TraceEventHelper.filterCCMEvents(events);
            Map<String, List<TraceEvent>> filteredCCMPool = TraceEventHelper.filterCCMPoolEvents(events);
            Map<String, Set<String>> poolMCPs = TraceEventHelper.poolManagedConnectionPools(events);
            Map<String, List<TraceEvent>> tocConnections = TraceEventHelper.tocConnections(events);
            Map<String, List<TraceEvent>> tocConnectionListeners = TraceEventHelper.tocConnectionListeners(events);
            Map<String, List<TraceEvent>> tocMCPs = TraceEventHelper.tocManagedConnectionPools(events);
            TraceEventStatus ccmStatus = TraceEventHelper.getCCMStatus(filteredCCM);
            TreeMap<String, TraceEventStatus> ccmPoolStatus = new TreeMap<String, TraceEventStatus>();
            for (Map.Entry<String, List<TraceEvent>> entry : filteredCCMPool.entrySet()) {
                ccmPoolStatus.put(entry.getKey(), TraceEventHelper.getCCMPoolStatus(entry.getValue()));
            }
            TreeMap<String, TraceEventStatus> topLevelStatus = new TreeMap<String, TraceEventStatus>();
            for (Map.Entry<String, Map<String, List<TraceEvent>>> entry : filteredPool.entrySet()) {
                Collection<List<TraceEvent>> values = entry.getValue().values();
                ArrayList<TraceEventStatus> status = new ArrayList<TraceEventStatus>();
                for (List<TraceEvent> l : values) {
                    status.add(TraceEventHelper.getStatus(l, ignoreDelist, ignoreTracking));
                }
                topLevelStatus.put(entry.getKey(), TraceEventHelper.mergeStatus(status));
            }
            OutputStreamWriter topLevel = null;
            try {
                topLevel = new FileWriter(root.getAbsolutePath() + "/" + "index.html");
                HTMLReport.generateTopLevelIndexHTML(filteredLifecycle.keySet(), topLevelStatus, ccmStatus, ccmPoolStatus, TraceEventHelper.getVersion(events), (FileWriter)topLevel);
            }
            finally {
                if (topLevel != null) {
                    try {
                        topLevel.flush();
                        topLevel.close();
                    }
                    catch (Exception e) {}
                }
            }
            for (String poolName : filteredLifecycle.keySet()) {
                Map<String, List<TraceEvent>> data = filteredPool.get(poolName);
                OutputStreamWriter pool = null;
                try {
                    path2 = root.getAbsolutePath() + "/" + poolName;
                    f = new File(path2);
                    f.mkdirs();
                    TreeMap<String, TraceEventStatus> status = new TreeMap<String, TraceEventStatus>();
                    if (data != null) {
                        for (Map.Entry<String, List<TraceEvent>> dataEntry : data.entrySet()) {
                            status.put(dataEntry.getKey(), TraceEventHelper.getStatus(dataEntry.getValue(), ignoreDelist, ignoreTracking));
                            String identifier = dataEntry.getKey();
                            OutputStreamWriter cl = null;
                            try {
                                String clPath = path2 + "/" + identifier;
                                File clF = new File(clPath);
                                clF.mkdirs();
                                cl = new FileWriter(clF.getAbsolutePath() + "/" + "index.html");
                                HTMLReport.generateConnectionListenerIndexHTML(identifier, dataEntry.getValue(), ignoreDelist, ignoreTracking, clPath, (FileWriter)cl);
                            }
                            finally {
                                if (cl == null) continue;
                                try {
                                    cl.flush();
                                    cl.close();
                                }
                                catch (Exception e) {}
                            }
                        }
                    }
                    pool = new FileWriter(f.getAbsolutePath() + "/" + "index.html");
                    HTMLReport.generatePoolIndexHTML(poolName, (TraceEventStatus)((Object)topLevelStatus.get(poolName)), poolMCPs.get(poolName), status, (FileWriter)pool);
                }
                finally {
                    if (pool == null) continue;
                    try {
                        pool.flush();
                        pool.close();
                    }
                    catch (Exception e) {}
                }
            }
            HashSet<String> activeCLs = new HashSet<String>();
            for (Map<String, List<TraceEvent>> m : filteredPool.values()) {
                activeCLs.addAll(m.keySet());
            }
            for (Map.Entry<String, List<TraceEvent>> entry : filteredLifecycle.entrySet()) {
                OutputStreamWriter lifecycle = null;
                try {
                    path2 = root.getAbsolutePath() + "/" + entry.getKey();
                    f = new File(path2);
                    f.mkdirs();
                    lifecycle = new FileWriter(path2 + "/" + "lifecycle.html");
                    HTMLReport.generateLifecycleHTML(entry.getKey(), entry.getValue(), activeCLs, (FileWriter)lifecycle);
                }
                finally {
                    if (lifecycle == null) continue;
                    try {
                        lifecycle.flush();
                        lifecycle.close();
                    }
                    catch (Exception e) {}
                }
            }
            if (filteredCCM.size() > 0) {
                OutputStreamWriter ccm = null;
                try {
                    String path3 = root.getAbsolutePath() + "/" + filteredCCM.get(0).getPool();
                    File f2 = new File(path3);
                    f2.mkdirs();
                    ccm = new FileWriter(path3 + "/" + "ccm.html");
                    HTMLReport.generateCCMHTML(filteredCCM, ccmStatus, path3, (FileWriter)ccm);
                }
                finally {
                    if (ccm != null) {
                        try {
                            ccm.flush();
                            ccm.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
            for (Map.Entry<String, List<TraceEvent>> entry : filteredCCMPool.entrySet()) {
                OutputStreamWriter ccm = null;
                try {
                    path = root.getAbsolutePath() + "/" + entry.getKey();
                    File f3 = new File(path);
                    f3.mkdirs();
                    ccm = new FileWriter(path + "/" + "ccm.html");
                    HTMLReport.generateCCMPoolHTML(entry.getKey(), entry.getValue(), (TraceEventStatus)((Object)ccmPoolStatus.get(entry.getKey())), (FileWriter)ccm);
                }
                finally {
                    if (ccm == null) continue;
                    try {
                        ccm.flush();
                        ccm.close();
                    }
                    catch (Exception e) {}
                }
            }
            OutputStreamWriter tocC = null;
            try {
                path2 = root.getAbsolutePath();
                tocC = new FileWriter(path2 + "/" + "toc-c.html");
                HTMLReport.generateToCConnection(tocConnections, (FileWriter)tocC);
            }
            finally {
                if (tocC != null) {
                    try {
                        tocC.flush();
                        tocC.close();
                    }
                    catch (Exception e) {}
                }
            }
            OutputStreamWriter tocCL = null;
            try {
                path = root.getAbsolutePath();
                tocCL = new FileWriter(path + "/" + "toc-cl.html");
                HTMLReport.generateToCConnectionListener(tocConnectionListeners, (FileWriter)tocCL);
            }
            finally {
                if (tocCL != null) {
                    try {
                        tocCL.flush();
                        tocCL.close();
                    }
                    catch (Exception e) {}
                }
            }
            OutputStreamWriter tocMCP = null;
            try {
                String path4 = root.getAbsolutePath();
                tocMCP = new FileWriter(path4 + "/" + "toc-mcp.html");
                HTMLReport.generateToCManagedConnectionPool(tocMCPs, (FileWriter)tocMCP);
            }
            finally {
                if (tocMCP != null) {
                    try {
                        tocMCP.flush();
                        tocMCP.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (logReader != null) {
                try {
                    logReader.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

