/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.tracer;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jboss.jca.as.tracer.HTMLReport;
import org.jboss.jca.as.tracer.TraceEventStatus;
import org.jboss.jca.core.tracer.TraceEvent;

public class TraceEventHelper {
    public static Map<String, Map<String, List<TraceEvent>>> filterPoolEvents(List<TraceEvent> data) throws Exception {
        TreeMap<String, Map<String, List<TraceEvent>>> result = new TreeMap<String, Map<String, List<TraceEvent>>>();
        for (TraceEvent te : data) {
            ArrayList<TraceEvent> l;
            if (te.getType() == 60 || te.getType() == 61 || te.getType() == 62 || te.getType() == 70 || te.getType() == 71 || te.getType() == 72 || te.getType() == 73 || te.getType() == 74 || te.getType() == 80 || te.getType() == 81 || te.getType() == 90 || te.getType() == 91 || te.getType() == 92 || te.getType() == 93 || te.getType() == 94 || te.getType() == 95 || te.getType() == 96 || te.getType() == 100) continue;
            TreeMap<String, ArrayList<TraceEvent>> m = (TreeMap<String, ArrayList<TraceEvent>>)result.get(te.getPool());
            if (m == null) {
                m = new TreeMap<String, ArrayList<TraceEvent>>();
            }
            if ((l = (ArrayList<TraceEvent>)m.get(te.getConnectionListener())) == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            m.put(te.getConnectionListener(), l);
            result.put(te.getPool(), m);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> filterLifecycleEvents(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 60 && te.getType() != 61 && te.getType() != 62 && te.getType() != 70 && te.getType() != 71 && te.getType() != 72 && te.getType() != 73 && te.getType() != 74 && te.getType() != 80 && te.getType() != 81) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getPool());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getPool(), l);
        }
        return result;
    }

    public static List<TraceEvent> filterCCMEvents(List<TraceEvent> data) throws Exception {
        ArrayList<TraceEvent> result = new ArrayList<TraceEvent>();
        for (TraceEvent te : data) {
            if (te.getType() != 90 && te.getType() != 91) continue;
            result.add(te);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> filterCCMPoolEvents(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 92 && te.getType() != 93 && te.getType() != 94 && te.getType() != 95 && te.getType() != 96) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getPool());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getPool(), l);
        }
        return result;
    }

    public static Map<String, Set<String>> poolManagedConnectionPools(List<TraceEvent> data) throws Exception {
        TreeMap<String, Set<String>> result = new TreeMap<String, Set<String>>();
        for (TraceEvent te : data) {
            if (te.getType() != 0 && te.getType() != 1 && te.getType() != 3 && te.getType() != 3) continue;
            TreeSet<String> s = (TreeSet<String>)result.get(te.getPool());
            if (s == null) {
                s = new TreeSet<String>();
            }
            s.add(te.getManagedConnectionPool());
            result.put(te.getPool(), s);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> tocConnections(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 40) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getPayload1());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getPayload1(), l);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> tocConnectionListeners(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 0 && te.getType() != 1 && te.getType() != 3 && te.getType() != 3) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getConnectionListener());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getConnectionListener(), l);
        }
        return result;
    }

    public static Map<String, List<TraceEvent>> tocManagedConnectionPools(List<TraceEvent> data) throws Exception {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        for (TraceEvent te : data) {
            if (te.getType() != 0 && te.getType() != 1 && te.getType() != 3 && te.getType() != 3) continue;
            ArrayList<TraceEvent> l = (ArrayList<TraceEvent>)result.get(te.getManagedConnectionPool());
            if (l == null) {
                l = new ArrayList<TraceEvent>();
            }
            l.add(te);
            result.put(te.getManagedConnectionPool(), l);
        }
        return result;
    }

    public static List<TraceEvent> getEvents(FileReader fr, File directory) throws Exception {
        return TraceEventHelper.getEvents(TraceEventHelper.getData(fr, directory));
    }

    public static Map<String, TraceEventStatus> getStatus(Map<String, List<TraceEvent>> input, boolean ignoreDelist, boolean ignoreTracking) {
        TreeMap<String, TraceEventStatus> result = new TreeMap<String, TraceEventStatus>();
        for (Map.Entry<String, List<TraceEvent>> entry : input.entrySet()) {
            result.put(entry.getKey(), TraceEventHelper.getStatus(entry.getValue(), ignoreDelist, ignoreTracking));
        }
        return result;
    }

    public static TraceEventStatus getStatus(List<TraceEvent> data, boolean ignoreDelist, boolean ignoreTracking) {
        TraceEventStatus explicit = null;
        HashSet<String> knownConnections = new HashSet<String>();
        boolean gotCl = false;
        boolean inTx = false;
        boolean gotClear = false;
        block26: for (TraceEvent te : data) {
            switch (te.getType()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (gotCl) {
                        explicit = TraceEventStatus.RED;
                    }
                    gotCl = true;
                    continue block26;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    if (!gotCl) {
                        explicit = TraceEventStatus.RED;
                    }
                    gotCl = false;
                    continue block26;
                }
                case 14: {
                    explicit = TraceEventStatus.RED;
                    continue block26;
                }
                case 20: {
                    if (inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = true;
                    continue block26;
                }
                case 22: {
                    if (inTx) {
                        explicit = TraceEventStatus.YELLOW;
                    }
                    inTx = true;
                    continue block26;
                }
                case 21: 
                case 23: {
                    explicit = inTx ? TraceEventStatus.RED : TraceEventStatus.YELLOW;
                    inTx = true;
                    continue block26;
                }
                case 30: 
                case 32: 
                case 34: {
                    if (!inTx) {
                        explicit = TraceEventStatus.RED;
                    }
                    inTx = false;
                    if (ignoreTracking || knownConnections.size() <= 0 || explicit == TraceEventStatus.RED) continue block26;
                    explicit = TraceEventStatus.YELLOW;
                    continue block26;
                }
                case 31: 
                case 33: {
                    explicit = !inTx ? TraceEventStatus.RED : TraceEventStatus.YELLOW;
                    inTx = false;
                    if (ignoreTracking || knownConnections.size() <= 0 || explicit == TraceEventStatus.RED) continue block26;
                    explicit = TraceEventStatus.YELLOW;
                    continue block26;
                }
                case 40: {
                    if (knownConnections.add(te.getPayload1())) continue block26;
                    explicit = TraceEventStatus.RED;
                    continue block26;
                }
                case 41: {
                    if (knownConnections.remove(te.getPayload1())) continue block26;
                    explicit = TraceEventStatus.RED;
                    continue block26;
                }
                case 42: {
                    gotClear = true;
                    continue block26;
                }
                case 50: {
                    continue block26;
                }
                case 60: {
                    continue block26;
                }
                case 61: {
                    continue block26;
                }
                case 62: {
                    continue block26;
                }
                case 70: {
                    continue block26;
                }
                case 71: {
                    continue block26;
                }
                case 72: {
                    continue block26;
                }
                case 73: {
                    continue block26;
                }
                case 74: {
                    continue block26;
                }
                case 80: {
                    continue block26;
                }
                case 81: {
                    continue block26;
                }
                case 92: {
                    continue block26;
                }
                case 93: {
                    continue block26;
                }
            }
            System.err.println("TraceEventHelper: Unknown code: " + te);
        }
        if (explicit != null) {
            return explicit;
        }
        if (gotCl) {
            return TraceEventStatus.RED;
        }
        if (inTx && !ignoreDelist) {
            return TraceEventStatus.RED;
        }
        if (knownConnections.size() > 0) {
            return TraceEventStatus.RED;
        }
        if (gotClear) {
            return TraceEventStatus.RED;
        }
        return TraceEventStatus.GREEN;
    }

    public static TraceEventStatus mergeStatus(List<TraceEventStatus> data) {
        TraceEventStatus result = TraceEventStatus.GREEN;
        for (TraceEventStatus tes : data) {
            if (tes == TraceEventStatus.YELLOW) {
                result = TraceEventStatus.YELLOW;
                continue;
            }
            if (tes != TraceEventStatus.RED) continue;
            return TraceEventStatus.RED;
        }
        return result;
    }

    public static boolean isStartState(TraceEvent te) {
        return te.getType() == 0 || te.getType() == 1 || te.getType() == 2 || te.getType() == 3 || te.getType() == 14;
    }

    public static boolean isEndState(TraceEvent te) {
        return te.getType() == 10 || te.getType() == 11 || te.getType() == 12 || te.getType() == 13 || te.getType() == 14;
    }

    public static boolean isRed(TraceEvent te) {
        return te.getType() == 42 || te.getType() == 14;
    }

    public static boolean isYellow(TraceEvent te) {
        return false;
    }

    public static Map<String, List<TraceEvent>> split(List<TraceEvent> data) {
        TreeMap<String, List<TraceEvent>> result = new TreeMap<String, List<TraceEvent>>();
        long start = 0L;
        ArrayList<TraceEvent> l = new ArrayList<TraceEvent>();
        for (int i = 0; i < data.size(); ++i) {
            TraceEvent te = data.get(i);
            l.add(te);
            if (start == 0L) {
                start = te.getTimestamp();
            }
            if (!TraceEventHelper.isEndState(te)) continue;
            result.put(Long.toString(start) + "-" + Long.toString(te.getTimestamp()), l);
            start = 0L;
            l = new ArrayList();
        }
        if (l.size() > 0) {
            result.put(Long.toString(start) + "-" + Long.toString(((TraceEvent)l.get(l.size() - 1)).getTimestamp()), l);
        }
        return result;
    }

    public static boolean hasException(List<TraceEvent> events) {
        for (TraceEvent te : events) {
            if (te.getType() != 50) continue;
            return true;
        }
        return false;
    }

    public static String exceptionDescription(String encoded) {
        char[] data = encoded.toCharArray();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            char c = data[i];
            sb = c == '|' ? sb.append('\n') : (c == '/' ? sb.append('\r') : (c == '\\' ? sb.append('\t') : (c == '_' ? sb.append(' ') : sb.append(c))));
        }
        return sb.toString();
    }

    public static String prettyPrint(TraceEvent te) {
        if (te.getType() != 50 && te.getType() != 90 && te.getType() != 91) {
            return te.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("IJTRACER");
        sb.append("-");
        sb.append(te.getPool());
        sb.append("-");
        sb.append(te.getThreadId());
        sb.append("-");
        sb.append(te.getType());
        sb.append("-");
        sb.append(te.getTimestamp());
        sb.append("-");
        sb.append(te.getConnectionListener());
        sb.append("-");
        sb.append("DATA");
        return sb.toString();
    }

    public static TraceEvent getVersion(List<TraceEvent> events) {
        for (TraceEvent te : events) {
            if (te.getType() != 100) continue;
            return te;
        }
        return null;
    }

    public static TraceEventStatus getCCMStatus(List<TraceEvent> data) {
        ArrayDeque<TraceEvent> stack = new ArrayDeque<TraceEvent>();
        for (TraceEvent te : data) {
            if (te.getType() == 90) {
                stack.push(te);
                continue;
            }
            TraceEvent top = (TraceEvent)stack.peek();
            if (top.getPayload1().equals(te.getPayload1())) {
                stack.pop();
                continue;
            }
            return TraceEventStatus.RED;
        }
        if (!stack.isEmpty()) {
            return TraceEventStatus.YELLOW;
        }
        return TraceEventStatus.GREEN;
    }

    public static TraceEventStatus getCCMPoolStatus(List<TraceEvent> data) {
        HashMap<String, HashSet<String>> m = new HashMap<String, HashSet<String>>();
        TraceEventStatus status = TraceEventStatus.GREEN;
        for (TraceEvent traceEvent : data) {
            Set<String> s;
            if (traceEvent.getType() == 92) {
                s = (HashSet<String>)m.get(traceEvent.getConnectionListener());
                if (s == null) {
                    s = new HashSet<String>();
                    m.put(traceEvent.getConnectionListener(), (HashSet<String>)s);
                }
                if (s.add(traceEvent.getPayload1())) continue;
                status = TraceEventStatus.YELLOW;
                continue;
            }
            if (traceEvent.getType() == 93) {
                s = (Set)m.get(traceEvent.getConnectionListener());
                if (s == null) {
                    s = new HashSet();
                    m.put(traceEvent.getConnectionListener(), (HashSet<String>)s);
                }
                if (s.remove(traceEvent.getPayload1())) continue;
                status = TraceEventStatus.YELLOW;
                continue;
            }
            if (traceEvent.getType() == 95) {
                return TraceEventStatus.RED;
            }
            if (traceEvent.getType() != 96) continue;
            status = TraceEventStatus.YELLOW;
        }
        for (Map.Entry entry : m.entrySet()) {
            if (((Set)entry.getValue()).size() <= 0) continue;
            return TraceEventStatus.RED;
        }
        return status;
    }

    static boolean hasMoreApplicationEvents(List<TraceEvent> events, int index) {
        if (index < 0 || index >= events.size()) {
            return false;
        }
        for (int j = index; j < events.size(); ++j) {
            TraceEvent te = events.get(j);
            if (te.getType() != 40 && te.getType() != 41) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getData(FileReader fr, File directory) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(fr);
        String s = r.readLine();
        while (s != null) {
            if (s.indexOf("IJTRACER") != -1) {
                result.add(s.substring(s.indexOf("IJTRACER")));
            }
            s = r.readLine();
        }
        OutputStreamWriter fw = null;
        try {
            fw = new FileWriter(directory.getAbsolutePath() + "/" + "raw.txt");
            for (String data : result) {
                HTMLReport.writeString((FileWriter)fw, data);
                HTMLReport.writeEOL((FileWriter)fw);
            }
        }
        finally {
            if (fw != null) {
                try {
                    fw.flush();
                    fw.close();
                }
                catch (IOException ignore) {}
            }
        }
        return result;
    }

    private static List<TraceEvent> getEvents(List<String> data) throws Exception {
        ArrayList<TraceEvent> result = new ArrayList<TraceEvent>();
        for (String s : data) {
            result.add(TraceEvent.parse((String)s));
        }
        return result;
    }
}

