/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.rarinfo;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.jca.as.rarinfo.RaImpl;
import org.jboss.jca.as.rarinfo.SecurityActions;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.MessageListener;
import org.jboss.jca.common.api.metadata.spec.RequiredConfigProperty;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.common.CredentialImpl;
import org.jboss.jca.common.metadata.common.PoolImpl;
import org.jboss.jca.common.metadata.common.SecurityImpl;
import org.jboss.jca.common.metadata.common.XaPoolImpl;
import org.jboss.jca.common.metadata.resourceadapter.AdminObjectImpl;
import org.jboss.jca.common.metadata.resourceadapter.ConnectionDefinitionImpl;
import org.jboss.jca.common.metadata.spec.RaParser;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScanner;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScannerFactory;
import org.jboss.jca.core.util.Injection;
import org.jboss.jca.validator.Validation;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Main {
    private static final int SUCCESS = 0;
    private static final int ERROR = 1;
    private static final int OTHER = 2;
    private static final String REPORT_FILE = "-report.txt";
    private static final String RAXML_FILE = "META-INF/ra.xml";
    private static final String tempdir = System.getProperty("java.io.tmpdir");
    private static final String subdir = "/jca/";
    private static Set<Class<?>> validTypes;
    private static final String ARGS_CP = "-classpath";
    private static final String ARGS_STDOUT = "--stdout";
    private static final String ARGS_OUT = "-o";
    private static File root;

    private static void loadNativeLibraries(File root) {
        if (root != null && root.exists()) {
            ArrayList<String> libs = null;
            if (root.isDirectory()) {
                if (root.listFiles() != null) {
                    for (File f : root.listFiles()) {
                        String fileName = f.getName().toLowerCase(Locale.US);
                        if (!fileName.endsWith(".a") && !fileName.endsWith(".so") && !fileName.endsWith(".dll")) continue;
                        if (libs == null) {
                            libs = new ArrayList<String>();
                        }
                        libs.add(f.getAbsolutePath());
                    }
                } else {
                    System.out.println("Root is a directory, but there were an I/O error: " + root.getAbsolutePath());
                }
            }
            if (libs != null) {
                for (String lib : libs) {
                    try {
                        SecurityActions.load(lib);
                        System.out.println("Loaded library: " + lib);
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                        System.out.println("Unable to load library: " + lib);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        int argsLength = args.length;
        PrintStream out = null;
        ZipFile zipFile = null;
        URLClassLoader cl = null;
        try {
            String poolName;
            Map<String, String> introspected;
            String version;
            if (argsLength < 1) {
                Main.usage();
                System.exit(2);
            }
            String rarFile = "";
            Object[] cps = null;
            boolean stdout = false;
            String reportFile = "";
            for (int i = 0; i < argsLength; ++i) {
                String arg = args[i];
                if (arg.equals(ARGS_CP)) {
                    cps = args[++i].split(System.getProperty("path.separator"));
                    continue;
                }
                if (arg.equals(ARGS_STDOUT)) {
                    stdout = true;
                    continue;
                }
                if (arg.equals(ARGS_OUT)) {
                    reportFile = args[++i];
                    continue;
                }
                if (arg.endsWith("rar")) {
                    rarFile = arg;
                    continue;
                }
                Main.usage();
                System.exit(2);
            }
            zipFile = new ZipFile(rarFile);
            boolean exsitNativeFile = false;
            Connector connector = null;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<String> xmls = new ArrayList<String>();
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry ze = zipEntries.nextElement();
                String name = ze.getName();
                names.add(name);
                if (name.endsWith(".xml") && name.startsWith("META-INF") && !name.endsWith("pom.xml")) {
                    xmls.add(name);
                }
                if (name.endsWith(".so") || name.endsWith(".a") || name.endsWith(".dll")) {
                    exsitNativeFile = true;
                }
                if (!name.equals(RAXML_FILE)) continue;
                InputStream raIn = zipFile.getInputStream(ze);
                RaParser parser = new RaParser();
                connector = parser.parse(raIn);
                raIn.close();
            }
            root = Main.getRoot(rarFile);
            Main.loadNativeLibraries(root);
            cl = Main.loadClass((String[])cps);
            if (Main.scanArchive(connector)) {
                Annotations annotator = new Annotations();
                AnnotationScanner scanner = AnnotationScannerFactory.getAnnotationScanner();
                AnnotationRepository repository = scanner.scan(cl.getURLs(), (ClassLoader)cl);
                connector = annotator.merge(connector, repository, (ClassLoader)cl);
            }
            if (connector == null) {
                System.out.println("can't parse ra.xml");
                System.exit(2);
            }
            out = stdout ? System.out : (!reportFile.isEmpty() ? new PrintStream(reportFile) : new PrintStream(rarFile.substring(0, rarFile.length() - 4) + REPORT_FILE));
            int sep = rarFile.lastIndexOf(File.separator);
            String archiveFile = sep > 0 ? rarFile.substring(sep + 1) : rarFile;
            out.println("Archive:\t" + archiveFile);
            String type = "";
            ResourceAdapter ra = connector.getResourceadapter();
            boolean reauth = false;
            if (connector.getVersion() == Connector.Version.V_10) {
                version = "1.0";
                type = "OutBound";
                reauth = ra.getOutboundResourceadapter().getReauthenticationSupport();
            } else {
                version = connector.getVersion() == Connector.Version.V_15 ? "1.5" : (connector.getVersion() == Connector.Version.V_16 ? "1.6" : "1.7");
                if (ra.getOutboundResourceadapter() != null) {
                    reauth = ra.getOutboundResourceadapter().getReauthenticationSupport();
                    type = ra.getInboundResourceadapter() != null && ra.getInboundResourceadapter().getMessageadapter() != null && ra.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && ra.getInboundResourceadapter().getMessageadapter().getMessagelisteners().size() > 0 ? "Bidirectional" : "OutBound";
                } else if (ra.getInboundResourceadapter() != null) {
                    type = "InBound";
                } else {
                    out.println("Rar file has problem");
                    System.exit(1);
                }
            }
            out.println("JCA version:\t" + version);
            out.println("Type:\t\t" + type);
            if ((type.equals("Bidirectional") || type.equals("OutBound")) && ra.getOutboundResourceadapter() != null) {
                out.println("Transaction:\t" + ra.getOutboundResourceadapter().getTransactionSupport());
            }
            out.print("Reauth:\t\t");
            if (reauth) {
                out.println("Yes");
            } else {
                out.println("No");
            }
            int systemExitCode = Validation.validate((URL)new File(rarFile).toURI().toURL(), (String)".", (String[])cps);
            String compliant = systemExitCode == 0 ? "Yes" : "No";
            out.println("Compliant:\t" + compliant);
            out.print("Native:\t\t");
            if (exsitNativeFile) {
                out.println("Yes");
            } else {
                out.println("No");
            }
            if (cps != null) {
                out.print("Extra Classpath: ");
                out.println(Arrays.toString(cps).replaceAll("\\[|\\]", ""));
            }
            Collections.sort(names);
            out.println();
            out.println("Structure:");
            out.println("----------");
            for (String name : names) {
                out.println(name);
            }
            String mcfClassName = "";
            HashMap<String, String> raConfigProperties = null;
            TransactionSupportEnum transSupport = TransactionSupportEnum.NoTransaction;
            ArrayList<AdminObjectImpl> adminObjects = null;
            ArrayList<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition> connDefs = null;
            SecurityImpl secImpl = new SecurityImpl("", "", true);
            PoolImpl poolImpl = new PoolImpl(Integer.valueOf(0), null, Integer.valueOf(10), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, null);
            XaPoolImpl xaPoolImpl = new XaPoolImpl(Integer.valueOf(0), null, Integer.valueOf(10), Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, null, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL);
            if (ra.getResourceadapterClass() != null && !ra.getResourceadapterClass().equals("")) {
                out.println();
                out.println("Resource-adapter:");
                out.println("-----------------");
                out.println("Class: " + ra.getResourceadapterClass());
                introspected = Main.getIntrospectedProperties(ra.getResourceadapterClass(), cl);
                if (ra.getConfigProperties() != null) {
                    raConfigProperties = new HashMap<String, String>();
                    for (ConfigProperty configProperty : ra.getConfigProperties()) {
                        raConfigProperties.put(Main.getValueString(configProperty.getConfigPropertyName()), Main.getValueString(configProperty.getConfigPropertyValue()));
                        Main.removeIntrospectedValue(introspected, Main.getValueString(configProperty.getConfigPropertyName()));
                        out.println("  Config-property: " + Main.getValueString(configProperty.getConfigPropertyName()) + " (" + Main.getValueString(configProperty.getConfigPropertyType()) + ")");
                    }
                }
                if (introspected != null && !introspected.isEmpty()) {
                    for (Map.Entry entry : introspected.entrySet()) {
                        out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                    }
                }
                if (introspected == null) {
                    out.println("  Unable to resolve introspected config-property's");
                }
            }
            int line = 0;
            HashSet<String> hashSet = new HashSet<String>();
            boolean needPrint = true;
            if (ra.getOutboundResourceadapter() != null) {
                out.println();
                out.println("Managed-connection-factory:");
                out.println("---------------------------");
                if (ra.getOutboundResourceadapter().getConnectionDefinitions() != null) {
                    connDefs = new ArrayList<org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition>();
                }
                transSupport = ra.getOutboundResourceadapter().getTransactionSupport();
                for (ConnectionDefinition mcf : ra.getOutboundResourceadapter().getConnectionDefinitions()) {
                    ConnectionDefinitionImpl connImpl;
                    mcfClassName = Main.getValueString(mcf.getManagedConnectionFactoryClass());
                    if (!hashSet.contains(mcfClassName)) {
                        hashSet.add(mcfClassName);
                        if (line != 0) {
                            out.println();
                        }
                        ++line;
                        out.println("Class: " + mcfClassName);
                        needPrint = true;
                    } else {
                        needPrint = false;
                    }
                    if (needPrint) {
                        Main.hasValidatingMcfInterface(out, mcfClassName, cl);
                        Main.hasResourceAdapterAssociation(out, mcfClassName, cl);
                        Main.hasMcfTransactionSupport(out, mcfClassName, cl);
                        Main.hasDissociatableMcInterface(out, mcfClassName, cl, mcf.getConfigProperties());
                        Main.hasEnlistableMcInterface(out, mcfClassName, cl, mcf.getConfigProperties());
                        String cfi = Main.getValueString(mcf.getConnectionFactoryInterface());
                        try {
                            out.print("  CCI: ");
                            Class<?> clazz = Class.forName(cfi, true, cl);
                            if (Main.isCCI(cfi, clazz, mcfClassName, cl)) {
                                out.println("Yes");
                            } else {
                                out.println("No");
                                out.println("  ConnectionFactory (" + cfi + "):");
                                Main.outputMethodInfo(out, clazz, cl);
                                Class<?> clazz2 = Class.forName(Main.getValueString(mcf.getConnectionInterface()), true, cl);
                                out.println("  Connection (" + Main.getValueString(mcf.getConnectionInterface()) + "):");
                                Main.outputMethodInfo(out, clazz2, cl);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace(System.err);
                            out.println("Unknown");
                        }
                    }
                    HashMap<String, String> configProperty = null;
                    if (mcf.getConfigProperties() != null) {
                        configProperty = new HashMap<String, String>();
                    }
                    introspected = Main.getIntrospectedProperties(mcfClassName, cl);
                    for (ConfigProperty configProperty2 : mcf.getConfigProperties()) {
                        configProperty.put(Main.getValueString(configProperty2.getConfigPropertyName()), Main.getValueString(configProperty2.getConfigPropertyValue()));
                        Main.removeIntrospectedValue(introspected, Main.getValueString(configProperty2.getConfigPropertyName()));
                        if (!needPrint) continue;
                        out.println("  Config-property: " + Main.getValueString(configProperty2.getConfigPropertyName()) + " (" + Main.getValueString(configProperty2.getConfigPropertyType()) + ")");
                    }
                    if (introspected != null && !introspected.isEmpty()) {
                        for (Map.Entry entry : introspected.entrySet()) {
                            if (!needPrint) continue;
                            out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                        }
                    }
                    if (introspected == null) {
                        out.println("  Unable to resolve introspected config-property's");
                    }
                    poolName = Main.getValueString(mcf.getConnectionInterface()).substring(Main.getValueString(mcf.getConnectionInterface()).lastIndexOf(46) + 1);
                    Object var38_58 = null;
                    if (transSupport.equals((Object)TransactionSupportEnum.XATransaction)) {
                        XaPoolImpl xaPoolImpl2 = xaPoolImpl;
                        Recovery recovery = new Recovery((Credential)new CredentialImpl(null, null, "domain"), null, Boolean.valueOf(false));
                        connImpl = new ConnectionDefinitionImpl(configProperty, mcfClassName, "java:jboss/eis/" + poolName, poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT, Defaults.USE_CCM, Defaults.SHARABLE, Defaults.ENLISTMENT, Defaults.CONNECTABLE, Defaults.TRACKING, (Pool)xaPoolImpl2, null, null, (Security)secImpl, recovery, Boolean.TRUE);
                    } else {
                        PoolImpl poolImpl2 = poolImpl;
                        connImpl = new ConnectionDefinitionImpl(configProperty, mcfClassName, "java:jboss/eis/" + poolName, poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT, Defaults.USE_CCM, Defaults.SHARABLE, Defaults.ENLISTMENT, Defaults.CONNECTABLE, Defaults.TRACKING, (Pool)poolImpl2, null, null, (Security)secImpl, null, Boolean.FALSE);
                    }
                    connDefs.add((org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition)connImpl);
                }
            }
            line = 0;
            hashSet.clear();
            if (ra.getAdminObjects() != null && ra.getAdminObjects().size() > 0) {
                out.println();
                out.println("Admin-object:");
                out.println("-------------");
                adminObjects = new ArrayList<AdminObjectImpl>();
                for (AdminObject ao : ra.getAdminObjects()) {
                    void var38_64;
                    String aoClassname = Main.getValueString(ao.getAdminobjectClass());
                    if (!hashSet.contains(aoClassname)) {
                        hashSet.add(aoClassname);
                        if (line != 0) {
                            out.println();
                        }
                        ++line;
                        out.println("Class: " + aoClassname);
                        Main.hasResourceAdapterAssociation(out, aoClassname, cl);
                        out.println("  Interface: " + Main.getValueString(ao.getAdminobjectInterface()));
                        needPrint = true;
                    } else {
                        needPrint = false;
                    }
                    poolName = aoClassname.substring(aoClassname.lastIndexOf(46) + 1);
                    Object var38_62 = null;
                    if (ao.getConfigProperties() != null) {
                        HashMap hashMap = new HashMap();
                    }
                    introspected = Main.getIntrospectedProperties(aoClassname, cl);
                    for (ConfigProperty configProperty : ao.getConfigProperties()) {
                        var38_64.put(Main.getValueString(configProperty.getConfigPropertyName()), Main.getValueString(configProperty.getConfigPropertyValue()));
                        Main.removeIntrospectedValue(introspected, Main.getValueString(configProperty.getConfigPropertyName()));
                        if (!needPrint) continue;
                        out.println("  Config-property: " + Main.getValueString(configProperty.getConfigPropertyName()) + " (" + Main.getValueString(configProperty.getConfigPropertyType()) + ")");
                    }
                    if (introspected != null && !introspected.isEmpty()) {
                        for (Map.Entry entry : introspected.entrySet()) {
                            if (!needPrint) continue;
                            out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                        }
                    }
                    if (introspected == null) {
                        out.println("  Unable to resolve introspected config-property's");
                    }
                    AdminObjectImpl aoImpl = new AdminObjectImpl((Map)var38_64, aoClassname, "java:jboss/eis/ao/" + poolName, poolName, Defaults.ENABLED, Defaults.USE_JAVA_CONTEXT);
                    adminObjects.add(aoImpl);
                }
            }
            line = 0;
            hashSet.clear();
            if (ra.getInboundResourceadapter() != null && ra.getInboundResourceadapter().getMessageadapter() != null && ra.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && ra.getInboundResourceadapter().getMessageadapter().getMessagelisteners().size() > 0) {
                out.println();
                out.println("Activation-spec:");
                out.println("----------------");
                for (MessageListener ml : ra.getInboundResourceadapter().getMessageadapter().getMessagelisteners()) {
                    String asClassname = Main.getValueString(ml.getActivationspec().getActivationspecClass());
                    if (hashSet.contains(asClassname)) continue;
                    hashSet.add(asClassname);
                    if (line != 0) {
                        out.println();
                    }
                    ++line;
                    out.println("Class: " + asClassname);
                    out.println("  Message-listener: " + Main.getValueString(ml.getMessagelistenerType()));
                    introspected = Main.getIntrospectedProperties(asClassname, cl);
                    if (ml.getActivationspec() != null && ml.getActivationspec().getRequiredConfigProperties() != null) {
                        for (RequiredConfigProperty requiredConfigProperty : ml.getActivationspec().getRequiredConfigProperties()) {
                            Main.removeIntrospectedValue(introspected, Main.getValueString(requiredConfigProperty.getConfigPropertyName()));
                            out.println("  Required-config-property: " + Main.getValueString(requiredConfigProperty.getConfigPropertyName()));
                        }
                    }
                    if (introspected != null && !introspected.isEmpty()) {
                        for (Map.Entry entry : introspected.entrySet()) {
                            out.println("  Introspected Config-property: " + (String)entry.getKey() + " (" + (String)entry.getValue() + ")");
                        }
                    }
                    if (introspected != null) continue;
                    out.println("  Unable to resolve introspected config-property's");
                }
            }
            RaImpl raImpl = new RaImpl(archiveFile, transSupport, connDefs, adminObjects, raConfigProperties);
            raImpl.buildResourceAdapterImpl();
            Main.outputMenifest("META-INF/MANIFEST.MF", out);
            Main.outputXmlDesc(xmls, out);
            Main.outputRaDesc(raImpl, out);
            System.out.println("Done.");
            System.exit(0);
        }
        catch (Throwable t) {
            System.err.println("Error: " + t.getMessage());
            t.printStackTrace(System.err);
            System.exit(1);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ioe) {}
            }
            if (cl != null) {
                try {
                    cl.close();
                }
                catch (Exception ioe) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception ioe) {}
            }
            Main.cleanupTempFiles();
        }
    }

    private static void outputMethodInfo(PrintStream out, Class<?> clazz, URLClassLoader cl) throws ClassNotFoundException {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            out.print("    " + Main.singleName(method.getReturnType().getCanonicalName()) + " " + method.getName() + "(");
            Class<?>[] params = method.getParameterTypes();
            for (int i = 0; i < params.length; ++i) {
                out.print(Main.singleName(params[i].getCanonicalName()));
                if (i + 1 >= params.length) continue;
                out.print(", ");
            }
            out.print(") ");
            Class<?>[] exceptions = method.getExceptionTypes();
            if (exceptions.length > 0) {
                out.print("throws ");
                for (int i = 0; i < exceptions.length; ++i) {
                    out.print(Main.singleName(exceptions[i].getCanonicalName()));
                    if (i + 1 >= exceptions.length) continue;
                    out.print(", ");
                }
            }
            out.println();
        }
    }

    private static String singleName(String className) {
        int lastPos = className.lastIndexOf(".");
        if (lastPos < 0) {
            return className;
        }
        return className.substring(lastPos + 1);
    }

    private static void hasValidatingMcfInterface(PrintStream out, String classname, URLClassLoader cl) {
        try {
            out.print("  Validating: ");
            Class<?> clazz = Class.forName(classname, true, cl);
            if (Main.hasInterface(clazz, "javax.resource.spi.ValidatingManagedConnectionFactory")) {
                out.println("Yes");
            } else {
                out.println("No");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            out.println("Unknown");
        }
    }

    private static void hasResourceAdapterAssociation(PrintStream out, String classname, URLClassLoader cl) {
        try {
            out.print("  Association: ");
            Class<?> clazz = Class.forName(classname, true, cl);
            if (Main.hasInterface(clazz, "javax.resource.spi.ResourceAdapterAssociation")) {
                out.println("Yes");
            } else {
                out.println("No");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            out.println("Unknown");
        }
    }

    private static void hasMcfTransactionSupport(PrintStream out, String classname, URLClassLoader cl) {
        try {
            out.print("  TransactionSupport: ");
            Class<?> mcfClz = Class.forName(classname, true, cl);
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfClz.newInstance();
            if (Main.hasInterface(mcf.getClass(), "javax.resource.spi.TransactionSupport")) {
                out.println("Yes");
            } else {
                out.println("No");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            out.println("Unknown");
        }
    }

    private static void hasDissociatableMcInterface(PrintStream out, String classname, URLClassLoader cl, List<? extends ConfigProperty> listConfProp) {
        Main.hasMcInterface(out, classname, cl, listConfProp, "DissociatableManagedConnection", "Sharable");
    }

    private static void hasEnlistableMcInterface(PrintStream out, String classname, URLClassLoader cl, List<? extends ConfigProperty> listConfProp) {
        Main.hasMcInterface(out, classname, cl, listConfProp, "LazyEnlistableManagedConnection", "Enlistment");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hasMcInterface(PrintStream out, String classname, URLClassLoader cl, List<? extends ConfigProperty> listConfProp, String mcClassName, String tip) {
        ManagedConnection mcClz = null;
        try {
            out.print("  " + tip + ": ");
            Class<?> mcfClz = Class.forName(classname, true, cl);
            ManagedConnectionFactory mcf = (ManagedConnectionFactory)mcfClz.newInstance();
            Injection injector = new Injection();
            for (ConfigProperty configProperty : listConfProp) {
                if (XsdString.isNull((XsdString)configProperty.getConfigPropertyValue())) continue;
                injector.inject((Object)mcf, configProperty.getConfigPropertyName().getValue(), (Object)configProperty.getConfigPropertyValue().getValue(), configProperty.getConfigPropertyType().getValue());
            }
            mcClz = mcf.createManagedConnection(null, null);
            if (Main.hasInterface(mcClz.getClass(), "javax.resource.spi." + mcClassName)) {
                out.println("Yes");
            } else {
                out.println("No");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
            out.println("Unknown");
        }
        finally {
            if (mcClz != null) {
                try {
                    mcClz.destroy();
                }
                catch (ResourceException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void outputMenifest(String meniFile, PrintStream out) throws FileNotFoundException, IOException {
        out.println();
        out.println(meniFile + ":");
        for (int i = 0; i <= meniFile.length(); ++i) {
            out.print("-");
        }
        out.println();
        Main.outToFile(meniFile, out);
    }

    private static void outputXmlDesc(ArrayList<String> xmls, PrintStream out) throws FileNotFoundException, IOException {
        for (String xmlfile : xmls) {
            out.println();
            out.println(xmlfile + ":");
            for (int i = 0; i <= xmlfile.length(); ++i) {
                out.print("-");
            }
            out.println();
            Main.outToFile(xmlfile, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void outToFile(String fileName, PrintStream out) throws FileNotFoundException, IOException {
        Reader in = null;
        try {
            int nBytes;
            in = new FileReader(root.getAbsolutePath() + File.separator + fileName);
            char[] buffer = new char[4096];
            while ((nBytes = in.read(buffer)) > 0) {
                for (int i = 0; i < nBytes; ++i) {
                    if (buffer[i] == '\r') continue;
                    out.print(buffer[i]);
                }
            }
            out.flush();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isCCI(String cfi, Class<?> clazz, String mcfClassName, URLClassLoader cl) throws Exception {
        if (cfi.equals("javax.resource.cci.ConnectionFactory")) {
            return true;
        }
        if (Main.hasInterface(clazz, "javax.resource.cci.ConnectionFactory")) {
            return true;
        }
        Class<?> mcfClazz = Class.forName(mcfClassName, true, cl);
        Method m = mcfClazz.getMethod("createConnectionFactory", null);
        Class<ConnectionFactory> rt = m.getReturnType();
        if (rt.isAssignableFrom(ConnectionFactory.class)) {
            return true;
        }
        Object mcfInstance = mcfClazz.newInstance();
        Object result = m.invoke(mcfInstance, (Object[])null);
        return result instanceof ConnectionFactory;
    }

    private static void outputRaDesc(RaImpl raImpl, PrintStream out) throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        String raString = "<resource-adapters>" + raImpl.toString() + "</resource-adapters>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(raString)));
        out.println();
        out.println("Deployment descriptor:");
        out.println("----------------------");
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        serializer.transform(new DOMSource(doc), new StreamResult(out));
    }

    private static boolean scanArchive(Connector cmd) {
        if (cmd == null) {
            return true;
        }
        return (cmd.getVersion() == Connector.Version.V_16 || cmd.getVersion() == Connector.Version.V_17) && !cmd.isMetadataComplete();
    }

    private static File getRoot(String rarFile) {
        if (rarFile == null) {
            throw new IllegalArgumentException("Rar file name is null");
        }
        try {
            File f = new File(rarFile);
            if (f.isFile()) {
                File destination = new File(tempdir, subdir);
                return Main.extract(f, destination);
            }
            return f;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static URLClassLoader loadClass(String[] classpath) {
        try {
            URL[] allurls;
            URL[] urls = Main.getUrls(root);
            if (classpath != null && classpath.length > 0) {
                ArrayList<URL> listUrl = new ArrayList<URL>();
                for (URL u : urls) {
                    listUrl.add(u);
                }
                for (String jar : classpath) {
                    if (!jar.endsWith(".jar")) continue;
                    listUrl.add(new File(jar).toURI().toURL());
                }
                allurls = listUrl.toArray(new URL[listUrl.size()]);
            } else {
                allurls = urls;
            }
            URLClassLoader cl = SecurityActions.createURLCLassLoader(allurls, SecurityActions.getThreadContextClassLoader());
            return cl;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static void cleanupTempFiles() {
        File destination = new File(tempdir, subdir);
        if (destination.exists()) {
            try {
                Main.recursiveDelete(destination);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static boolean hasInterface(Class<?> clazz, String interfaceName) {
        for (Class<?> iface : Main.getAllInterfaces(clazz)) {
            if (!iface.getName().equals(interfaceName)) continue;
            return true;
        }
        return false;
    }

    private static List<Class<?>> getAllInterfaces(Class<?> cls) {
        if (cls == null) {
            return null;
        }
        LinkedHashSet interfacesFound = new LinkedHashSet();
        Main.getAllInterfaces(cls, interfacesFound);
        return new ArrayList(interfacesFound);
    }

    private static void getAllInterfaces(Class<?> cls, HashSet<Class<?>> interfacesFound) {
        while (cls != null) {
            Class<?>[] interfaces;
            for (Class<?> i : interfaces = cls.getInterfaces()) {
                if (!interfacesFound.add(i)) continue;
                Main.getAllInterfaces(i, interfacesFound);
            }
            cls = cls.getSuperclass();
        }
    }

    private static Map<String, String> getIntrospectedProperties(String clz, URLClassLoader cl) {
        TreeMap<String, String> result = null;
        try {
            Method[] methods;
            Class<?> c = Class.forName(clz, true, cl);
            result = new TreeMap<String, String>();
            for (Method m : methods = c.getMethods()) {
                if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1 || !Main.isValidType(m.getParameterTypes()[0])) continue;
                String name = m.getName().substring(3);
                name = name.length() == 1 ? name.toLowerCase(Locale.US) : name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
                String type = m.getParameterTypes()[0].getName();
                result.put(name, type);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        return result;
    }

    private static boolean isValidType(Class<?> type) {
        return validTypes.contains(type);
    }

    private static void removeIntrospectedValue(Map<String, String> m, String name) {
        if (m != null) {
            m.remove(name);
            name = name.length() == 1 ? name.toUpperCase(Locale.US) : name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
            m.remove(name);
            name = name.length() == 1 ? name.toLowerCase(Locale.US) : name.substring(0, 1).toLowerCase(Locale.US) + name.substring(1);
            m.remove(name);
        }
    }

    private static URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extract(File file, File directory) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        File target = new File(directory, file.getName());
        if (target.exists()) {
            Main.recursiveDelete(target);
        }
        if (!target.mkdirs()) {
            throw new IOException("Could not create " + target);
        }
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                File copy = new File(target, je.getName());
                if (!je.isDirectory()) {
                    BufferedInputStream in = null;
                    OutputStream out = null;
                    if (copy.getParentFile() != null && !copy.getParentFile().exists() && !copy.getParentFile().mkdirs()) {
                        throw new IOException("Could not create " + copy.getParentFile());
                    }
                    try {
                        int nBytes;
                        in = new BufferedInputStream(jar.getInputStream(je));
                        out = new BufferedOutputStream(new FileOutputStream(copy));
                        byte[] buffer = new byte[4096];
                        while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                            out.write(buffer, 0, nBytes);
                        }
                        out.flush();
                        continue;
                    }
                    finally {
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ignore) {}
                        try {
                            if (in == null) continue;
                            ((InputStream)in).close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                }
                if (!copy.exists()) {
                    if (copy.mkdirs()) continue;
                    throw new IOException("Could not create " + copy);
                }
                if (copy.isDirectory()) continue;
                throw new IOException(copy + " isn't a directory");
            }
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ignore) {}
        }
        return target;
    }

    private static void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Main.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    private static String getValueString(XsdString value) {
        if (value == null || value == XsdString.NULL_XSDSTRING) {
            return "";
        }
        return value.getValue();
    }

    private static void usage() {
        System.out.println("Usage:  ./rar-info.sh [-classpath <lib>[:<lib>]*] [--stdout] [-o <reportFile>] <file>");
    }

    static {
        root = null;
        validTypes = new HashSet();
        validTypes.add(Boolean.TYPE);
        validTypes.add(Boolean.class);
        validTypes.add(Byte.TYPE);
        validTypes.add(Byte.class);
        validTypes.add(Short.TYPE);
        validTypes.add(Short.class);
        validTypes.add(Integer.TYPE);
        validTypes.add(Integer.class);
        validTypes.add(Long.TYPE);
        validTypes.add(Long.class);
        validTypes.add(Float.TYPE);
        validTypes.add(Float.class);
        validTypes.add(Double.TYPE);
        validTypes.add(Double.class);
        validTypes.add(Character.TYPE);
        validTypes.add(Character.class);
        validTypes.add(String.class);
    }
}

