/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.as.tracer;

import java.util.List;
import org.jboss.jca.as.tracer.TraceEventHelper;
import org.jboss.jca.as.tracer.TraceEventStatus;
import org.jboss.jca.core.tracer.TraceEvent;

public class Interaction {
    private long thread;
    private String connectionListener;
    private long startTime;
    private long endTime;
    private List<TraceEvent> events;
    private TraceEventStatus status;
    private String transaction;

    public Interaction(long thread, long startTime, long endTime, List<TraceEvent> events, TraceEventStatus status) {
        this.thread = thread;
        this.startTime = startTime;
        this.endTime = endTime;
        this.events = events;
        this.status = status;
        this.transaction = null;
    }

    public long getThread() {
        return this.thread;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public List<TraceEvent> getEvents() {
        return this.events;
    }

    public TraceEventStatus getStatus() {
        return this.status;
    }

    public String getPool() {
        return this.events.get(0).getPool();
    }

    public String getManagedConnectionPool() {
        return this.events.get(0).getManagedConnectionPool();
    }

    public String getConnectionListener() {
        return this.events.get(0).getConnectionListener();
    }

    public String getTransaction() {
        if (this.transaction == null) {
            TraceEvent transactionEvent = TraceEventHelper.getType(this.events, 20, 21, 22, 23);
            this.transaction = transactionEvent != null ? transactionEvent.getPayload1() : "";
        }
        if (!"".equals(this.transaction)) {
            return this.transaction;
        }
        return null;
    }
}

