/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class AoInterfaceCodeGen
extends AbstractCodeGen {
    int numOfAo = 0;

    public AoInterfaceCodeGen() {
    }

    public AoInterfaceCodeGen(int num) {
        this.numOfAo = num;
    }

    public int getNumOfAo() {
        return this.numOfAo;
    }

    public void setNumOfAo(int numOfAo) {
        this.numOfAo = numOfAo;
    }

    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public interface " + this.getClassName(def));
        if (def.isAdminObjectImplRaAssociation()) {
            out.write(" extends Referenceable, Serializable");
        }
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeConfigProps(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        if (def.isAdminObjectImplRaAssociation()) {
            out.write("import java.io.Serializable;");
            this.writeEol(out);
            this.writeEol(out);
            out.write("import jakarta.resource.Referenceable;");
            this.writeEol(out);
        }
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAdminObjectInterface();
    }

    private void writeConfigProps(Definition def, Writer out, int indent) throws IOException {
        for (int i = 0; i < this.getConfigProps(def).size(); ++i) {
            String name = this.getConfigProps(def).get(i).getName();
            String upcaseName = this.upcaseFirst(name);
            this.writeIndent(out, indent);
            out.write("/** ");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Set " + name);
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @param " + name + " The value");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void set" + upcaseName + "(" + this.getConfigProps(def).get(i).getType() + " " + name + ");");
            this.writeEol(out);
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("/** ");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Get " + name);
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @return The value");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public " + this.getConfigProps(def).get(i).getType() + " get" + upcaseName + "();");
            this.writeEol(out);
            this.writeEol(out);
        }
    }

    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getAdminObjects().get(this.numOfAo).getAoConfigProps();
    }
}

