/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class ConnImplCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        out.write("public class " + this.getClassName(def) + " implements " + def.getConnInterfaceClass());
        this.writeLeftCurlyBracket(out, 0);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(" + this.getClassName(def) + ".class);");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDefaultConstructor(def, out, indent);
        this.writeMethod(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.jboss.logging.Logger;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getConnImplClass();
    }

    private void writeMethod(Definition def, Writer out, int indent) throws IOException {
        if (def.isDefineMethodInConnection()) {
            if (def.getMethods().size() > 0) {
                for (MethodForConnection method : def.getMethods()) {
                    this.writeIndent(out, indent);
                    out.write("/**");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" * call " + method.getMethodName());
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write(" */");
                    this.writeEol(out);
                    this.writeIndent(out, indent);
                    out.write("public " + method.getReturnType() + " " + method.getMethodName() + "(");
                    int paramSize = method.getParams().size();
                    for (int i = 0; i < paramSize; ++i) {
                        MethodParam param = method.getParams().get(i);
                        out.write(param.getType());
                        out.write(" ");
                        out.write(param.getName());
                        if (i + 1 >= paramSize) continue;
                        out.write(", ");
                    }
                    out.write(")");
                    int exceptionSize = method.getExceptionType().size();
                    for (int i = 0; i < exceptionSize; ++i) {
                        if (i == 0) {
                            out.write(" throws ");
                        }
                        String ex = method.getExceptionType().get(i);
                        out.write(ex);
                        if (i + 1 >= exceptionSize) continue;
                        out.write(", ");
                    }
                    this.writeLeftCurlyBracket(out, indent);
                    this.writeIndent(out, indent + 1);
                    out.write("log.debug(\"call " + method.getMethodName() + "\");");
                    this.writeEol(out);
                    if (!method.getReturnType().equals("void")) {
                        this.writeIndent(out, indent + 1);
                        out.write("return null;");
                        this.writeEol(out);
                    }
                    this.writeRightCurlyBracket(out, indent);
                }
            }
        } else {
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * call me");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void callMe()");
            this.writeLeftCurlyBracket(out, indent);
            this.writeIndent(out, indent + 1);
            out.write("log.debug(\"call callMe\");");
            this.writeRightCurlyBracket(out, indent);
        }
    }
}

