/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.BasicType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class TestCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("@RunWith(Arquillian.class)");
        this.writeEol(out);
        out.write("public class " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(" + this.getClassName(def) + ".class);");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static String deploymentName = \"" + this.getClassName(def) + "\";");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDeployment(def, out, indent);
        this.writeResource(def, out, indent);
        if (def.isDefineMethodInConnection()) {
            this.writeTestMethod(def, out, indent);
        } else {
            this.writeTestBasic(def, out, indent);
        }
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.util.UUID;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.annotation.Resource;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.jboss.arquillian.api.Deployment;");
        this.writeEol(out);
        out.write("import org.jboss.arquillian.junit.Arquillian;");
        this.writeEol(out);
        out.write("import org.jboss.logging.Logger;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.jboss.shrinkwrap.api.ShrinkWrap;");
        this.writeEol(out);
        out.write("import org.jboss.shrinkwrap.api.spec.JavaArchive;");
        this.writeEol(out);
        out.write("import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.junit.Test;");
        this.writeEol(out);
        out.write("import org.junit.runner.RunWith;");
        this.writeEol(out);
        out.write("import static org.junit.Assert.*;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return "ConnectorTestCase";
    }

    private void writeDeployment(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Define the deployment");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return The deployment archive");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Deployment");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public static ResourceAdapterArchive createDeployment()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("ResourceAdapterArchive raa =");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("ShrinkWrap.create(ResourceAdapterArchive.class, deploymentName + \".rar\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("JavaArchive ja = ShrinkWrap.create(JavaArchive.class, UUID.randomUUID().toString() + \".jar\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("ja.addClasses(");
        if (def.isUseRa()) {
            out.write(def.getRaClass() + ".class, ");
        }
        out.write(def.getMcfClass() + ".class, " + def.getMcClass() + ".class, " + def.getMcMetaClass() + ".class, " + def.getCmClass() + ".class, ");
        if (def.isUseCciConnection()) {
            out.write(def.getCciConnFactoryClass() + ".class, " + def.getCciConnFactoryClass() + ".class, " + def.getConnMetaClass() + ".class, " + def.getRaMetaClass() + ".class, " + def.getConnSpecClass() + ".class");
        } else {
            out.write(def.getCfInterfaceClass() + ".class, " + def.getCfClass() + ".class, " + def.getConnInterfaceClass() + ".class, " + def.getConnImplClass() + ".class");
        }
        out.write(");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("raa.addLibrary(ja);");
        this.writeEol(out);
        this.writeEol(out);
        if (!def.isUseAnnotation()) {
            this.writeIndent(out, indent + 1);
            out.write("raa.addManifestResource(\"META-INF/ra.xml\", \"ra.xml\");");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeIndent(out, indent + 1);
        out.write("return raa;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResource(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/** resource */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Resource(mappedName = \"java:/eis/" + this.getClassName(def) + "\")");
        this.writeEol(out);
        this.writeIndent(out, indent);
        if (def.isDefineMethodInConnection()) {
            out.write("private " + def.getCfInterfaceClass() + " connectionFactory;");
        } else {
            out.write("private Object connectionFactory;");
        }
        this.writeEol(out);
        this.writeEol(out);
    }

    private void writeTestBasic(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Test Basic");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception Throwable Thrown if case of an error");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Test");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void testBasic() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("assertNotNull(connectionFactory);");
        this.writeRightCurlyBracket(out, indent);
    }

    private void writeTestMethod(Definition def, Writer out, int indent) throws IOException {
        for (MethodForConnection method : def.getMethods()) {
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Test " + method.getMethodName());
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" *");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @exception Throwable Thrown if case of an error");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("@Test");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void test" + this.upcaseFirst(method.getMethodName()) + "() throws Throwable");
            this.writeLeftCurlyBracket(out, indent);
            this.writeIndent(out, indent + 1);
            out.write("assertNotNull(connectionFactory);");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write(def.getConnInterfaceClass() + " connection = connectionFactory.getConnection();");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("assertNotNull(connection);");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            if (!method.getReturnType().equals("void")) {
                out.write(method.getReturnType() + " result = ");
            }
            out.write("connection." + method.getMethodName() + "(");
            int paramSize = method.getParams().size();
            for (int i = 0; i < paramSize; ++i) {
                MethodParam param = method.getParams().get(i);
                out.write(BasicType.defaultValue(param.getType()));
                if (i + 1 >= paramSize) continue;
                out.write(", ");
            }
            out.write(");");
            this.writeRightCurlyBracket(out, indent);
            this.writeEol(out);
        }
    }
}

