/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.Profile;
import org.jboss.jca.codegenerator.Utils;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;
import org.jboss.jca.codegenerator.xml.BuildIvyXmlGen;
import org.jboss.jca.codegenerator.xml.BuildXmlGen;
import org.jboss.jca.codegenerator.xml.IvySettingsXmlGen;
import org.jboss.jca.codegenerator.xml.IvyXmlGen;
import org.jboss.jca.codegenerator.xml.PomXmlGen;
import org.jboss.jca.codegenerator.xml.RaXmlGen;

public class BaseProfile
implements Profile {
    @Override
    public void generate(Definition def) {
        this.generateRaCode(def);
        this.generateOutboundCode(def);
        this.generateInboundCode(def);
        this.generateTestCode(def);
        if (def.getBuild().equals("ivy")) {
            this.generateAntIvyXml(def, def.getOutputDir());
        } else if (def.getBuild().equals("maven")) {
            this.generateMavenXml(def, def.getOutputDir());
        } else {
            this.generateAntXml(def, def.getOutputDir());
        }
        this.generateRaXml(def, def.getOutputDir());
    }

    void generateRaCode(Definition def) {
        if (def.isUseRa()) {
            this.generateClassCode(def, "Ra");
        }
    }

    void generateOutboundCode(Definition def) {
        if (def.isSupportOutbound()) {
            this.generateClassCode(def, "Mcf");
            this.generateClassCode(def, "Mc");
            this.generateClassCode(def, "McMeta");
            this.generateClassCode(def, "Cm");
            if (!def.isUseCciConnection()) {
                this.generateClassCode(def, "CfInterface");
                this.generateClassCode(def, "Cf");
                this.generateClassCode(def, "ConnInterface");
                this.generateClassCode(def, "ConnImpl");
            } else {
                this.generateClassCode(def, "CciConn");
                this.generateClassCode(def, "CciConnFactory");
                this.generateClassCode(def, "ConnMeta");
                this.generateClassCode(def, "RaMeta");
                this.generateClassCode(def, "ConnSpec");
            }
        }
    }

    void generateInboundCode(Definition def) {
        if (def.isSupportInbound()) {
            this.generateClassCode(def, "Ml", true);
            this.generateClassCode(def, "As", true);
            this.generateClassCode(def, "Activation", true);
        }
    }

    void generateClassCode(Definition def, String className) {
        this.generateClassCode(def, className, false);
    }

    void generateClassCode(Definition def, String className, boolean inflow) {
        if (className == null || className.equals("")) {
            return;
        }
        try {
            String clazzName = this.getClass().getPackage().getName() + ".code." + className + "CodeGen";
            String javaFile = (String)Definition.class.getMethod("get" + className + "Class", new Class[0]).invoke((Object)def, (Object[])null) + ".java";
            FileWriter fw = null;
            fw = !inflow ? Utils.createSrcFile(javaFile, def.getRaPackage(), def.getOutputDir()) : Utils.createSrcFile(javaFile, def.getRaPackage() + ".inflow", def.getOutputDir());
            Class<?> clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            AbstractCodeGen codeGen = (AbstractCodeGen)clazz.newInstance();
            codeGen.generate(def, fw);
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void generateAntXml(Definition def, String outputDir) {
        try {
            FileWriter antfw = Utils.createFile("build.xml", outputDir);
            BuildXmlGen bxGen = new BuildXmlGen();
            bxGen.generate(def, antfw);
            antfw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generateAntIvyXml(Definition def, String outputDir) {
        try {
            FileWriter antfw = Utils.createFile("build.xml", outputDir);
            BuildIvyXmlGen bxGen = new BuildIvyXmlGen();
            bxGen.generate(def, antfw);
            antfw.close();
            FileWriter ivyfw = Utils.createFile("ivy.xml", outputDir);
            IvyXmlGen ixGen = new IvyXmlGen();
            ixGen.generate(def, ivyfw);
            ivyfw.close();
            FileWriter ivySettingsfw = Utils.createFile("ivy.settings.xml", outputDir);
            IvySettingsXmlGen isxGen = new IvySettingsXmlGen();
            isxGen.generate(def, ivySettingsfw);
            ivySettingsfw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generateMavenXml(Definition def, String outputDir) {
        try {
            FileWriter pomfw = Utils.createFile("pom.xml", outputDir);
            PomXmlGen pxGen = new PomXmlGen();
            pxGen.generate(def, pomfw);
            pomfw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    void generateRaXml(Definition def, String outputDir) {
        if (!def.isUseAnnotation()) {
            try {
                outputDir = outputDir + File.separatorChar + "src" + File.separatorChar + "main" + File.separatorChar + "resources";
                FileWriter rafw = Utils.createFile("ra.xml", outputDir + File.separatorChar + "META-INF");
                RaXmlGen raGen = this.getRaXmlGen(def);
                raGen.generate(def, rafw);
                rafw.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    RaXmlGen getRaXmlGen(Definition def) {
        return null;
    }

    void generateTestCode(Definition def) {
        if (!def.isSupportOutbound()) {
            return;
        }
        try {
            String clazzName = this.getClass().getPackage().getName() + ".code.TestCodeGen";
            String javaFile = "ConnectorTestCase.java";
            FileWriter fw = Utils.createTestFile(javaFile, def.getRaPackage(), def.getOutputDir());
            Class<?> clazz = Class.forName(clazzName, true, Thread.currentThread().getContextClassLoader());
            AbstractCodeGen codeGen = (AbstractCodeGen)clazz.newInstance();
            codeGen.generate(def, fw);
            fw.flush();
            fw.close();
            this.copyTestResourceFiles(def.getOutputDir(), "logging.properties");
            this.copyTestResourceFiles(def.getOutputDir(), "jndi.properties");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void copyTestResourceFiles(String outputDir, String filename) throws IOException {
        String testResourceDir = outputDir + "/src/test/resources";
        FileWriter fw = Utils.createFile(filename, testResourceDir);
        URL buildFile = BaseProfile.class.getResource("/" + filename + ".template");
        String buildString = Utils.readFileIntoString(buildFile);
        fw.write(buildString);
        fw.close();
    }
}

