/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.code.PropsCodeGen;

public class AsCodeGen
extends PropsCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        if (def.isUseAnnotation()) {
            out.write("@Activation(messageListeners = {" + def.getRaPackage() + ".inflow." + def.getMlClass() + ".class})");
            this.writeEol(out);
        }
        out.write("public class " + this.getClassName(def) + " implements ActivationSpec");
        this.writeLeftCurlyBracket(out, 0);
        this.writeEol(out);
        int indent = 1;
        this.writeIndent(out, indent);
        out.write("/** The logger */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(\"" + this.getClassName(def) + "\");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/** The resource adapter */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private ResourceAdapter ra;");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDefaultConstructor(def, out, indent);
        this.writeConfigProps(def, out, indent);
        this.writeValidate(def, out, indent);
        this.writeResourceAdapter(def, out, indent);
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ".inflow;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.io.PrintWriter;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.resource.ResourceException;");
        this.writeEol(out);
        out.write("import javax.resource.spi.Activation;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ActivationSpec;");
        this.writeEol(out);
        if (def.isUseAnnotation()) {
            out.write("import javax.resource.spi.ConfigProperty;");
            this.writeEol(out);
            out.write("import javax.resource.spi.Connector;");
            this.writeEol(out);
        }
        out.write("import javax.resource.spi.InvalidPropertyException;");
        this.writeEol(out);
        out.write("import javax.resource.spi.ResourceAdapter;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.util.logging.Logger;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return def.getAsClass();
    }

    @Override
    public List<ConfigPropType> getConfigProps(Definition def) {
        return def.getAsConfigProps();
    }

    private void writeValidate(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * This method may be called by a deployment tool to validate the overall");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * activation configuration information provided by the endpoint deployer.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @throws InvalidPropertyException indicates invalid onfiguration property settings.");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void validate() throws InvalidPropertyException");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call validate\");");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResourceAdapter(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Get the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public ResourceAdapter getResourceAdapter()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call getResourceAdapter\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Set the resource adapter");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @param ra The handle");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void setResourceAdapter(ResourceAdapter ra)");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("log.info(\"call setResourceAdapter\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("this.ra = ra;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }
}

