/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.jca.codegenerator.AdminObjectType;
import org.jboss.jca.codegenerator.BaseProfile;
import org.jboss.jca.codegenerator.BasicType;
import org.jboss.jca.codegenerator.ConfigPropType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.JCA10Profile;
import org.jboss.jca.codegenerator.JCA15Profile;
import org.jboss.jca.codegenerator.JCA16Profile;
import org.jboss.jca.codegenerator.McfDef;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.Utils;

public class Main {
    private static final int SUCCESS = 0;
    private static final int ERROR = 1;
    private static final int OTHER = 2;
    private static ResourceBundle rb = ResourceBundle.getBundle("codegenerator", Locale.getDefault());

    public static void main(String[] args) {
        String outputDir = "out";
        String defxml = null;
        int arg = 0;
        if (args.length > 0) {
            while (args.length > arg + 1) {
                if (args[arg].startsWith("-")) {
                    if (args[arg].equals("-o")) {
                        if (++arg >= args.length) {
                            Main.usage();
                            System.exit(2);
                        }
                        outputDir = args[arg];
                    } else if (args[arg].equals("-f")) {
                        if (++arg >= args.length) {
                            Main.usage();
                            System.exit(2);
                        }
                        defxml = args[arg];
                    }
                } else {
                    Main.usage();
                    System.exit(2);
                }
                ++arg;
            }
        }
        try {
            File out = new File(outputDir);
            Utils.recursiveDelete(out);
            Definition def = null;
            def = defxml == null ? Main.inputFromCommandLine() : Main.inputFromXml(defxml);
            if (def == null) {
                System.exit(1);
            }
            def.setOutputDir(outputDir);
            BaseProfile profile = def.getVersion().equals("1.6") ? new JCA16Profile() : (def.getVersion().equals("1.5") ? new JCA15Profile() : new JCA10Profile());
            profile.generate(def);
            if (def.getBuild().equals("ant")) {
                Main.copyAllJars(outputDir);
            }
            System.out.println(rb.getString("code.wrote"));
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private static Definition inputFromXml(String defxml) throws IOException, JAXBException {
        JAXBContext context = JAXBContext.newInstance((String)"org.jboss.jca.codegenerator");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Definition def = (Definition)unmarshaller.unmarshal(new File(defxml));
        return def;
    }

    private static Definition inputFromCommandLine() throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        Definition def = new Definition();
        HashSet<String> classes = new HashSet<String>();
        String version = null;
        do {
            System.out.print(rb.getString("profile.version") + "[1.6]: ");
            version = in.readLine();
            if (version != null && !version.equals("")) continue;
            version = "1.6";
        } while (!version.equals("1.6") && !version.equals("1.5") && !version.equals("1.0"));
        def.setVersion(version);
        def.setSupportOutbound(true);
        def.setSupportInbound(false);
        if (!version.equals("1.0")) {
            System.out.print(rb.getString("support.bound") + "[O]: ");
            String bound = in.readLine();
            if (!(bound == null || bound.equals("") || bound.equals("O") || bound.equals("o") || bound.equals("Outbound"))) {
                if (bound.equals("I") || bound.equals("i") || bound.equals("Inbound")) {
                    def.setSupportOutbound(false);
                    def.setSupportInbound(true);
                } else if (bound.equals("B") || bound.equals("b") || bound.equals("Bidirectional")) {
                    def.setSupportOutbound(true);
                    def.setSupportInbound(true);
                }
            }
        }
        System.out.print(rb.getString("package.name"));
        String packageName = in.readLine();
        def.setRaPackage(packageName);
        if (def.isSupportOutbound()) {
            System.out.print(rb.getString("support.transaction") + "[N]: ");
            String trans = in.readLine();
            if (trans == null || trans.equals("")) {
                def.setSupportTransaction("NoTransaction");
            } else if (trans.equals("L") || trans.equals("l") || trans.equals("LocalTransaction")) {
                def.setSupportTransaction("LocalTransaction");
            } else if (trans.equals("X") || trans.equals("x") || trans.equals("XATransaction")) {
                def.setSupportTransaction("XATransaction");
            } else {
                def.setSupportTransaction("NoTransaction");
            }
        }
        if (def.isSupportOutbound() && !version.equals("1.0")) {
            System.out.print(rb.getString("support.reauthentication") + "[N]: ");
            String reauth = in.readLine();
            if (reauth == null || reauth.equals("")) {
                def.setSupportReauthen(false);
            } else if (reauth.equals("Y") || reauth.equals("y") || reauth.equals("Yes")) {
                def.setSupportReauthen(true);
            } else {
                def.setSupportReauthen(false);
            }
        }
        if (version.equals("1.6")) {
            System.out.print(rb.getString("use.annotation") + "[Y]: ");
            String useAnnotation = in.readLine();
            if (useAnnotation == null) {
                def.setUseAnnotation(true);
            } else if (useAnnotation.equals("N") || useAnnotation.equals("n") || useAnnotation.equals("No")) {
                def.setUseAnnotation(false);
            } else {
                def.setUseAnnotation(true);
            }
        } else {
            def.setUseAnnotation(false);
        }
        if (def.isSupportOutbound() && !def.isSupportInbound() && (version.equals("1.6") || version.equals("1.5"))) {
            System.out.print(rb.getString("use.ra") + "[Y]: ");
            String useRa = in.readLine();
            if (useRa == null) {
                def.setUseRa(true);
            } else if (useRa.equals("N") || useRa.equals("n") || useRa.equals("No")) {
                def.setUseRa(false);
            } else {
                def.setUseRa(true);
            }
        } else if (version.equals("1.0")) {
            def.setUseRa(false);
        } else {
            def.setUseRa(true);
        }
        if (def.isUseRa() || def.isSupportInbound()) {
            System.out.print(rb.getString("ra.class.name"));
            System.out.print("[" + def.getRaClass() + "]: ");
            String raClassName = in.readLine();
            classes.add(raClassName);
            if (raClassName != null && !raClassName.equals("")) {
                def.setRaClass(raClassName);
                Main.setDefaultValue(def, raClassName, "ResourceAdapter");
                Main.setDefaultValue(def, raClassName, "Ra");
            }
            List<ConfigPropType> raProps = Main.inputProperties("ra", in, false);
            def.setRaConfigProps(raProps);
        }
        if (def.isSupportOutbound()) {
            boolean moreMcf;
            ArrayList<McfDef> mcfDefs = new ArrayList<McfDef>();
            def.setMcfDefs(mcfDefs);
            int mcfID = 1;
            do {
                McfDef mcfdef = new McfDef(mcfID, def);
                String mcfClassName = "";
                do {
                    System.out.print(rb.getString("mcf.class.name"));
                    System.out.print("[" + mcfdef.getMcfClass() + "]: ");
                } while (classes.contains(mcfClassName = in.readLine()));
                classes.add(mcfClassName);
                if (mcfClassName != null && !mcfClassName.equals("")) {
                    mcfdef.setMcfClass(mcfClassName);
                    Main.setDefaultValue(def, mcfClassName, mcfID + "ManagedConnectionfactory");
                    Main.setDefaultValue(def, mcfClassName, mcfID + "Mcf");
                }
                List<ConfigPropType> mcfProps = Main.inputProperties("mcf", in, false);
                mcfdef.setMcfConfigProps(mcfProps);
                if (def.isUseRa()) {
                    System.out.print(rb.getString("mcf.impl.raa") + "[Y]: ");
                    String raAssociation = in.readLine();
                    if (raAssociation == null || raAssociation.equals("")) {
                        mcfdef.setImplRaAssociation(true);
                    } else if (raAssociation.equals("Y") || raAssociation.equals("y") || raAssociation.equals("Yes")) {
                        mcfdef.setImplRaAssociation(true);
                    } else {
                        mcfdef.setImplRaAssociation(false);
                    }
                }
                String mcClassName = "";
                do {
                    System.out.print(rb.getString("mc.class.name"));
                    System.out.print("[" + mcfdef.getMcClass() + "]: ");
                } while (classes.contains(mcClassName = in.readLine()));
                classes.add(mcClassName);
                if (mcClassName != null && !mcClassName.equals("")) {
                    mcfdef.setMcClass(mcClassName);
                }
                System.out.print(rb.getString("mcf.use.cci") + "[N]: ");
                String useCciConnection = in.readLine();
                if (useCciConnection == null) {
                    mcfdef.setUseCciConnection(false);
                } else if (useCciConnection.equals("Y") || useCciConnection.equals("y") || useCciConnection.equals("Yes")) {
                    mcfdef.setUseCciConnection(true);
                } else {
                    mcfdef.setUseCciConnection(false);
                }
                if (!mcfdef.isUseCciConnection()) {
                    String cfInterfaceName = "";
                    do {
                        System.out.print(rb.getString("cf.interface.name"));
                        System.out.print("[" + mcfdef.getCfInterfaceClass() + "]: ");
                    } while (classes.contains(cfInterfaceName = in.readLine()));
                    classes.add(cfInterfaceName);
                    if (cfInterfaceName != null && !cfInterfaceName.equals("")) {
                        mcfdef.setCfInterfaceClass(cfInterfaceName);
                    }
                    String cfClassName = "";
                    do {
                        System.out.print(rb.getString("cf.class.name"));
                        System.out.print("[" + mcfdef.getCfClass() + "]: ");
                    } while (classes.contains(cfClassName = in.readLine()));
                    classes.add(cfClassName);
                    if (cfClassName != null && !cfClassName.equals("")) {
                        mcfdef.setCfClass(cfClassName);
                    }
                    String connInterfaceName = "";
                    do {
                        System.out.print(rb.getString("conn.interface.name"));
                        System.out.print("[" + mcfdef.getConnInterfaceClass() + "]: ");
                    } while (classes.contains(connInterfaceName = in.readLine()));
                    classes.add(connInterfaceName);
                    if (connInterfaceName != null && !connInterfaceName.equals("")) {
                        mcfdef.setConnInterfaceClass(connInterfaceName);
                    }
                    String connImplName = "";
                    do {
                        System.out.print(rb.getString("conn.class.name"));
                        System.out.print("[" + mcfdef.getConnImplClass() + "]: ");
                    } while (classes.contains(connImplName = in.readLine()));
                    classes.add(connImplName);
                    if (connImplName != null && !connImplName.equals("")) {
                        mcfdef.setConnImplClass(connImplName);
                    }
                    System.out.print(rb.getString("connection.method.support") + "[N]: ");
                    String supportMethod = in.readLine();
                    if (supportMethod == null) {
                        mcfdef.setDefineMethodInConnection(false);
                    } else if (supportMethod.equals("Y") || supportMethod.equals("y") || supportMethod.equals("Yes")) {
                        mcfdef.setDefineMethodInConnection(true);
                    } else {
                        mcfdef.setDefineMethodInConnection(false);
                    }
                    if (mcfdef.isDefineMethodInConnection()) {
                        mcfdef.setMethods(Main.inputMethod(in));
                    }
                }
                mcfDefs.add(mcfdef);
                ++mcfID;
                moreMcf = false;
                if (!def.getVersion().equals("1.5") && !def.getVersion().equals("1.6")) continue;
                System.out.print(rb.getString("more.mcf") + "[N]: ");
                String inputMoreMcf = in.readLine();
                if (inputMoreMcf == null || !inputMoreMcf.equals("Y") && !inputMoreMcf.equals("y") && !inputMoreMcf.equals("Yes")) continue;
                moreMcf = true;
            } while (moreMcf);
        }
        if (def.isSupportInbound()) {
            String mlClassName = "";
            do {
                System.out.print(rb.getString("ml.interface.name"));
                System.out.print("[" + def.getMlClass() + "]: ");
            } while (classes.contains(mlClassName = in.readLine()));
            classes.add(mlClassName);
            boolean defaultPackage = true;
            if (mlClassName != null && !mlClassName.equals("")) {
                def.setMlClass(mlClassName);
                if (mlClassName.indexOf(".") != -1) {
                    defaultPackage = false;
                } else {
                    Main.setDefaultValue(def, mlClassName, "MessageListener");
                    Main.setDefaultValue(def, mlClassName, "Ml");
                }
            }
            def.setDefaultPackageInbound(defaultPackage);
            String asClassName = "";
            do {
                System.out.print(rb.getString("as.class.name"));
                System.out.print("[" + def.getAsClass() + "]: ");
            } while (classes.contains(asClassName = in.readLine()));
            classes.add(asClassName);
            if (asClassName != null && !asClassName.equals("")) {
                def.setAsClass(asClassName);
            }
            List<ConfigPropType> asProps = Main.inputProperties("as", in, true);
            def.setAsConfigProps(asProps);
            String actiClassName = "";
            do {
                System.out.print(rb.getString("acti.class.name"));
                System.out.print("[" + def.getActivationClass() + "]: ");
            } while (classes.contains(actiClassName = in.readLine()));
            classes.add(actiClassName);
            if (actiClassName != null && !actiClassName.equals("")) {
                def.setActivationClass(actiClassName);
            }
        }
        System.out.print(rb.getString("gen.adminobject") + "[N]: ");
        String genAo = in.readLine();
        if (genAo == null) {
            def.setGenAdminObject(false);
        } else if (genAo.equals("Y") || genAo.equals("y") || genAo.equals("Yes")) {
            def.setGenAdminObject(true);
        } else {
            def.setGenAdminObject(false);
        }
        if (def.isGenAdminObject()) {
            System.out.print(rb.getString("adminobject.raa") + "[Y]: ");
            String aoRaAssociation = in.readLine();
            if (aoRaAssociation == null || aoRaAssociation.equals("")) {
                def.setAdminObjectImplRaAssociation(true);
            } else if (aoRaAssociation.equals("Y") || aoRaAssociation.equals("y") || aoRaAssociation.equals("Yes")) {
                def.setAdminObjectImplRaAssociation(true);
            } else {
                def.setAdminObjectImplRaAssociation(false);
            }
        }
        int numOfAo = 0;
        while (numOfAo >= 0 && def.isGenAdminObject()) {
            String strOrder = numOfAo > 0 ? Integer.valueOf(numOfAo).toString() : "";
            AdminObjectType aoType = new AdminObjectType();
            String aoInterfaceName = "";
            do {
                System.out.print(rb.getString("adminobject.interface.name"));
                System.out.print("[" + def.getDefaultValue() + strOrder + "AdminObjectInterface]: ");
            } while (classes.contains(aoInterfaceName = in.readLine()));
            classes.add(aoInterfaceName);
            if (aoInterfaceName != null && !aoInterfaceName.equals("")) {
                aoType.setAdminObjectInterface(aoInterfaceName);
            } else {
                aoType.setAdminObjectInterface(def.getDefaultValue() + strOrder + "AdminObjectInterface");
            }
            String aoClassName = "";
            do {
                System.out.print(rb.getString("adminobject.class.name"));
                System.out.print("[" + def.getDefaultValue() + strOrder + "AdminObjectImpl]: ");
            } while (classes.contains(aoClassName = in.readLine()));
            classes.add(aoClassName);
            if (aoClassName != null && !aoClassName.equals("")) {
                aoType.setAdminObjectClass(aoClassName);
            } else {
                aoType.setAdminObjectClass(def.getDefaultValue() + strOrder + "AdminObjectImpl");
            }
            List<ConfigPropType> aoProps = Main.inputProperties("adminobject", in, false);
            aoType.setAoConfigProps(aoProps);
            if (def.getAdminObjects() == null) {
                def.setAdminObjects(new ArrayList<AdminObjectType>());
            }
            def.getAdminObjects().add(aoType);
            System.out.print(rb.getString("gen.adminobject.other") + "[N]: ");
            String genAoAgain = in.readLine();
            if (genAoAgain == null) {
                numOfAo = -1;
                continue;
            }
            if (genAoAgain.equals("Y") || genAoAgain.equals("y") || genAoAgain.equals("Yes")) {
                ++numOfAo;
                continue;
            }
            numOfAo = -1;
        }
        if (!def.getVersion().equals("1.0") && def.isSupportOutbound() && !def.getMcfDefs().get(0).isUseCciConnection()) {
            System.out.print(rb.getString("gen.mbean") + "[Y]: ");
            String genMbean = in.readLine();
            if (genMbean == null) {
                def.setGenMbean(true);
            } else if (genMbean.equals("N") || genMbean.equals("n") || genMbean.equals("No")) {
                def.setGenMbean(false);
            } else {
                def.setGenMbean(true);
            }
        }
        System.out.print(rb.getString("build.env"));
        System.out.print("[" + def.getBuild() + "]: ");
        String buildEnv = in.readLine();
        if (buildEnv != null && !buildEnv.equals("")) {
            if (buildEnv.equalsIgnoreCase("i") || buildEnv.equalsIgnoreCase("ant+ivy") || buildEnv.equalsIgnoreCase("ivy")) {
                def.setBuild("ivy");
            } else if (buildEnv.equalsIgnoreCase("m") || buildEnv.equalsIgnoreCase("maven")) {
                def.setBuild("maven");
            } else {
                def.setBuild("ant");
            }
        } else {
            def.setBuild("ant");
        }
        return def;
    }

    private static void setDefaultValue(Definition def, String className, String stringvalue) {
        if (className.endsWith(stringvalue)) {
            def.setDefaultValue(className.substring(0, className.length() - stringvalue.length()));
        }
    }

    private static void copyAllJars(String outputDir) throws IOException {
        File out = new File(outputDir);
        String path = out.getAbsolutePath();
        String targetPath = path + File.separatorChar + "lib";
        String libPath = path + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + "lib";
        Utils.copyFolder(libPath, targetPath, "jar");
        String binPath = path + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + ".." + File.separatorChar + "bin";
        Utils.copyFolder(binPath, targetPath, "jar");
    }

    private static List<ConfigPropType> inputProperties(String classname, BufferedReader in, boolean supportRequired) throws IOException {
        ArrayList<ConfigPropType> props = new ArrayList<ConfigPropType>();
        while (true) {
            System.out.println(rb.getString(classname + ".config.properties"));
            System.out.print("    " + rb.getString("config.properties.name"));
            String name = in.readLine();
            if (name == null || name.equals("")) break;
            System.out.print("    " + rb.getString("config.properties.type"));
            String type = in.readLine();
            if (!BasicType.isBasicType(type)) {
                System.out.print(rb.getString("config.properties.type.tip") + " [");
                System.out.println(BasicType.allBasicType() + "]");
                continue;
            }
            System.out.print("    " + rb.getString("config.properties.value"));
            String value = in.readLine();
            boolean required = false;
            if (supportRequired) {
                System.out.print("    " + rb.getString("config.properties.required") + "[N]: ");
                String propRequired = in.readLine();
                required = propRequired == null ? false : propRequired.equals("Y") || propRequired.equals("y") || propRequired.equals("Yes");
            }
            System.out.println();
            ConfigPropType config = new ConfigPropType(name, type, value, required);
            props.add(config);
        }
        return props;
    }

    private static List<MethodForConnection> inputMethod(BufferedReader in) throws IOException {
        ArrayList<MethodForConnection> methods = new ArrayList<MethodForConnection>();
        while (true) {
            System.out.print("    " + rb.getString("connection.method.name"));
            String methodName = in.readLine();
            if (methodName == null || methodName.equals("")) break;
            MethodForConnection method = new MethodForConnection();
            method.setMethodName(methodName);
            System.out.print("    " + rb.getString("connection.method.return"));
            String methodReturn = in.readLine();
            if (methodReturn != null && !methodReturn.equals("")) {
                method.setReturnType(methodReturn);
            }
            while (true) {
                System.out.print("    " + rb.getString("connection.method.param.name"));
                String paramName = in.readLine();
                if (paramName == null || paramName.equals("")) break;
                String paramType = null;
                while (true) {
                    System.out.print("    " + rb.getString("connection.method.param.type"));
                    paramType = in.readLine();
                    if (BasicType.isBasicType(paramType) || BasicType.isPrimitiveType(paramType)) break;
                    System.out.print(rb.getString("config.properties.type.tip") + " [");
                    System.out.println(BasicType.allType() + "]");
                }
                MethodParam param = method.newParam(paramName, paramType);
                method.getParams().add(param);
            }
            while (true) {
                System.out.print("    " + rb.getString("connection.method.exception"));
                String exceptions = in.readLine();
                if (exceptions == null || exceptions.equals("")) break;
                method.getExceptionType().add(exceptions);
            }
            methods.add(method);
        }
        return methods;
    }

    private static void usage() {
        System.out.println("Usage: codegenerator [-o directory]");
    }
}

