/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.codegenerator.code;

import java.io.IOException;
import java.io.Writer;
import org.jboss.jca.codegenerator.BasicType;
import org.jboss.jca.codegenerator.Definition;
import org.jboss.jca.codegenerator.MethodForConnection;
import org.jboss.jca.codegenerator.MethodParam;
import org.jboss.jca.codegenerator.code.AbstractCodeGen;

public class TestCodeGen
extends AbstractCodeGen {
    @Override
    public void writeClassBody(Definition def, Writer out) throws IOException {
        int indent = 1;
        out.write("@RunWith(Arquillian.class)");
        this.writeEol(out);
        out.write("public class " + this.getClassName(def));
        this.writeLeftCurlyBracket(out, 0);
        this.writeIndent(out, indent);
        out.write("private static Logger log = Logger.getLogger(\"" + this.getClassName(def) + "\");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("private static String deploymentName = \"" + this.getClassName(def) + "\";");
        this.writeEol(out);
        this.writeEol(out);
        this.writeDeployment(def, out, indent);
        this.writeResource(def, out, indent);
        for (int num = 0; num < def.getMcfDefs().size(); ++num) {
            if (def.getMcfDefs().get(num).isDefineMethodInConnection()) {
                this.writeTestMethod(def, out, indent, num + 1);
                continue;
            }
            this.writeTestBasic(def, out, indent, num + 1);
        }
        this.writeRightCurlyBracket(out, 0);
    }

    @Override
    public void writeImport(Definition def, Writer out) throws IOException {
        out.write("package " + def.getRaPackage() + ";");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import java.util.UUID;");
        this.writeEol(out);
        out.write("import java.util.logging.Logger;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import javax.annotation.Resource;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.jboss.arquillian.container.test.api.Deployment;");
        this.writeEol(out);
        out.write("import org.jboss.arquillian.junit.Arquillian;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.jboss.shrinkwrap.api.ShrinkWrap;");
        this.writeEol(out);
        out.write("import org.jboss.shrinkwrap.api.spec.JavaArchive;");
        this.writeEol(out);
        out.write("import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import org.junit.Test;");
        this.writeEol(out);
        out.write("import org.junit.runner.RunWith;");
        this.writeEol(out);
        out.write("import static org.junit.Assert.*;");
        this.writeEol(out);
        this.writeEol(out);
        out.write("import " + def.getRaPackage() + ".*;");
        this.writeEol(out);
        this.writeEol(out);
    }

    @Override
    public String getClassName(Definition def) {
        return "ConnectorTestCase";
    }

    private void writeDeployment(Definition def, Writer out, int indent) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Define the deployment");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @return The deployment archive");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Deployment");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public static ResourceAdapterArchive createDeployment()");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("ResourceAdapterArchive raa =");
        this.writeEol(out);
        this.writeIndent(out, indent + 2);
        out.write("ShrinkWrap.create(ResourceAdapterArchive.class, deploymentName + \".rar\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("JavaArchive ja = ShrinkWrap.create(JavaArchive.class, UUID.randomUUID().toString() + \".jar\");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("ja.addClasses(");
        if (def.isUseRa()) {
            out.write(def.getRaClass() + ".class, ");
        }
        for (int num = 0; num < def.getMcfDefs().size(); ++num) {
            out.write(def.getMcfDefs().get(num).getMcfClass() + ".class, " + def.getMcfDefs().get(num).getMcClass() + ".class, ");
            if (def.getMcfDefs().get(num).isUseCciConnection()) {
                if (def.isUseRa()) {
                    out.write(def.getMcfDefs().get(num).getCciConnFactoryClass() + ".class, " + def.getMcfDefs().get(num).getCciConnFactoryClass() + ".class, " + def.getMcfDefs().get(num).getConnMetaClass() + ".class, " + def.getRaMetaClass() + ".class, " + def.getMcfDefs().get(num).getConnSpecClass() + ".class");
                } else {
                    out.write(def.getMcfDefs().get(num).getCciConnFactoryClass() + ".class, " + def.getMcfDefs().get(num).getCciConnFactoryClass() + ".class, " + def.getMcfDefs().get(num).getConnMetaClass() + ".class, " + def.getMcfDefs().get(num).getConnSpecClass() + ".class");
                }
            } else {
                out.write(def.getMcfDefs().get(num).getCfInterfaceClass() + ".class, " + def.getMcfDefs().get(num).getCfClass() + ".class, " + def.getMcfDefs().get(num).getConnInterfaceClass() + ".class, " + def.getMcfDefs().get(num).getConnImplClass() + ".class");
            }
            if (num >= def.getMcfDefs().size() - 1) continue;
            out.write(",");
            this.writeEol(out);
            this.writeIndent(out, indent + 2);
        }
        out.write(");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("raa.addAsLibrary(ja);");
        this.writeEol(out);
        this.writeEol(out);
        if (!def.isUseAnnotation()) {
            this.writeIndent(out, indent + 1);
            out.write("raa.addAsManifestResource(\"META-INF/ra.xml\", \"ra.xml\");");
            this.writeEol(out);
            this.writeEol(out);
        }
        this.writeIndent(out, indent + 1);
        out.write("raa.addAsManifestResource(\"META-INF/ironjacamar.xml\", \"ironjacamar.xml\");");
        this.writeEol(out);
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("return raa;");
        this.writeRightCurlyBracket(out, indent);
        this.writeEol(out);
    }

    private void writeResource(Definition def, Writer out, int indent) throws IOException {
        for (int num = 0; num < def.getMcfDefs().size(); ++num) {
            this.writeIndent(out, indent);
            out.write("/** Resource */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            if (def.getMcfDefs().get(num).isUseCciConnection()) {
                out.write("@Resource(mappedName = \"java:/eis/" + def.getMcfDefs().get(num).getCciConnFactoryClass() + "\")");
            } else {
                out.write("@Resource(mappedName = \"java:/eis/" + def.getMcfDefs().get(num).getCfInterfaceClass() + "\")");
            }
            this.writeEol(out);
            this.writeIndent(out, indent);
            if (def.getMcfDefs().get(num).isUseCciConnection()) {
                out.write("private javax.resource.cci.ConnectionFactory");
            } else {
                out.write("private " + def.getMcfDefs().get(num).getCfInterfaceClass());
            }
            out.write(" connectionFactory" + (num + 1) + ";");
            this.writeEol(out);
            this.writeEol(out);
        }
    }

    private void writeTestBasic(Definition def, Writer out, int indent, int num) throws IOException {
        this.writeIndent(out, indent);
        out.write("/**");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * Test getConnection");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" *");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" * @exception Throwable Thrown if case of an error");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write(" */");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("@Test");
        this.writeEol(out);
        this.writeIndent(out, indent);
        out.write("public void testGetConnection" + num + "() throws Throwable");
        this.writeLeftCurlyBracket(out, indent);
        this.writeIndent(out, indent + 1);
        out.write("assertNotNull(connectionFactory" + num + ");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        if (def.getMcfDefs().get(num - 1).isUseCciConnection()) {
            out.write("javax.resource.cci.Connection");
        } else {
            out.write(def.getMcfDefs().get(num - 1).getConnInterfaceClass());
        }
        out.write(" connection" + num + " = connectionFactory" + num + ".getConnection();");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("assertNotNull(connection" + num + ");");
        this.writeEol(out);
        this.writeIndent(out, indent + 1);
        out.write("connection" + num + ".close();");
        this.writeRightCurlyBracket(out, indent);
    }

    private void writeTestMethod(Definition def, Writer out, int indent, int num) throws IOException {
        for (MethodForConnection method : def.getMcfDefs().get(num - 1).getMethods()) {
            MethodParam param;
            int i;
            this.writeIndent(out, indent);
            out.write("/**");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * Test " + method.getMethodName());
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" *");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" * @exception Throwable Thrown if case of an error");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write(" */");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("@Test");
            this.writeEol(out);
            this.writeIndent(out, indent);
            out.write("public void test" + this.upcaseFirst(method.getMethodName()));
            int paramSize = method.getParams().size();
            if (paramSize == 0) {
                out.write("NoArg");
            } else {
                for (i = 0; i < paramSize; ++i) {
                    param = method.getParams().get(i);
                    out.write(this.upcaseFirst(param.getName()));
                    String type = param.getType();
                    if (type.indexOf(".") >= 0) {
                        type = type.substring(type.lastIndexOf(".") + 1);
                    }
                    out.write(type);
                }
            }
            out.write("() throws Throwable");
            this.writeLeftCurlyBracket(out, indent);
            this.writeIndent(out, indent + 1);
            out.write("assertNotNull(connectionFactory" + num + ");");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            if (def.getMcfDefs().get(num - 1).isUseCciConnection()) {
                out.write("javax.resource.cci.Connection");
            } else {
                out.write(def.getMcfDefs().get(num - 1).getConnInterfaceClass());
            }
            out.write(" connection" + num + " = connectionFactory" + num + ".getConnection();");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("assertNotNull(connection" + num + ");");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            if (!method.getReturnType().equals("void")) {
                out.write(method.getReturnType() + " result = ");
            }
            out.write("connection" + num + "." + method.getMethodName() + "(");
            for (i = 0; i < paramSize; ++i) {
                param = method.getParams().get(i);
                out.write(BasicType.defaultValue(param.getType()));
                if (i + 1 >= paramSize) continue;
                out.write(", ");
            }
            out.write(");");
            this.writeEol(out);
            this.writeIndent(out, indent + 1);
            out.write("connection" + num + ".close();");
            this.writeRightCurlyBracket(out, indent);
            this.writeEol(out);
        }
    }
}

