/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.ds.v12;

import java.util.Map;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.ds.v12.DsXaPool;
import org.jboss.jca.common.api.validator.ValidateException;

public class DsXaPoolImpl
extends org.jboss.jca.common.metadata.ds.v11.DsXaPoolImpl
implements DsXaPool {
    private static final long serialVersionUID = 3261597366235425250L;
    private final Integer initialPoolSize;
    protected final Capacity capacity;
    protected final Extension connectionListener;

    public DsXaPoolImpl(Integer minPoolSize, Integer initialPoolSize, Integer maxPoolSize, Boolean prefill, Boolean useStrictMin, FlushStrategy flushStrategy, Boolean isSameRmOverride, Boolean interleaving, Boolean padXid, Boolean wrapXaResource, Boolean noTxSeparatePool, Boolean allowMultipleUsers, Capacity capacity, Extension connectionListener) throws ValidateException {
        super(minPoolSize, maxPoolSize, prefill, useStrictMin, flushStrategy, isSameRmOverride, interleaving, padXid, wrapXaResource, noTxSeparatePool, allowMultipleUsers);
        this.initialPoolSize = initialPoolSize;
        this.capacity = capacity;
        this.connectionListener = connectionListener;
    }

    public Integer getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public Capacity getCapacity() {
        return this.capacity;
    }

    public Extension getConnectionListener() {
        return this.connectionListener;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.initialPoolSize == null ? 7 : 7 * this.initialPoolSize.hashCode());
        result = 31 * result + (this.capacity == null ? 7 : 7 * this.capacity.hashCode());
        result = 31 * result + (this.connectionListener == null ? 7 : 7 * this.connectionListener.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DsXaPoolImpl)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        DsXaPoolImpl other = (DsXaPoolImpl)obj;
        if (this.initialPoolSize == null ? other.initialPoolSize != null : !this.initialPoolSize.equals(other.initialPoolSize)) {
            return false;
        }
        if (this.capacity == null ? other.capacity != null : !this.capacity.equals((Object)other.capacity)) {
            return false;
        }
        return !(this.connectionListener == null ? other.connectionListener != null : !this.connectionListener.equals((Object)other.connectionListener));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<xa-pool>");
        if (this.minPoolSize != null) {
            sb.append("<").append(DsXaPool.Tag.MIN_POOL_SIZE).append(">");
            sb.append(this.minPoolSize);
            sb.append("</").append(DsXaPool.Tag.MIN_POOL_SIZE).append(">");
        }
        if (this.initialPoolSize != null) {
            sb.append("<").append(DsXaPool.Tag.INITIAL_POOL_SIZE).append(">");
            sb.append(this.initialPoolSize);
            sb.append("</").append(DsXaPool.Tag.INITIAL_POOL_SIZE).append(">");
        }
        if (this.maxPoolSize != null) {
            sb.append("<").append(DsXaPool.Tag.MAX_POOL_SIZE).append(">");
            sb.append(this.maxPoolSize);
            sb.append("</").append(DsXaPool.Tag.MAX_POOL_SIZE).append(">");
        }
        if (this.prefill != null) {
            sb.append("<").append(DsXaPool.Tag.PREFILL).append(">");
            sb.append(this.prefill);
            sb.append("</").append(DsXaPool.Tag.PREFILL).append(">");
        }
        if (this.useStrictMin != null) {
            sb.append("<").append(DsXaPool.Tag.USE_STRICT_MIN).append(">");
            sb.append(this.useStrictMin);
            sb.append("</").append(DsXaPool.Tag.USE_STRICT_MIN).append(">");
        }
        if (this.flushStrategy != null) {
            sb.append("<").append(DsXaPool.Tag.FLUSH_STRATEGY).append(">");
            sb.append(this.flushStrategy);
            sb.append("</").append(DsXaPool.Tag.FLUSH_STRATEGY).append(">");
        }
        if (this.allowMultipleUsers != null && this.allowMultipleUsers.booleanValue()) {
            sb.append("<").append(DsXaPool.Tag.ALLOW_MULTIPLE_USERS).append("/>");
        }
        if (this.capacity != null) {
            sb.append(this.capacity);
        }
        if (this.connectionListener != null) {
            sb.append("<").append(DsXaPool.Tag.CONNECTION_LISTENER);
            sb.append(" ").append(Extension.Attribute.CLASS_NAME).append("=\"");
            sb.append(this.connectionListener.getClassName()).append("\"");
            sb.append(">");
            if (this.connectionListener.getConfigPropertiesMap().size() > 0) {
                for (Map.Entry entry : this.connectionListener.getConfigPropertiesMap().entrySet()) {
                    sb.append("<").append(Extension.Tag.CONFIG_PROPERTY);
                    sb.append(" name=\"").append((String)entry.getKey()).append("\">");
                    sb.append((String)entry.getValue());
                    sb.append("</").append(Extension.Tag.CONFIG_PROPERTY).append(">");
                }
            }
            sb.append("</").append(DsXaPool.Tag.CONNECTION_LISTENER).append(">");
        }
        if (this.isSameRmOverride != null) {
            sb.append("<").append(DsXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
            sb.append(this.isSameRmOverride);
            sb.append("</").append(DsXaPool.Tag.IS_SAME_RM_OVERRIDE).append(">");
        }
        if (this.interleaving != null && Boolean.TRUE.equals(this.interleaving)) {
            sb.append("<").append(DsXaPool.Tag.INTERLEAVING).append("/>");
        }
        if (this.noTxSeparatePool != null && Boolean.TRUE.equals(this.noTxSeparatePool)) {
            sb.append("<").append(DsXaPool.Tag.NO_TX_SEPARATE_POOLS).append("/>");
        }
        if (this.padXid != null) {
            sb.append("<").append(DsXaPool.Tag.PAD_XID).append(">");
            sb.append(this.padXid);
            sb.append("</").append(DsXaPool.Tag.PAD_XID).append(">");
        }
        if (this.wrapXaResource != null) {
            sb.append("<").append(DsXaPool.Tag.WRAP_XA_RESOURCE).append(">");
            sb.append(this.wrapXaResource);
            sb.append("</").append(DsXaPool.Tag.WRAP_XA_RESOURCE).append(">");
        }
        sb.append("</xa-pool>");
        return sb.toString();
    }
}

