/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.common.metadata.spec;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.jca.common.api.metadata.CopyUtil;
import org.jboss.jca.common.api.metadata.CopyableMetaData;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.ConfigProperty;
import org.jboss.jca.common.api.metadata.spec.XsdString;
import org.jboss.jca.common.metadata.spec.XML;

public class AdminObjectImpl
implements AdminObject {
    private static final long serialVersionUID = 1L;
    private XsdString adminobjectInterface;
    private XsdString adminobjectClass;
    private List<ConfigProperty> configProperties;
    private String id;

    public AdminObjectImpl(XsdString adminobjectInterface, XsdString adminobjectClass, List<ConfigProperty> configProperty, String id) {
        this.adminobjectInterface = adminobjectInterface;
        if (!XsdString.isNull((XsdString)this.adminobjectInterface)) {
            this.adminobjectInterface.setTag(XML.AdminObjectTag.ADMINOBJECT_INTERFACE.toString());
        }
        this.adminobjectClass = adminobjectClass;
        if (!XsdString.isNull((XsdString)this.adminobjectClass)) {
            this.adminobjectClass.setTag(XML.AdminObjectTag.ADMINOBJECT_CLASS.toString());
        }
        this.configProperties = configProperty != null ? new ArrayList<ConfigProperty>(configProperty) : new ArrayList<ConfigProperty>(0);
        this.id = id;
    }

    public XsdString getAdminobjectInterface() {
        return this.adminobjectInterface;
    }

    public XsdString getAdminobjectClass() {
        return this.adminobjectClass;
    }

    public List<ConfigProperty> getConfigProperties() {
        return Collections.unmodifiableList(this.configProperties);
    }

    public synchronized void forceConfigProperties(List<ConfigProperty> newContents) {
        this.configProperties = newContents != null ? new ArrayList<ConfigProperty>(newContents) : new ArrayList<ConfigProperty>(0);
    }

    public String getId() {
        return this.id;
    }

    public CopyableMetaData copy() {
        return new AdminObjectImpl((XsdString)CopyUtil.clone((CopyableMetaData)this.adminobjectInterface), (XsdString)CopyUtil.clone((CopyableMetaData)this.adminobjectClass), CopyUtil.cloneList(this.configProperties), CopyUtil.cloneString((String)this.id));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.adminobjectClass == null ? 0 : this.adminobjectClass.hashCode());
        result = 31 * result + (this.adminobjectInterface == null ? 0 : this.adminobjectInterface.hashCode());
        result = 31 * result + (this.configProperties == null ? 0 : this.configProperties.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminObjectImpl)) {
            return false;
        }
        AdminObjectImpl other = (AdminObjectImpl)obj;
        if (this.adminobjectClass == null ? other.adminobjectClass != null : !this.adminobjectClass.equals((Object)other.adminobjectClass)) {
            return false;
        }
        if (this.adminobjectInterface == null ? other.adminobjectInterface != null : !this.adminobjectInterface.equals((Object)other.adminobjectInterface)) {
            return false;
        }
        if (this.configProperties == null ? other.configProperties != null : !this.configProperties.equals(other.configProperties)) {
            return false;
        }
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("<adminobject");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        sb.append(">");
        sb.append(this.adminobjectInterface);
        sb.append(this.adminobjectClass);
        if (this.configProperties != null) {
            for (ConfigProperty cp : this.configProperties) {
                sb.append(cp);
            }
        }
        sb.append("</adminobject>");
        return sb.toString();
    }
}

