/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.net.URL;
import java.util.Arrays;
import javax.resource.spi.ResourceAdapter;
import org.jboss.logging.Logger;

public class CommonDeployment {
    private final URL url;
    private final String deploymentName;
    private final boolean activateDeployment;
    private final ResourceAdapter resourceAdapter;
    private final Object[] cfs;
    private final ClassLoader cl;
    private final Logger log;
    private final String[] jndiNames;

    public CommonDeployment(URL url, String deploymentName, boolean activateDeployment, ResourceAdapter resourceAdapter, Object[] cfs, ClassLoader cl, Logger log, String[] jndiNames) {
        this.url = url;
        this.deploymentName = deploymentName;
        this.activateDeployment = activateDeployment;
        this.resourceAdapter = resourceAdapter;
        this.cfs = cfs != null ? Arrays.copyOf(cfs, cfs.length) : null;
        this.cl = cl;
        this.log = log;
        this.jndiNames = jndiNames != null ? Arrays.copyOf(jndiNames, jndiNames.length) : null;
    }

    public final URL getURL() {
        return this.url;
    }

    public final String getDeploymentName() {
        return this.deploymentName;
    }

    public final boolean isActivateDeployment() {
        return this.activateDeployment;
    }

    public final ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public final Object[] getCfs() {
        return this.cfs != null ? Arrays.copyOf(this.cfs, this.cfs.length) : null;
    }

    public final ClassLoader getCl() {
        return this.cl;
    }

    public final Logger getLog() {
        return this.log;
    }

    public final String[] getJndiNames() {
        return this.jndiNames != null ? Arrays.copyOf(this.jndiNames, this.jndiNames.length) : null;
    }
}

