/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.TransactionSupport;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.ds.CommonDataSource;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.ra.ConfigProperty;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.TxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolConfiguration;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.logging.Logger;

public abstract class AbstractDsDeployer {
    protected Logger log;
    protected TransactionManager transactionManager;
    protected MetadataRepository mdr;

    public AbstractDsDeployer(Logger log) {
        this.log = log;
        this.transactionManager = null;
        this.mdr = null;
    }

    public void setTransactionManager(TransactionManager value) {
        this.transactionManager = value;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setMetadataRepository(MetadataRepository value) {
        this.mdr = value;
    }

    public MetadataRepository getMetadataRepository() {
        return this.mdr;
    }

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, String uniqueJdbcLocalId, String uniqueJdbcXAId, DataSources dataSources, ClassLoader parentClassLoader) throws DeployException {
        try {
            Object cf;
            String jndiName;
            ArrayList<Object> cfs = new ArrayList<Object>(1);
            ArrayList<String> jndis = new ArrayList<String>(1);
            if (uniqueJdbcLocalId != null) {
                List ds = dataSources.getDataSource();
                if (ds != null) {
                    ClassLoader jdbcLocalDeploymentCl = this.getDeploymentClassLoader(uniqueJdbcLocalId);
                    for (DataSource dataSource : ds) {
                        try {
                            jndiName = dataSource.getJndiName();
                            if (dataSource.isUseJavaContext() != null && dataSource.isUseJavaContext().booleanValue() && !jndiName.startsWith("java:/")) {
                                jndiName = "java:/" + jndiName;
                            }
                            cf = this.deployDataSource(dataSource, jndiName, uniqueJdbcLocalId, jdbcLocalDeploymentCl);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("Error during the deployment of " + dataSource.getJndiName()), t);
                        }
                    }
                }
            } else if (dataSources.getDataSource() != null && dataSources.getDataSource().size() > 0) {
                this.log.error((Object)"Deployment of datasources disabled since jdbc-local.rar couldn't be found");
            }
            if (uniqueJdbcXAId != null) {
                List xads = dataSources.getXaDataSource();
                if (xads != null) {
                    ClassLoader jdbcXADeploymentCl = this.getDeploymentClassLoader(uniqueJdbcXAId);
                    for (XaDataSource xaDataSource : xads) {
                        try {
                            jndiName = xaDataSource.getJndiName();
                            if (xaDataSource.isUseJavaContext() != null && xaDataSource.isUseJavaContext().booleanValue() && !jndiName.startsWith("java:/")) {
                                jndiName = "java:/" + jndiName;
                            }
                            cf = this.deployXADataSource(xaDataSource, jndiName, uniqueJdbcXAId, jdbcXADeploymentCl);
                            this.bindConnectionFactory(deploymentName, jndiName, cf);
                            cfs.add(cf);
                            jndis.add(jndiName);
                        }
                        catch (Throwable t) {
                            this.log.error((Object)("Error during the deployment of " + xaDataSource.getJndiName()), t);
                        }
                    }
                }
            } else if (dataSources.getXaDataSource() != null && dataSources.getXaDataSource().size() > 0) {
                this.log.error((Object)"Deployment of XA datasources disabled since jdbc-xa.rar couldn't be found");
            }
            return new CommonDeployment(url, deploymentName, true, null, cfs.toArray(new Object[cfs.size()]), jndis.toArray(new String[jndis.size()]), null, null, null, parentClassLoader, this.log);
        }
        catch (Throwable t) {
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    private Object deployDataSource(DataSource ds, String jndiName, String uniqueId, ClassLoader cl) throws Throwable {
        this.log.debug((Object)("DataSource=" + ds));
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(uniqueId);
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        ResourceAdapter1516 ra1516 = (ResourceAdapter1516)md.getResourceadapter();
        List cds = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        PoolConfiguration pc = this.createPoolConfiguration(ds.getPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        PoolFactory pf = new PoolFactory();
        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, false);
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), null, null, null, null, null);
        cm.setJndiName(jndiName);
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private Object deployXADataSource(XaDataSource ds, String jndiName, String uniqueId, ClassLoader cl) throws Throwable {
        this.log.debug((Object)("XaDataSource=" + ds));
        Merger merger = new Merger();
        Connector md = this.mdr.getResourceAdapter(uniqueId);
        md = merger.mergeConnectorAndDs((CommonDataSource)ds, md);
        ResourceAdapter1516 ra1516 = (ResourceAdapter1516)md.getResourceadapter();
        List cds = ra1516.getOutboundResourceadapter().getConnectionDefinitions();
        ConnectionDefinition cd = (ConnectionDefinition)cds.get(0);
        ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(cd.getManagedConnectionFactoryClass().getValue(), cd.getConfigProperties(), cl);
        PoolConfiguration pc = this.createPoolConfiguration((CommonPool)ds.getXaPool(), (CommonTimeOut)ds.getTimeOut(), (CommonValidation)ds.getValidation());
        Boolean noTxSeparatePool = Boolean.FALSE;
        if (ds.getXaPool() != null && ds.getXaPool().isNoTxSeparatePool() != null) {
            noTxSeparatePool = ds.getXaPool().isNoTxSeparatePool();
        }
        PoolFactory pf = new PoolFactory();
        Pool pool = pf.create(PoolStrategy.ONE_POOL, mcf, pc, noTxSeparatePool.booleanValue());
        Integer allocationRetry = null;
        Long allocationRetryWaitMillis = null;
        Boolean interleaving = null;
        Integer xaResourceTimeout = null;
        Boolean isSameRMOverride = null;
        Boolean wrapXAResource = null;
        Boolean padXid = null;
        if (ds.getTimeOut() != null) {
            allocationRetry = ds.getTimeOut().getAllocationRetry();
            allocationRetryWaitMillis = ds.getTimeOut().getAllocationRetryWaitMillis();
            xaResourceTimeout = ds.getTimeOut().getXaResourceTimeout();
        }
        if (ds.getXaPool() != null) {
            interleaving = ds.getXaPool().isInterleaving();
            isSameRMOverride = ds.getXaPool().isSameRmOverride();
            wrapXAResource = ds.getXaPool().isWrapXaDataSource();
            padXid = ds.getXaPool().isPadXid();
        }
        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
        TxConnectionManager cm = cmf.createTransactional(tsl, pool, allocationRetry, allocationRetryWaitMillis, this.getTransactionManager(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
        cm.setJndiName(jndiName);
        String poolName = null;
        if (ds.getPoolName() != null) {
            poolName = ds.getPoolName();
        }
        if (poolName == null) {
            poolName = jndiName;
        }
        pool.setName(poolName);
        return mcf.createConnectionFactory((ConnectionManager)cm);
    }

    private PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    protected abstract ClassLoader getDeploymentClassLoader(String var1);

    protected abstract String[] bindConnectionFactory(String var1, String var2, Object var3) throws Throwable;

    protected abstract Object initAndInject(String var1, List<? extends ConfigProperty> var2, ClassLoader var3) throws DeployException;
}

