/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers.common;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.TransactionManager;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.FlushStrategy;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.TransactionSupportEnum;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra10.ResourceAdapter10;
import org.jboss.jca.common.api.metadata.ra.ra16.ConfigProperty16;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.metadata.ra.common.ConfigPropertyImpl;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.connectionmanager.pool.PoolConfiguration;
import org.jboss.jca.core.api.management.ConfigProperty;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.connectionmanager.ConnectionManagerFactory;
import org.jboss.jca.core.connectionmanager.NoTxConnectionManager;
import org.jboss.jca.core.connectionmanager.pool.api.Pool;
import org.jboss.jca.core.connectionmanager.pool.api.PoolFactory;
import org.jboss.jca.core.connectionmanager.pool.api.PoolStrategy;
import org.jboss.jca.core.connectionmanager.pool.api.PrefillPool;
import org.jboss.jca.core.recovery.DefaultRecoveryPlugin;
import org.jboss.jca.core.spi.mdr.AlreadyExistsException;
import org.jboss.jca.core.spi.recovery.RecoveryPlugin;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.jca.core.spi.transaction.recovery.XAResourceRecovery;
import org.jboss.jca.deployers.common.BeanValidation;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateClass;
import org.jboss.jca.validator.ValidateObject;
import org.jboss.jca.validator.Validator;
import org.jboss.jca.validator.ValidatorException;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SubjectFactory;

public abstract class AbstractResourceAdapterDeployer {
    protected final Logger log;
    protected final boolean trace;
    protected final boolean validateClasses;
    private Configuration configuration = null;

    public AbstractResourceAdapterDeployer(boolean validateClasses, Logger log) {
        this.log = log;
        this.trace = log.isTraceEnabled();
        this.validateClasses = validateClasses;
    }

    public void setConfiguration(Configuration value) {
        this.configuration = value;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public Set<Failure> validateArchive(URL url, List<Validate> archiveValidation, Set<Failure> failures) {
        if (!this.getConfiguration().getArchiveValidation()) {
            return null;
        }
        for (Validate validate : archiveValidation) {
            if (validate instanceof ValidateObject || this.validateClasses) continue;
            return null;
        }
        Validator validator = new Validator();
        List partialFailures = validator.validate(archiveValidation);
        if (partialFailures != null) {
            if (failures == null) {
                failures = new HashSet<Failure>();
            }
            failures.addAll(partialFailures);
        }
        return failures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printFailuresLog(String urlFileName, Validator validator, Collection<Failure> failures, File reportDirectory, FailureHelper ... fhInput) {
        String errorText = "";
        FailureHelper fh = null;
        fh = fhInput.length == 0 ? new FailureHelper(failures) : fhInput[0];
        if (failures != null && failures.size() > 0) {
            if (reportDirectory == null) {
                reportDirectory = this.getReportDirectory();
            }
            if (reportDirectory != null && reportDirectory.exists()) {
                int lastSepaIndex;
                int lastIndex;
                int lastSlashIndex = urlFileName.lastIndexOf("/");
                int n = lastIndex = lastSlashIndex > (lastSepaIndex = urlFileName.lastIndexOf(File.separator)) ? lastSlashIndex : lastSepaIndex;
                if (lastIndex != -1) {
                    urlFileName = urlFileName.substring(lastIndex + 1);
                }
                urlFileName = urlFileName + ".log";
                File report = new File(reportDirectory, urlFileName);
                FileWriter fw = null;
                BufferedWriter bw = null;
                try {
                    fw = new FileWriter(report);
                    bw = new BufferedWriter(fw, 8192);
                    bw.write(fh.asText(validator.getResourceBundle()));
                    bw.flush();
                    errorText = "Validation failures - see: " + report.getAbsolutePath();
                }
                catch (IOException ioe) {
                    this.log.warn((Object)ioe.getMessage(), (Throwable)ioe);
                }
                finally {
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (IOException ignore) {}
                    }
                    if (fw != null) {
                        try {
                            fw.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            } else {
                errorText = fh.asText(validator.getResourceBundle());
            }
        }
        return errorText;
    }

    protected boolean hasFailuresLevel(Collection<Failure> failures, int severity) {
        if (failures != null) {
            for (Failure failure : failures) {
                if (failure.getSeverity() != severity) continue;
                return true;
            }
        }
        return false;
    }

    protected void startContext(javax.resource.spi.ResourceAdapter resourceAdapter, String bootstrapIdentifier) throws DeployException {
        try {
            CloneableBootstrapContext bc;
            Class<?> clz = resourceAdapter.getClass();
            Method start = clz.getMethod("start", BootstrapContext.class);
            CloneableBootstrapContext cbc = null;
            if (bootstrapIdentifier != null && this.getConfiguration().getBootstrapContexts() != null && (bc = this.getConfiguration().getBootstrapContexts().get(bootstrapIdentifier)) != null) {
                cbc = bc.clone();
            }
            if (cbc == null) {
                cbc = this.getConfiguration().getDefaultBootstrapContext().clone();
            }
            start.invoke((Object)resourceAdapter, cbc);
        }
        catch (InvocationTargetException ite) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), ite.getTargetException());
        }
        catch (Throwable t) {
            throw new DeployException("Unable to start " + resourceAdapter.getClass().getName(), t);
        }
    }

    protected void associateResourceAdapter(javax.resource.spi.ResourceAdapter resourceAdapter, Object object) throws DeployException {
        if (resourceAdapter != null && object != null && object instanceof ResourceAdapterAssociation) {
            try {
                Class<?> clz = object.getClass();
                Method setResourceAdapter = clz.getMethod("setResourceAdapter", javax.resource.spi.ResourceAdapter.class);
                setResourceAdapter.invoke(object, resourceAdapter);
            }
            catch (Throwable t) {
                throw new DeployException("Unable to associate " + object.getClass().getName(), t);
            }
        }
    }

    protected CommonConnDef findConnectionDefinition(String clz, List<CommonConnDef> defs) {
        if (defs != null) {
            if (defs.size() == 1) {
                CommonConnDef cd = defs.get(0);
                if (cd.getClassName() != null && !clz.equals(cd.getClassName())) {
                    this.log.warn((Object)("Only one connection definition found with a mismatch in class-name: " + cd));
                    return null;
                }
                return cd;
            }
            if (clz == null) {
                throw new IllegalArgumentException("ManagedConnectionFactory must be defined in class-name");
            }
            for (CommonConnDef cd : defs) {
                if (!clz.equals(cd.getClassName())) continue;
                return cd;
            }
        }
        return null;
    }

    protected CommonAdminObject findAdminObject(String clz, List<CommonAdminObject> defs) {
        if (defs != null) {
            if (defs.size() == 1) {
                CommonAdminObject cao = defs.get(0);
                if (cao.getClassName() != null && !clz.equals(cao.getClassName())) {
                    this.log.warn((Object)("Only one admin object found with a mismatch in class-name: " + cao));
                    return null;
                }
                return cao;
            }
            if (clz == null) {
                throw new IllegalArgumentException("AdminObject must be defined in class-name");
            }
            for (CommonAdminObject cao : defs) {
                if (!clz.equals(cao.getClassName())) continue;
                return cao;
            }
        }
        return null;
    }

    protected PoolConfiguration createPoolConfiguration(CommonPool pp, CommonTimeOut tp, CommonValidation vp) {
        PoolConfiguration pc = new PoolConfiguration();
        if (pp != null) {
            if (pp.getMinPoolSize() != null) {
                pc.setMinSize(pp.getMinPoolSize().intValue());
            }
            if (pp.getMaxPoolSize() != null) {
                pc.setMaxSize(pp.getMaxPoolSize().intValue());
            }
            if (pp.isPrefill() != null) {
                pc.setPrefill(pp.isPrefill().booleanValue());
            }
            if (pp.isUseStrictMin() != null) {
                pc.setStrictMin(pp.isUseStrictMin().booleanValue());
            }
        }
        if (tp != null) {
            if (tp.getBlockingTimeoutMillis() != null) {
                pc.setBlockingTimeout(tp.getBlockingTimeoutMillis().longValue());
            }
            if (tp.getIdleTimeoutMinutes() != null) {
                pc.setIdleTimeout(tp.getIdleTimeoutMinutes().longValue());
            }
        }
        if (vp != null) {
            if (vp.isBackgroundValidation() != null) {
                pc.setBackgroundValidation(vp.isBackgroundValidation().booleanValue());
            }
            if (vp.getBackgroundValidationMinutes() != null) {
                pc.setBackgroundValidationMinutes(vp.getBackgroundValidationMinutes().intValue());
            }
            if (vp.isUseFastFail() != null) {
                pc.setUseFastFail(vp.isUseFastFail().booleanValue());
            }
        }
        return pc;
    }

    public void start() {
        if (!this.checkConfigurationIsValid()) {
            throw new IllegalStateException("Configuration not valid or not defined");
        }
    }

    protected Set<Failure> initActivationSpec(ClassLoader cl, Connector cmd, javax.resource.spi.ResourceAdapter resourceAdapter, List<Validate> archiveValidationObjects, List<Object> beanValidationObjects, Set<Failure> failures, URL url, boolean activateDeployment) throws DeployException {
        List mlMetas;
        ResourceAdapter1516 ra1516;
        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getInboundResourceadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter() != null && ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && (mlMetas = ra1516.getInboundResourceadapter().getMessageadapter().getMessagelisteners()).size() > 0) {
            for (MessageListener mlMD : mlMetas) {
                if (mlMD.getActivationspec() == null || mlMD.getActivationspec().getActivationspecClass().getValue() == null) continue;
                failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ACTIVATION_SPEC, mlMD.getActivationspec().getActivationspecClass().getValue(), cl, mlMD.getActivationspec().getConfigProperties())), failures);
                if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                List cpm = mlMD.getActivationspec().getConfigProperties();
                Object o = this.initAndInject(mlMD.getActivationspec().getActivationspecClass().getValue(), cpm, cl);
                if (this.trace) {
                    this.log.trace((Object)("ActivationSpec: " + o.getClass().getName()));
                    this.log.trace((Object)("ActivationSpec defined in classloader: " + o.getClass().getClassLoader()));
                }
                archiveValidationObjects.add((Validate)new ValidateObject(Key.ACTIVATION_SPEC, o, cpm));
                beanValidationObjects.add(o);
                this.associateResourceAdapter(resourceAdapter, o);
            }
        }
        return failures;
    }

    protected Set<Failure> initAdminObject(Connector cmd, ClassLoader cl, List<Validate> archiveValidationObjects, List<Object> beanValidationObjects, Set<Failure> failures, URL url, String deploymentName, boolean activateDeployment, List<CommonAdminObject> aosRaXml, List<CommonAdminObject> aosIronJacamar, Object[] aos, String[] aoJndiNames, org.jboss.jca.core.api.management.Connector mgtConnector) throws DeployException {
        List aoMetas;
        ResourceAdapter1516 ra1516;
        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getAdminObjects() != null && (aoMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getAdminObjects()).size() > 0) {
            aos = new Object[aoMetas.size()];
            aoJndiNames = new String[aoMetas.size()];
            for (int i = 0; i < aoMetas.size(); ++i) {
                AdminObject aoMeta = (AdminObject)aoMetas.get(i);
                if (aoMeta.getAdminobjectClass() == null || aoMeta.getAdminobjectClass().getValue() == null) continue;
                CommonAdminObject aoRaXml = this.findAdminObject(aoMeta.getAdminobjectClass().getValue(), aosRaXml);
                CommonAdminObject ijAO = this.findAdminObject(aoMeta.getAdminobjectClass().getValue(), aosIronJacamar);
                failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.ADMIN_OBJECT, aoMeta.getAdminobjectClass().getValue(), cl, aoMeta.getConfigProperties())), failures);
                if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                Object ao = this.initAndInject(aoMeta.getAdminobjectClass().getValue(), aoMeta.getConfigProperties(), cl);
                if (this.trace) {
                    this.log.trace((Object)("AdminObject: " + ao.getClass().getName()));
                    this.log.trace((Object)("AdminObject defined in classloader: " + ao.getClass().getClassLoader()));
                }
                archiveValidationObjects.add((Validate)new ValidateObject(Key.ADMIN_OBJECT, ao, aoMeta.getConfigProperties()));
                beanValidationObjects.add(ao);
                if (ao == null || !(ao instanceof Serializable) || !(ao instanceof Referenceable)) continue;
                try {
                    String jndiName = null;
                    if (aoRaXml != null || ijAO != null) {
                        jndiName = aoRaXml != null ? this.buildJndiName(aoRaXml.getJndiName(), aoRaXml.isUseJavaContext()) : this.buildJndiName(ijAO.getJndiName(), ijAO.isUseJavaContext());
                        this.bindAdminObject(url, deploymentName, ao, jndiName);
                    } else {
                        String[] names = this.bindAdminObject(url, deploymentName, ao);
                        jndiName = names[0];
                    }
                    aos[i] = ao;
                    aoJndiNames[i] = jndiName;
                    org.jboss.jca.core.api.management.AdminObject mgtAo = new org.jboss.jca.core.api.management.AdminObject(ao);
                    mgtAo.getConfigProperties().addAll(this.createManagementView(aoMeta.getConfigProperties()));
                    mgtAo.setJndiName(jndiName);
                    mgtConnector.getAdminObjects().add(mgtAo);
                    continue;
                }
                catch (Throwable t) {
                    throw new DeployException("Failed to bind admin object", t);
                }
            }
        }
        return failures;
    }

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, IronJacamar ijmd) throws DeployException, ResourceException, ValidatorException, AlreadyExistsException, ClassNotFoundException, Throwable {
        return this.createObjectsAndInjectValue(url, deploymentName, root, cl, cmd, ijmd, null);
    }

    protected CommonDeployment createObjectsAndInjectValue(URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, IronJacamar ijmd, ResourceAdapter raxml) throws DeployException, ResourceException, ValidatorException, AlreadyExistsException, ClassNotFoundException, Throwable {
        Set<Failure> failures = null;
        try {
            boolean activateDeployment;
            ArrayList<XAResourceRecovery> recoveryModules;
            String[] aoJndiNames;
            Object[] aos;
            String[] cfJndiNames;
            Object[] cfs;
            ArrayList<Object> beanValidationObjects;
            ArrayList<Validate> archiveValidationObjects;
            String resourceAdapterKey;
            javax.resource.spi.ResourceAdapter resourceAdapter;
            org.jboss.jca.core.api.management.Connector mgtConnector;
            block152: {
                block154: {
                    List cdMetas;
                    block153: {
                        String poolName;
                        String jndiName;
                        CommonXaPool ijXaPool;
                        ResourceAdapter1516 ra1516;
                        String mgtUniqueId;
                        if (cmd != null && cmd.getLicense() != null && cmd.getLicense().isLicenseRequired()) {
                            this.log.info((Object)("Required license terms for " + url.toExternalForm()));
                        }
                        if ((mgtUniqueId = url.getFile()).indexOf("/") != -1) {
                            mgtUniqueId = mgtUniqueId.substring(mgtUniqueId.lastIndexOf("/") + 1);
                        }
                        mgtConnector = new org.jboss.jca.core.api.management.Connector(mgtUniqueId);
                        resourceAdapter = null;
                        resourceAdapterKey = null;
                        archiveValidationObjects = new ArrayList<Validate>();
                        beanValidationObjects = new ArrayList<Object>();
                        cfs = null;
                        cfJndiNames = null;
                        aos = null;
                        aoJndiNames = null;
                        recoveryModules = new ArrayList<XAResourceRecovery>(1);
                        activateDeployment = this.checkActivation(cmd, ijmd);
                        if (cmd == null) break block152;
                        if (cmd.getVersion() != Connector.Version.V_10 && (ra1516 = (ResourceAdapter1516)cmd.getResourceadapter()) != null && ra1516.getResourceadapterClass() != null) {
                            failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.RESOURCE_ADAPTER, ra1516.getResourceadapterClass(), cl, cmd.getResourceadapter().getConfigProperties())), failures);
                            if (!(this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment)) {
                                resourceAdapter = (javax.resource.spi.ResourceAdapter)this.initAndInject(ra1516.getResourceadapterClass(), ra1516.getConfigProperties(), cl);
                                if (this.trace) {
                                    this.log.trace((Object)("ResourceAdapter: " + resourceAdapter.getClass().getName()));
                                    this.log.trace((Object)("ResourceAdapter defined in classloader: " + resourceAdapter.getClass().getClassLoader()));
                                }
                                archiveValidationObjects.add((Validate)new ValidateObject(Key.RESOURCE_ADAPTER, (Object)resourceAdapter, ra1516.getConfigProperties()));
                                beanValidationObjects.add(resourceAdapter);
                                if (activateDeployment) {
                                    org.jboss.jca.core.api.management.ResourceAdapter mgtRa = new org.jboss.jca.core.api.management.ResourceAdapter(resourceAdapter);
                                    mgtRa.getConfigProperties().addAll(this.createManagementView(ra1516.getConfigProperties()));
                                    mgtConnector.setResourceAdapter(mgtRa);
                                }
                            }
                        }
                        if (cmd.getVersion() != Connector.Version.V_10) break block153;
                        ResourceAdapter10 ra10 = (ResourceAdapter10)cmd.getResourceadapter();
                        if (!activateDeployment) break block154;
                        CommonConnDef ijCD = null;
                        CommonConnDef cdRaXml = null;
                        if (raxml != null) {
                            cdRaXml = this.findConnectionDefinition(ra10.getManagedConnectionFactoryClass().getValue(), raxml.getConnectionDefinitions());
                        }
                        if (ijmd != null) {
                            ijCD = this.findConnectionDefinition(ra10.getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions());
                        }
                        if (ijCD != null && !ijCD.isEnabled().booleanValue() && (cdRaXml == null || !cdRaXml.isEnabled().booleanValue())) break block154;
                        ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)this.initAndInject(ra10.getManagedConnectionFactoryClass().getValue(), ra10.getConfigProperties(), cl);
                        if (this.trace) {
                            this.log.trace((Object)("ManagedConnectionFactory: " + managedConnectionFactory.getClass().getName()));
                            this.log.trace((Object)("ManagedConnectionFactory is defined in classloader: " + managedConnectionFactory.getClass().getClassLoader()));
                        }
                        managedConnectionFactory.setLogWriter(this.getLogPrintWriter());
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)managedConnectionFactory, ra10.getConfigProperties()));
                        beanValidationObjects.add(managedConnectionFactory);
                        this.associateResourceAdapter(resourceAdapter, managedConnectionFactory);
                        PoolConfiguration pc = null;
                        FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
                        if (cdRaXml != null) {
                            pc = this.createPoolConfiguration(cdRaXml.getPool(), cdRaXml.getTimeOut(), cdRaXml.getValidation());
                            if (cdRaXml.getPool() != null) {
                                flushStrategy = cdRaXml.getPool().getFlushStrategy();
                            }
                        } else if (ijCD != null) {
                            pc = this.createPoolConfiguration(ijCD.getPool(), ijCD.getTimeOut(), ijCD.getValidation());
                            if (ijCD.getPool() != null) {
                                flushStrategy = ijCD.getPool().getFlushStrategy();
                            }
                        } else {
                            pc = this.createPoolConfiguration(null, null, null);
                        }
                        PoolFactory pf = new PoolFactory();
                        Boolean noTxSeparatePool = Boolean.FALSE;
                        if (cdRaXml != null && cdRaXml.getPool() != null && cdRaXml.isXa().booleanValue()) {
                            ijXaPool = (CommonXaPool)cdRaXml.getPool();
                            if (ijXaPool != null) {
                                noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                            }
                        } else if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                            noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                        }
                        PoolStrategy strategy = PoolStrategy.ONE_POOL;
                        String securityDomain = null;
                        CommonSecurity security = null;
                        if (cdRaXml != null && cdRaXml.getSecurity() != null) {
                            security = cdRaXml.getSecurity();
                        } else if (ijCD != null && ijCD.getSecurity() != null) {
                            security = ijCD.getSecurity();
                        }
                        if (security != null) {
                            if (security.isApplication()) {
                                strategy = PoolStrategy.POOL_BY_CRI;
                            } else if (security.getSecurityDomain() != null && security.getSecurityDomain().trim().length() != 0) {
                                strategy = PoolStrategy.POOL_BY_SUBJECT;
                                securityDomain = security.getSecurityDomain();
                            } else if (security.getSecurityDomainAndApplication() != null && security.getSecurityDomainAndApplication().trim().length() != 0) {
                                strategy = PoolStrategy.POOL_BY_SUBJECT_AND_CRI;
                                securityDomain = security.getSecurityDomainAndApplication();
                            }
                        }
                        if (ra10 != null && ra10.getReauthenticationSupport() != null && ra10.getReauthenticationSupport().booleanValue()) {
                            strategy = PoolStrategy.REAUTH;
                        }
                        Pool pool = pf.create(strategy, managedConnectionFactory, pc, noTxSeparatePool.booleanValue());
                        ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                        NoTxConnectionManager cm = null;
                        TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                        tsmd = raxml != null && raxml.getTransactionSupport() != null ? raxml.getTransactionSupport() : (ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ((ResourceAdapter10)cmd.getResourceadapter()).getTransactionSupport());
                        TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        if (tsmd == TransactionSupportEnum.NoTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                        } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                        } else if (tsmd == TransactionSupportEnum.XATransaction) {
                            tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                        }
                        if (managedConnectionFactory instanceof TransactionSupport) {
                            tsl = ((TransactionSupport)managedConnectionFactory).getTransactionSupport();
                        }
                        Integer allocationRetry = null;
                        Long allocationRetryWaitMillis = null;
                        if (cdRaXml != null && cdRaXml.getTimeOut() != null) {
                            allocationRetry = cdRaXml.getTimeOut().getAllocationRetry();
                            allocationRetryWaitMillis = cdRaXml.getTimeOut().getAllocationRetryWaitMillis();
                        }
                        if (ijCD != null && ijCD.getTimeOut() != null) {
                            if (allocationRetry == null) {
                                allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                            }
                            if (allocationRetryWaitMillis == null) {
                                allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                            }
                        }
                        Boolean useCCM = Boolean.TRUE;
                        if (ijCD != null) {
                            useCCM = ijCD.isUseCcm();
                        }
                        if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                            cm = cmf.createNonTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, useCCM.booleanValue(), this.getCachedConnectionManager(), flushStrategy, allocationRetry, allocationRetryWaitMillis);
                        } else {
                            CommonXaPool ijXaPool2;
                            Boolean interleaving = null;
                            Integer xaResourceTimeout = null;
                            Boolean isSameRMOverride = null;
                            Boolean wrapXAResource = null;
                            Boolean padXid = null;
                            if (cdRaXml != null && cdRaXml.isXa().booleanValue()) {
                                CommonXaPool ijXaPool22 = (CommonXaPool)cdRaXml.getPool();
                                interleaving = ijXaPool22.isInterleaving();
                                isSameRMOverride = ijXaPool22.isSameRmOverride();
                                wrapXAResource = ijXaPool22.isWrapXaDataSource();
                                padXid = ijXaPool22.isPadXid();
                            }
                            if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool2 = (CommonXaPool)ijCD.getPool()) != null) {
                                if (interleaving == null) {
                                    interleaving = ijXaPool2.isInterleaving();
                                }
                                if (isSameRMOverride == null) {
                                    isSameRMOverride = ijXaPool2.isSameRmOverride();
                                }
                                if (wrapXAResource == null) {
                                    wrapXAResource = ijXaPool2.isWrapXaDataSource();
                                }
                                if (padXid == null) {
                                    padXid = ijXaPool2.isPadXid();
                                }
                            }
                            cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, useCCM.booleanValue(), this.getCachedConnectionManager(), flushStrategy, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                        }
                        Object cf = managedConnectionFactory.createConnectionFactory((ConnectionManager)cm);
                        if (cf == null) {
                            this.log.error((Object)"ConnectionFactory is null");
                        } else if (this.trace) {
                            this.log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                            this.log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                        }
                        archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                        if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) break block154;
                        if (cdRaXml != null || ijCD != null) {
                            jndiName = cdRaXml != null ? this.buildJndiName(cdRaXml.getJndiName(), cdRaXml.isUseJavaContext()) : this.buildJndiName(ijCD.getJndiName(), ijCD.isUseJavaContext());
                            this.bindConnectionFactory(url, deploymentName, cf, jndiName);
                            cfs = new Object[]{cf};
                            cfJndiNames = new String[]{jndiName};
                            cm.setJndiName(jndiName);
                            poolName = null;
                            if (cdRaXml != null) {
                                poolName = cdRaXml.getPoolName();
                            } else if (ijCD != null) {
                                poolName = ijCD.getPoolName();
                            }
                            if (poolName == null) {
                                poolName = jndiName;
                            }
                            pool.setName(poolName);
                        } else {
                            cfJndiNames = this.bindConnectionFactory(url, deploymentName, cf);
                            cfs = new Object[]{cf};
                            cm.setJndiName(cfJndiNames[0]);
                            poolName = null;
                            if (cdRaXml != null) {
                                poolName = cdRaXml.getPoolName();
                            } else if (ijCD != null) {
                                poolName = ijCD.getPoolName();
                            }
                            if (poolName == null) {
                                poolName = cfJndiNames[0];
                            }
                            jndiName = poolName;
                            pool.setName(poolName);
                        }
                        if (!activateDeployment) break block154;
                        ConnectionFactory mgtCf = new ConnectionFactory(cf, managedConnectionFactory);
                        mgtCf.setPoolConfiguration(pc);
                        mgtCf.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
                        mgtCf.setJndiName(jndiName);
                        mgtCf.getManagedConnectionFactory().getConfigProperties().addAll(this.createManagementView(ra10.getConfigProperties()));
                        mgtConnector.getConnectionFactories().add(mgtCf);
                        if (!(pool instanceof PrefillPool)) break block154;
                        PrefillPool pp = (PrefillPool)pool;
                        SubjectFactory subjectFactory = this.getSubjectFactory(securityDomain);
                        Subject subject = null;
                        if (subjectFactory != null) {
                            subject = this.createSubject(subjectFactory, securityDomain, managedConnectionFactory);
                        }
                        pp.prefill(subject, null, noTxSeparatePool.booleanValue());
                        break block154;
                    }
                    ResourceAdapter1516 ra = (ResourceAdapter1516)cmd.getResourceadapter();
                    if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                        cfs = new Object[cdMetas.size()];
                        cfJndiNames = new String[cdMetas.size()];
                        for (int cdIndex = 0; cdIndex < cdMetas.size(); ++cdIndex) {
                            String poolName;
                            String jndiName;
                            CommonXaPool ijXaPool;
                            ConnectionDefinition connectionDefinition = (ConnectionDefinition)cdMetas.get(cdIndex);
                            failures = this.validateArchive(url, Arrays.asList(new ValidateClass(Key.MANAGED_CONNECTION_FACTORY, connectionDefinition.getManagedConnectionFactoryClass().getValue(), cl, connectionDefinition.getConfigProperties())), failures);
                            if (this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1) || !activateDeployment) continue;
                            CommonConnDef ijCD = null;
                            CommonConnDef cdRaXml = null;
                            if (raxml != null) {
                                cdRaXml = this.findConnectionDefinition(connectionDefinition.getManagedConnectionFactoryClass().getValue(), raxml.getConnectionDefinitions());
                            }
                            if (ijmd != null) {
                                ijCD = this.findConnectionDefinition(connectionDefinition.getManagedConnectionFactoryClass().getValue(), ijmd.getConnectionDefinitions());
                            }
                            if (ijCD != null && !ijCD.isEnabled().booleanValue() && (cdRaXml == null || !cdRaXml.isEnabled().booleanValue())) continue;
                            ManagedConnectionFactory mcf = (ManagedConnectionFactory)this.initAndInject(connectionDefinition.getManagedConnectionFactoryClass().getValue(), connectionDefinition.getConfigProperties(), cl);
                            if (this.trace) {
                                this.log.trace((Object)("ManagedConnectionFactory: " + mcf.getClass().getName()));
                                this.log.trace((Object)("ManagedConnectionFactory defined in classloader: " + mcf.getClass().getClassLoader()));
                            }
                            mcf.setLogWriter(this.getLogPrintWriter());
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.MANAGED_CONNECTION_FACTORY, (Object)mcf, connectionDefinition.getConfigProperties()));
                            beanValidationObjects.add(mcf);
                            this.associateResourceAdapter(resourceAdapter, mcf);
                            PoolConfiguration pc = null;
                            FlushStrategy flushStrategy = FlushStrategy.FAILING_CONNECTION_ONLY;
                            if (cdRaXml != null) {
                                pc = this.createPoolConfiguration(cdRaXml.getPool(), cdRaXml.getTimeOut(), cdRaXml.getValidation());
                                if (cdRaXml.getPool() != null) {
                                    flushStrategy = cdRaXml.getPool().getFlushStrategy();
                                }
                            } else if (ijCD != null) {
                                pc = this.createPoolConfiguration(ijCD.getPool(), ijCD.getTimeOut(), ijCD.getValidation());
                                if (ijCD.getPool() != null) {
                                    flushStrategy = ijCD.getPool().getFlushStrategy();
                                }
                            } else {
                                pc = this.createPoolConfiguration(null, null, null);
                            }
                            PoolFactory pf = new PoolFactory();
                            Boolean noTxSeparatePool = Boolean.FALSE;
                            if (cdRaXml != null && cdRaXml.getPool() != null && cdRaXml.isXa().booleanValue()) {
                                ijXaPool = (CommonXaPool)cdRaXml.getPool();
                                if (ijXaPool != null) {
                                    noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                                }
                            } else if (ijCD != null && ijCD.getPool() != null && ijCD.isXa().booleanValue() && (ijXaPool = (CommonXaPool)ijCD.getPool()) != null) {
                                noTxSeparatePool = ijXaPool.isNoTxSeparatePool();
                            }
                            CommonSecurity security = null;
                            if (cdRaXml != null && cdRaXml.getSecurity() != null) {
                                security = cdRaXml.getSecurity();
                            } else if (ijCD != null && ijCD.getSecurity() != null) {
                                security = ijCD.getSecurity();
                            }
                            PoolStrategy strategy = PoolStrategy.ONE_POOL;
                            String securityDomain = null;
                            if (security != null) {
                                if (security.isApplication()) {
                                    strategy = PoolStrategy.POOL_BY_CRI;
                                } else if (security.getSecurityDomain() != null && security.getSecurityDomain().trim().length() != 0) {
                                    strategy = PoolStrategy.POOL_BY_SUBJECT;
                                    securityDomain = security.getSecurityDomain();
                                } else if (security.getSecurityDomainAndApplication() != null && security.getSecurityDomainAndApplication().trim().length() != 0) {
                                    strategy = PoolStrategy.POOL_BY_SUBJECT_AND_CRI;
                                    securityDomain = security.getSecurityDomainAndApplication();
                                }
                            }
                            if (ra.getOutboundResourceadapter().getReauthenticationSupport()) {
                                strategy = PoolStrategy.REAUTH;
                            }
                            Pool pool = pf.create(strategy, mcf, pc, noTxSeparatePool.booleanValue());
                            ConnectionManagerFactory cmf = new ConnectionManagerFactory();
                            NoTxConnectionManager cm = null;
                            TransactionSupport.TransactionSupportLevel tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            TransactionSupportEnum tsmd = TransactionSupportEnum.NoTransaction;
                            tsmd = raxml != null && raxml.getTransactionSupport() != null ? raxml.getTransactionSupport() : (ijmd != null && ijmd.getTransactionSupport() != null ? ijmd.getTransactionSupport() : ra.getOutboundResourceadapter().getTransactionSupport());
                            if (tsmd == TransactionSupportEnum.NoTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.NoTransaction;
                            } else if (tsmd == TransactionSupportEnum.LocalTransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.LocalTransaction;
                            } else if (tsmd == TransactionSupportEnum.XATransaction) {
                                tsl = TransactionSupport.TransactionSupportLevel.XATransaction;
                            }
                            if (mcf instanceof TransactionSupport) {
                                tsl = ((TransactionSupport)mcf).getTransactionSupport();
                            }
                            XAResourceRecovery recoveryImpl = null;
                            Integer allocationRetry = null;
                            Long allocationRetryWaitMillis = null;
                            if (cdRaXml != null && cdRaXml.getTimeOut() != null) {
                                allocationRetry = cdRaXml.getTimeOut().getAllocationRetry();
                                allocationRetryWaitMillis = cdRaXml.getTimeOut().getAllocationRetryWaitMillis();
                            }
                            if (ijCD != null && ijCD.getTimeOut() != null) {
                                if (allocationRetry == null) {
                                    allocationRetry = ijCD.getTimeOut().getAllocationRetry();
                                }
                                if (allocationRetryWaitMillis == null) {
                                    allocationRetryWaitMillis = ijCD.getTimeOut().getAllocationRetryWaitMillis();
                                }
                            }
                            Boolean useCCM = Boolean.TRUE;
                            if (ijCD != null) {
                                useCCM = ijCD.isUseCcm();
                            }
                            if (tsl == TransactionSupport.TransactionSupportLevel.NoTransaction) {
                                cm = cmf.createNonTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, useCCM.booleanValue(), this.getCachedConnectionManager(), flushStrategy, allocationRetry, allocationRetryWaitMillis);
                            } else {
                                Boolean interleaving = null;
                                Integer xaResourceTimeout = null;
                                Boolean isSameRMOverride = null;
                                Boolean wrapXAResource = null;
                                Boolean padXid = null;
                                Recovery recoveryMD = null;
                                if (cdRaXml != null && cdRaXml.isXa().booleanValue()) {
                                    CommonXaPool cdRaXmlXaPool = (CommonXaPool)cdRaXml.getPool();
                                    interleaving = cdRaXmlXaPool.isInterleaving();
                                    isSameRMOverride = cdRaXmlXaPool.isSameRmOverride();
                                    wrapXAResource = cdRaXmlXaPool.isWrapXaDataSource();
                                    padXid = cdRaXmlXaPool.isPadXid();
                                    recoveryMD = cdRaXml.getRecovery();
                                }
                                if (ijCD != null && ijCD.isXa().booleanValue()) {
                                    CommonXaPool ijXaPool3 = (CommonXaPool)ijCD.getPool();
                                    if (interleaving == null) {
                                        interleaving = ijXaPool3.isInterleaving();
                                    }
                                    if (isSameRMOverride == null) {
                                        isSameRMOverride = ijXaPool3.isSameRmOverride();
                                    }
                                    if (wrapXAResource == null) {
                                        wrapXAResource = ijXaPool3.isWrapXaDataSource();
                                    }
                                    if (padXid == null) {
                                        padXid = ijXaPool3.isPadXid();
                                    }
                                    if (recoveryMD == null) {
                                        recoveryMD = ijCD.getRecovery();
                                    }
                                }
                                cm = cmf.createTransactional(tsl, pool, this.getSubjectFactory(securityDomain), securityDomain, useCCM.booleanValue(), this.getCachedConnectionManager(), flushStrategy, allocationRetry, allocationRetryWaitMillis, this.getTransactionIntegration(), interleaving, xaResourceTimeout, isSameRMOverride, wrapXAResource, padXid);
                                if (tsl == TransactionSupport.TransactionSupportLevel.XATransaction) {
                                    String recoverSecurityDomain = securityDomain;
                                    String recoverUser = null;
                                    String recoverPassword = null;
                                    if (recoveryMD == null || !recoveryMD.getNoRecovery().booleanValue()) {
                                        Credential credential;
                                        Credential credential2 = credential = recoveryMD != null ? recoveryMD.getCredential() : null;
                                        if (credential != null) {
                                            recoverSecurityDomain = credential.getSecurityDomain();
                                            recoverUser = credential.getUserName();
                                            recoverPassword = credential.getPassword();
                                        }
                                        if (this.log.isDebugEnabled()) {
                                            if (recoverUser != null) {
                                                this.log.debug((Object)("RecoverUser=" + recoverUser));
                                            } else if (recoverSecurityDomain != null) {
                                                this.log.debug((Object)("RecoverSecurityDomain=" + recoverSecurityDomain));
                                            }
                                        }
                                        DefaultRecoveryPlugin plugin = null;
                                        if (recoveryMD != null && recoveryMD.getRecoverPlugin() != null) {
                                            ArrayList<ConfigPropertyImpl> configProperties = null;
                                            if (recoveryMD.getRecoverPlugin().getConfigPropertiesMap() != null) {
                                                configProperties = new ArrayList<ConfigPropertyImpl>(recoveryMD.getRecoverPlugin().getConfigPropertiesMap().size());
                                                for (Map.Entry property : recoveryMD.getRecoverPlugin().getConfigPropertiesMap().entrySet()) {
                                                    ConfigPropertyImpl c = new ConfigPropertyImpl(null, new XsdString((String)property.getKey(), null), new XsdString("String", null), new XsdString((String)property.getValue(), null), null);
                                                    configProperties.add(c);
                                                }
                                                plugin = (RecoveryPlugin)this.initAndInject(recoveryMD.getRecoverPlugin().getClassName(), configProperties, cl);
                                            }
                                        } else {
                                            plugin = new DefaultRecoveryPlugin();
                                        }
                                        recoveryImpl = this.getTransactionIntegration().createXAResourceRecovery(mcf, padXid, isSameRMOverride, wrapXAResource, recoverUser, recoverPassword, recoverSecurityDomain, this.getSubjectFactory(recoverSecurityDomain), (RecoveryPlugin)plugin);
                                    }
                                }
                            }
                            Object cf = mcf.createConnectionFactory((ConnectionManager)cm);
                            if (cf == null) {
                                this.log.error((Object)"ConnectionFactory is null");
                            } else if (this.trace) {
                                this.log.trace((Object)("ConnectionFactory: " + cf.getClass().getName()));
                                this.log.trace((Object)("ConnectionFactory defined in classloader: " + cf.getClass().getClassLoader()));
                            }
                            archiveValidationObjects.add((Validate)new ValidateObject(Key.CONNECTION_FACTORY, cf));
                            if (cf == null || !(cf instanceof Serializable) || !(cf instanceof Referenceable)) continue;
                            if (cdRaXml != null || ijCD != null) {
                                jndiName = cdRaXml != null ? this.buildJndiName(cdRaXml.getJndiName(), cdRaXml.isUseJavaContext()) : this.buildJndiName(ijCD.getJndiName(), ijCD.isUseJavaContext());
                                this.bindConnectionFactory(url, deploymentName, cf, jndiName);
                                cfs[cdIndex] = cf;
                                cfJndiNames[cdIndex] = jndiName;
                                cm.setJndiName(jndiName);
                                poolName = null;
                                if (cdRaXml != null) {
                                    poolName = cdRaXml.getPoolName();
                                } else if (ijCD != null) {
                                    poolName = ijCD.getPoolName();
                                }
                                if (poolName == null) {
                                    poolName = jndiName;
                                }
                                pool.setName(poolName);
                            } else {
                                cfJndiNames = this.bindConnectionFactory(url, deploymentName, cf);
                                cfs = new Object[]{cf};
                                cm.setJndiName(cfJndiNames[0]);
                                poolName = null;
                                if (cdRaXml != null) {
                                    poolName = cdRaXml.getPoolName();
                                } else if (ijCD != null) {
                                    poolName = ijCD.getPoolName();
                                }
                                if (poolName == null) {
                                    poolName = cfJndiNames[0];
                                }
                                jndiName = poolName;
                                pool.setName(poolName);
                            }
                            if (this.getTransactionIntegration().getRecoveryRegistry() != null && recoveryImpl != null) {
                                recoveryImpl.setJndiName(cm.getJndiName());
                                this.getTransactionIntegration().getRecoveryRegistry().addXAResourceRecovery(recoveryImpl);
                                recoveryModules.add(recoveryImpl);
                            }
                            if (!activateDeployment) continue;
                            ConnectionFactory mgtCf = new ConnectionFactory(cf, mcf);
                            mgtCf.setPoolConfiguration(pc);
                            mgtCf.setPool((org.jboss.jca.core.api.connectionmanager.pool.Pool)pool);
                            mgtCf.setJndiName(jndiName);
                            mgtCf.getManagedConnectionFactory().getConfigProperties().addAll(this.createManagementView(connectionDefinition.getConfigProperties()));
                            mgtConnector.getConnectionFactories().add(mgtCf);
                            if (!(pool instanceof PrefillPool)) continue;
                            PrefillPool pp = (PrefillPool)pool;
                            SubjectFactory subjectFactory = this.getSubjectFactory(securityDomain);
                            Subject subject = null;
                            if (subjectFactory != null) {
                                subject = this.createSubject(subjectFactory, securityDomain, mcf);
                            }
                            pp.prefill(subject, null, noTxSeparatePool.booleanValue());
                        }
                    }
                }
                failures = this.initActivationSpec(cl, cmd, resourceAdapter, archiveValidationObjects, beanValidationObjects, failures, url, activateDeployment);
                failures = this.initAdminObject(cmd, cl, archiveValidationObjects, beanValidationObjects, failures, url, deploymentName, activateDeployment, raxml != null ? raxml.getAdminObjects() : null, ijmd != null ? ijmd.getAdminObjects() : null, aos, aoJndiNames, (org.jboss.jca.core.api.management.Connector)(activateDeployment ? mgtConnector : null));
            }
            failures = this.validateArchive(url, archiveValidationObjects, failures);
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures);
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            if (cmd != null) {
                try {
                    this.registerResourceAdapterToMDR(url, root, cmd, ijmd);
                }
                catch (AlreadyExistsException e) {
                    // empty catch block
                }
            }
            if (activateDeployment) {
                if (this.getConfiguration().getBeanValidation()) {
                    ArrayList<Class> groupsClasses = null;
                    if (ijmd != null && ijmd.getBeanValidationGroups() != null && ijmd.getBeanValidationGroups().size() > 0) {
                        groupsClasses = new ArrayList<Class>();
                        for (String group : ijmd.getBeanValidationGroups()) {
                            groupsClasses.add(Class.forName(group, true, cl));
                        }
                    }
                    if (beanValidationObjects.size() > 0) {
                        BeanValidation beanValidator = new BeanValidation();
                        for (Object e : beanValidationObjects) {
                            beanValidator.validate(e, groupsClasses);
                        }
                    }
                }
                if (resourceAdapter != null) {
                    String bootstrapIdentifier = null;
                    if (raxml != null && raxml.getBootstrapContext() != null && !raxml.getBootstrapContext().trim().equals("")) {
                        bootstrapIdentifier = raxml.getBootstrapContext();
                    }
                    if (bootstrapIdentifier == null && ijmd != null && ijmd.getBootstrapContext() != null && !ijmd.getBootstrapContext().trim().equals("")) {
                        bootstrapIdentifier = ijmd.getBootstrapContext();
                    }
                    this.startContext(resourceAdapter, bootstrapIdentifier);
                    resourceAdapterKey = this.registerResourceAdapterToResourceAdapterRepository(resourceAdapter);
                }
            }
            if (activateDeployment) {
                this.log.info((Object)("Deployed: " + url.toExternalForm()));
            } else {
                this.log.debug((Object)("Activated: " + url.toExternalForm()));
            }
            return new CommonDeployment(url, deploymentName, activateDeployment, resourceAdapter, resourceAdapterKey, cfs, cfJndiNames, aos, aoJndiNames, recoveryModules.toArray(new XAResourceRecovery[recoveryModules.size()]), mgtConnector, null, cl, this.log);
        }
        catch (DeployException de) {
            throw de;
        }
        catch (Throwable t) {
            if (this.getConfiguration().getArchiveValidationFailOnWarn() && this.hasFailuresLevel(failures, 0) || this.getConfiguration().getArchiveValidationFailOnError() && this.hasFailuresLevel(failures, 1)) {
                throw new DeployException("Deployment " + url.toExternalForm() + " failed", (Throwable)new ValidatorException(this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]), failures));
            }
            this.printFailuresLog(url.getPath(), new Validator(), failures, null, new FailureHelper[0]);
            throw new DeployException("Deployment " + url.toExternalForm() + " failed", t);
        }
    }

    protected String buildJndiName(String jndiName, Boolean javaContext) {
        if (javaContext != null) {
            if (javaContext.booleanValue() && !jndiName.startsWith("java:/")) {
                jndiName = "java:/" + jndiName;
            } else if (!javaContext.booleanValue() && jndiName.startsWith("java:/")) {
                jndiName = jndiName.substring(7);
            }
        }
        return jndiName;
    }

    protected abstract SubjectFactory getSubjectFactory(String var1) throws DeployException;

    protected Subject createSubject(final SubjectFactory subjectFactory, final String securityDomain, final ManagedConnectionFactory mcf) {
        if (subjectFactory == null) {
            throw new IllegalArgumentException("SubjectFactory is null");
        }
        if (securityDomain == null) {
            throw new IllegalArgumentException("SecurityDomain is null");
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                try {
                    SecurityContext securityContext = SecurityContextFactory.createSecurityContext((String)securityDomain);
                    SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                    Subject unauthenticated = new Subject();
                    securityContext.getSubjectInfo().setAuthenticatedSubject(unauthenticated);
                    Subject subject = subjectFactory.createSubject(securityDomain);
                    Set<PasswordCredential> pcs = subject.getPrivateCredentials(PasswordCredential.class);
                    if (pcs != null && pcs.size() > 0) {
                        for (PasswordCredential pc : pcs) {
                            pc.setManagedConnectionFactory(mcf);
                        }
                    }
                    if (AbstractResourceAdapterDeployer.this.log.isDebugEnabled()) {
                        AbstractResourceAdapterDeployer.this.log.debug((Object)("Subject=" + subject));
                    }
                    return subject;
                }
                catch (Throwable t) {
                    AbstractResourceAdapterDeployer.this.log.error((Object)("Exception during createSubject()" + t.getMessage()), t);
                    return null;
                }
            }
        });
    }

    protected abstract CachedConnectionManager getCachedConnectionManager();

    private List<ConfigProperty> createManagementView(List<? extends org.jboss.jca.common.api.metadata.ra.ConfigProperty> cps) {
        ArrayList<ConfigProperty> result = new ArrayList<ConfigProperty>();
        if (cps != null) {
            for (org.jboss.jca.common.api.metadata.ra.ConfigProperty configProperty : cps) {
                ConfigProperty mgtCp = null;
                if (configProperty instanceof ConfigProperty16) {
                    Boolean confidential;
                    ConfigProperty16 cp16 = (ConfigProperty16)configProperty;
                    Boolean dynamic = cp16.getConfigPropertySupportsDynamicUpdates();
                    if (dynamic == null) {
                        dynamic = Boolean.FALSE;
                    }
                    if ((confidential = cp16.getConfigPropertyConfidential()) == null) {
                        confidential = Boolean.FALSE;
                    }
                    mgtCp = new ConfigProperty(configProperty.getConfigPropertyName().getValue(), dynamic.booleanValue(), confidential.booleanValue());
                } else {
                    mgtCp = new ConfigProperty(configProperty.getConfigPropertyName().getValue());
                }
                result.add(mgtCp);
            }
        }
        return result;
    }

    protected abstract File getReportDirectory();

    protected abstract void registerResourceAdapterToMDR(URL var1, File var2, Connector var3, IronJacamar var4) throws AlreadyExistsException;

    protected abstract String registerResourceAdapterToResourceAdapterRepository(javax.resource.spi.ResourceAdapter var1);

    protected abstract TransactionManager getTransactionManager();

    protected abstract TransactionIntegration getTransactionIntegration();

    protected abstract PrintWriter getLogPrintWriter();

    protected abstract String[] bindConnectionFactory(URL var1, String var2, Object var3) throws Throwable;

    protected abstract String[] bindConnectionFactory(URL var1, String var2, Object var3, String var4) throws Throwable;

    protected abstract String[] bindAdminObject(URL var1, String var2, Object var3) throws Throwable;

    protected abstract String[] bindAdminObject(URL var1, String var2, Object var3, String var4) throws Throwable;

    protected abstract boolean checkConfigurationIsValid();

    protected abstract boolean checkActivation(Connector var1, IronJacamar var2);

    protected abstract Object initAndInject(String var1, List<? extends org.jboss.jca.common.api.metadata.ra.ConfigProperty> var2, ClassLoader var3) throws DeployException;
}

