/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.embedded.arquillian;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.arquillian.protocol.local.LocalMethodExecutor;
import org.jboss.arquillian.spi.Configuration;
import org.jboss.arquillian.spi.ContainerMethodExecutor;
import org.jboss.arquillian.spi.Context;
import org.jboss.arquillian.spi.DeployableContainer;
import org.jboss.arquillian.spi.DeploymentException;
import org.jboss.arquillian.spi.LifecycleException;
import org.jboss.jca.embedded.Embedded;
import org.jboss.jca.embedded.EmbeddedFactory;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.ResourceAdapterArchive;

public class EmbeddedJCAContainer
implements DeployableContainer {
    private Embedded embedded = null;

    public ContainerMethodExecutor deploy(Context context, Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new DeploymentException("Could not deploy a null application");
        }
        if (!ResourceAdapterArchive.class.isInstance(archive)) {
            throw new DeploymentException("Could not deploy a non resource adapter application");
        }
        try {
            ResourceAdapterArchive raa = (ResourceAdapterArchive)ResourceAdapterArchive.class.cast(archive);
            if (raa.getName() != null && raa.getName().startsWith("complex_")) {
                String name;
                Asset asset;
                if (raa.get(raa.getName().substring(8)) != null) {
                    asset = raa.get(raa.getName().substring(8)).getAsset();
                    name = raa.getName().substring(raa.getName().indexOf("complex_"));
                    this.deployinternalAsset(asset, name);
                }
                if (raa.get("resource-adapters-ra.xml") != null) {
                    asset = raa.get("resource-adapters-ra.xml").getAsset();
                    name = "resource-adapters-ra.xml";
                    this.deployinternalAsset(asset, name);
                }
                if (raa.get("datasources-ds.xml") != null) {
                    asset = raa.get("datasources-ds.xml").getAsset();
                    name = "datasources-ds.xml";
                    this.deployinternalAsset(asset, name);
                }
                if (raa.get("datasources-xa-ds.xml") != null) {
                    asset = raa.get("datasources-xa-ds.xml").getAsset();
                    name = "datasources-xa-ds.xml";
                    this.deployinternalAsset(asset, name);
                }
            } else {
                this.embedded.deploy((ResourceAdapterArchive)ResourceAdapterArchive.class.cast(archive));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DeploymentException("Could not deploy the application: " + t.getMessage());
        }
        return new LocalMethodExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployinternalAsset(Asset asset, String name) throws IOException, FileNotFoundException, Throwable, MalformedURLException {
        File parentDirectory = new File(SecurityActions.getSystemProperty("java.io.tmpdir"));
        File raaFile = new File(parentDirectory, name);
        if (raaFile.exists()) {
            this.recursiveDelete(raaFile);
        }
        InputStream is = null;
        FileOutputStream os = null;
        byte[] buffer = new byte[4096];
        int read = 0;
        try {
            is = asset.openStream();
            os = new FileOutputStream(raaFile);
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
            os.flush();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException ignore) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        this.embedded.deploy(raaFile.toURI().toURL());
    }

    public void undeploy(Context context, Archive<?> archive) throws DeploymentException {
        if (archive == null) {
            throw new DeploymentException("Could not undeploy a null application");
        }
        if (!ResourceAdapterArchive.class.isInstance(archive)) {
            throw new DeploymentException("Could not undeploy a non resource adapter application");
        }
        try {
            this.embedded.undeploy((ResourceAdapterArchive)ResourceAdapterArchive.class.cast(archive));
        }
        catch (Exception e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setup(Context context, Configuration configuration) {
    }

    public void start(Context context) throws LifecycleException {
        this.embedded = EmbeddedFactory.create();
        try {
            this.embedded.startup();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start the EmbeddedJCA container", (Throwable)e);
        }
        catch (Throwable t) {
            throw new LifecycleException("Could not start the EmbeddedJCA container: " + t.getMessage());
        }
    }

    public void stop(Context context) throws LifecycleException {
        try {
            this.embedded.shutdown();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop the EmbeddedJCA container", (Throwable)e);
        }
        catch (Throwable t) {
            throw new LifecycleException("Could not stop the EmbeddedJCA container: " + t.getMessage());
        }
        this.embedded = null;
    }

    private void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        this.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    public static class SecurityActions {
        private SecurityActions() {
        }

        static String getSystemProperty(final String name) {
            return (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(name);
                }
            });
        }

        static void setSystemProperty(final String name, final String value) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.setProperty(name, value);
                    return null;
                }
            });
        }
    }
}

