package org.jboss.jca.embedded.dsl.datasources10.api; 

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
/**
 * This interface defines the contract for the <code> connection-propertyType </code> xsd type 
 * @author <a href="mailto:ralf.battenfeld@bluewin.ch">Ralf Battenfeld</a>
 * @author <a href="mailto:alr@jboss.org">Andrew Lee Rubinger</a>
 * @since Generation date :2013-02-28T09:43:14.113-05:00
 */
public interface ConnectionPropertyType<T> extends Child<T>
{
 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionPropertyType ElementName: text ElementType : connection-propertyType
   // MaxOccurs: -  isGeneric: true   isAttribute: false isEnum: false isDataType: false
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the body text for the element <code>connection-propertyType</code> 
    * @param connectionPropertyType the value for the body text <code>connection-propertyType</code> 
    * @return the current instance of <code>ConnectionPropertyType<T></code> 
    */
   public ConnectionPropertyType<T> text(String value);

   /**
    * Returns the body text of the element <code>connection-propertyType</code> 
    * @return the value defined for the text <code>connection-propertyType</code> 
    */
   public String getText();

 
   // --------------------------------------------------------------------------------------------------------||
   // ClassName: ConnectionPropertyType ElementName: xsd:token ElementType : name
   // MaxOccurs: -  isGeneric: true   isAttribute: true isEnum: false isDataType: true
   // --------------------------------------------------------------------------------------------------------||

   /**
    * Sets the <code>name</code> attribute
    * @param name the value for the attribute <code>name</code> 
    * @return the current instance of <code>ConnectionPropertyType<T></code> 
    */
   public ConnectionPropertyType<T> name(String name);

   /**
    * Returns the <code>name</code> attribute
    * @return the value defined for the attribute <code>name</code> 
    */
   public String getName();

   /**
    * Removes the <code>name</code> attribute 
    * @return the current instance of <code>ConnectionPropertyType<T></code> 
    */
   public ConnectionPropertyType<T> removeName();
}
