package org.jboss.shrinkwrap.descriptor.api.javaee6; 

/**
 * This class implements the <code> generic-booleanType </code> xsd type 
 */
public enum GenericBooleanType
{
   _TRUE("true"),
   _FALSE("false"),
   _YES("yes"),
   _NO("no");

   private String value;

   GenericBooleanType (String value) { this.value = value; }

   public String toString() {return value;}

   public static GenericBooleanType getFromStringValue(String value)
   {
      for(GenericBooleanType type: GenericBooleanType.values())
      {
         if(value != null && type.toString().equals(value))
        { return type;}
      }
      return null;
   }

}

