/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.transaction.xa.XAResource;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnection;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.WrappedCallableStatement;
import org.jboss.jca.adapters.jdbc.WrappedPreparedStatement;
import org.jboss.jca.adapters.jdbc.WrappedStatement;
import org.jboss.jca.adapters.jdbc.WrapperDataSource;
import org.jboss.logging.Logger;

public abstract class WrappedConnection
extends JBossWrapper
implements Connection {
    private static Logger log = Logger.getLogger(WrappedConnection.class);
    protected static Logger spyLogger = Logger.getLogger((String)"jboss.jdbc.spy");
    private volatile BaseWrapperManagedConnection mc;
    private BaseWrapperManagedConnection lockedMC;
    private int lockCount;
    private WrapperDataSource dataSource;
    private HashMap<WrappedStatement, Throwable> statements;
    private boolean closed = false;
    private int trackStatements;
    protected boolean spy = false;
    protected String jndiName = null;

    public WrappedConnection(BaseWrapperManagedConnection mc, boolean spy, String jndiName) {
        this.setManagedConnection(mc);
        this.setSpy(spy);
        this.setJndiName(jndiName);
    }

    void setManagedConnection(BaseWrapperManagedConnection mc) {
        this.mc = mc;
        this.lockCount = 0;
        if (mc != null) {
            this.trackStatements = mc.getTrackStatements();
        } else {
            this.lockedMC = null;
        }
    }

    void setSpy(boolean v) {
        this.spy = v;
    }

    void setJndiName(String v) {
        this.jndiName = v;
    }

    protected void lock() throws SQLException {
        BaseWrapperManagedConnection mc = this.mc;
        if (mc != null) {
            mc.tryLock();
            if (this.lockedMC == null) {
                this.lockedMC = mc;
            }
            ++this.lockCount;
        } else {
            throw new SQLException("Connection is not associated with a managed connection." + this);
        }
    }

    protected void unlock() {
        BaseWrapperManagedConnection mc = this.lockedMC;
        if (--this.lockCount == 0) {
            this.lockedMC = null;
        }
        if (mc != null) {
            mc.unlock();
        }
    }

    public WrapperDataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(WrapperDataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] setReadOnly(%s)", (Object)this.jndiName, (Object)"Connection", (Object)readOnly);
            }
            this.mc.setJdbcReadOnly(readOnly);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkStatus();
        if (this.spy) {
            spyLogger.debugf("%s [%s] isReadOnly()", (Object)this.jndiName, (Object)"Connection");
        }
        return this.mc.isJdbcReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        this.closed = true;
        if (this.spy) {
            spyLogger.debugf("%s [%s] close()", (Object)this.jndiName, (Object)"Connection");
        }
        if (this.mc != null) {
            if (this.trackStatements != 0) {
                WrappedConnection wrappedConnection = this;
                synchronized (wrappedConnection) {
                    if (this.statements != null && this.statements.size() > 0) {
                        for (Map.Entry<WrappedStatement, Throwable> entry : this.statements.entrySet()) {
                            WrappedStatement ws = entry.getKey();
                            if (this.trackStatements == 1) {
                                Throwable stackTrace = entry.getValue();
                                log.warn((Object)"Closing a statement you left open, please do your own housekeeping", stackTrace);
                            }
                            try {
                                ws.internalClose();
                            }
                            catch (Throwable t) {
                                log.warn((Object)"Exception trying to close statement:", t);
                            }
                        }
                    }
                }
            }
            this.mc.closeHandle(this);
        }
        this.mc = null;
        this.dataSource = null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.spy) {
            spyLogger.debugf("%s [%s] isClosed()", (Object)this.jndiName, (Object)"Connection");
        }
        return this.closed;
    }

    protected abstract WrappedStatement wrapStatement(Statement var1, boolean var2, String var3);

    @Override
    public Statement createStatement() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStatement()", (Object)this.jndiName, (Object)"Connection");
                }
                WrappedStatement wrappedStatement = this.wrapStatement(this.mc.getConnection().createStatement(), this.spy, this.jndiName);
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStatement(%s, %s)", new Object[]{this.jndiName, "Connection", resultSetType, resultSetConcurrency});
                }
                WrappedStatement wrappedStatement = this.wrapStatement(this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency), this.spy, this.jndiName);
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStatement(%s, %s, %s)", new Object[]{this.jndiName, "Connection", resultSetType, resultSetConcurrency, resultSetHoldability});
                }
                WrappedStatement wrappedStatement = this.wrapStatement(this.mc.getConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.spy, this.jndiName);
                return wrappedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected abstract WrappedPreparedStatement wrapPreparedStatement(PreparedStatement var1, boolean var2, String var3);

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s)", (Object)this.jndiName, (Object)"Connection", (Object)sql);
                }
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.prepareStatement(sql, 1003, 1007), this.spy, this.jndiName);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency});
                }
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.prepareStatement(sql, resultSetType, resultSetConcurrency), this.spy, this.jndiName);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency, resultSetHoldability});
                }
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.spy, this.jndiName);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s)", new Object[]{this.jndiName, "Connection", sql, autoGeneratedKeys});
                }
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, autoGeneratedKeys), this.spy, this.jndiName);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s)", new Object[]{this.jndiName, "Connection", sql, Arrays.toString(columnIndexes)});
                }
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, columnIndexes), this.spy, this.jndiName);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareStatement(%s, %s)", new Object[]{this.jndiName, "Connection", sql, Arrays.toString(columnNames)});
                }
                WrappedPreparedStatement wrappedPreparedStatement = this.wrapPreparedStatement(this.mc.getConnection().prepareStatement(sql, columnNames), this.spy, this.jndiName);
                return wrappedPreparedStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    protected abstract WrappedCallableStatement wrapCallableStatement(CallableStatement var1, boolean var2, String var3);

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareCall(%s)", (Object)this.jndiName, (Object)"Connection", (Object)sql);
                }
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(this.mc.prepareCall(sql, 1003, 1007), this.spy, this.jndiName);
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareCall(%s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency});
                }
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(this.mc.prepareCall(sql, resultSetType, resultSetConcurrency), this.spy, this.jndiName);
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] prepareCall(%s, %s, %s, %s)", new Object[]{this.jndiName, "Connection", sql, resultSetType, resultSetConcurrency, resultSetHoldability});
                }
                WrappedCallableStatement wrappedCallableStatement = this.wrapCallableStatement(this.mc.getConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability), this.spy, this.jndiName);
                return wrappedCallableStatement;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] nativeSQL(%s)", (Object)this.jndiName, (Object)"Connection", (Object)sql);
                }
                String string = this.mc.getConnection().nativeSQL(sql);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoCommit(boolean autocommit) throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] setAutoCommit(%s)", (Object)this.jndiName, (Object)"Connection", (Object)autocommit);
            }
            this.mc.setJdbcAutoCommit(autocommit);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] getAutoCommit()", (Object)this.jndiName, (Object)"Connection");
            }
            boolean bl = this.mc.isJdbcAutoCommit();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            if (this.spy) {
                spyLogger.debugf("%s [%s] commit()", (Object)this.jndiName, (Object)"Connection");
            }
            this.mc.jdbcCommit();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            if (this.spy) {
                spyLogger.debugf("%s [%s] rollback()", (Object)this.jndiName, (Object)"Connection");
            }
            this.mc.jdbcRollback();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            if (this.spy) {
                spyLogger.debugf("%s [%s] rollback(%s)", (Object)this.jndiName, (Object)"Connection", (Object)savepoint);
            }
            this.mc.jdbcRollback(savepoint);
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getMetaData()", (Object)this.jndiName, (Object)"Connection");
                }
                DatabaseMetaData databaseMetaData = this.mc.getConnection().getMetaData();
                return databaseMetaData;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setCatalog(%s)", (Object)this.jndiName, (Object)"Connection", (Object)catalog);
                }
                this.mc.getConnection().setCatalog(catalog);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getCatalog()", (Object)this.jndiName, (Object)"Connection");
                }
                String string = this.mc.getConnection().getCatalog();
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int isolationLevel) throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] setTransactionIsolation(%s)", (Object)this.jndiName, (Object)"Connection", (Object)isolationLevel);
            }
            this.mc.setJdbcTransactionIsolation(isolationLevel);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        this.lock();
        try {
            this.checkStatus();
            if (this.spy) {
                spyLogger.debugf("%s [%s] getTransactionIsolation()", (Object)this.jndiName, (Object)"Connection");
            }
            int n = this.mc.getJdbcTransactionIsolation();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getWarnings()", (Object)this.jndiName, (Object)"Connection");
                }
                SQLWarning sQLWarning = this.mc.getConnection().getWarnings();
                return sQLWarning;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] clearWarnings()", (Object)this.jndiName, (Object)"Connection");
                }
                this.mc.getConnection().clearWarnings();
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getTypeMap()", (Object)this.jndiName, (Object)"Connection");
                }
                Map<String, Class<?>> map = this.mc.getConnection().getTypeMap();
                return map;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTypeMap(Map<String, Class<?>> typeMap) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setTypeMap(%s)", (Object)this.jndiName, (Object)"Connection", typeMap);
                }
                this.mc.getConnection().setTypeMap(typeMap);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setHoldability(%s)", (Object)this.jndiName, (Object)"Connection", (Object)holdability);
                }
                this.mc.getConnection().setHoldability(holdability);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getHoldability()", (Object)this.jndiName, (Object)"Connection");
                }
                int n = this.mc.getConnection().getHoldability();
                return n;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setSavepoint()", (Object)this.jndiName, (Object)"Connection");
                }
                Savepoint savepoint = this.mc.getConnection().setSavepoint();
                return savepoint;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] setSavepoint(%s)", (Object)this.jndiName, (Object)"Connection", (Object)name);
                }
                Savepoint savepoint = this.mc.getConnection().setSavepoint(name);
                return savepoint;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] releaseSavepoint(%s)", (Object)this.jndiName, (Object)"Connection", (Object)savepoint);
                }
                this.mc.getConnection().releaseSavepoint(savepoint);
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createArrayOf(%s, %s)", new Object[]{this.jndiName, "Connection", typeName, Arrays.toString(elements)});
                }
                Array array = c.createArrayOf(typeName, elements);
                return array;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createBlob()", (Object)this.jndiName, (Object)"Connection");
                }
                Blob blob = c.createBlob();
                return blob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createClob()", (Object)this.jndiName, (Object)"Connection");
                }
                Clob clob = c.createClob();
                return clob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createNClob()", (Object)this.jndiName, (Object)"Connection");
                }
                NClob nClob = c.createNClob();
                return nClob;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createSQLXML()", (Object)this.jndiName, (Object)"Connection");
                }
                SQLXML sQLXML = c.createSQLXML();
                return sQLXML;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] createStruct(%s, %s)", new Object[]{this.jndiName, "Connection", typeName, Arrays.toString(attributes)});
                }
                Struct struct = c.createStruct(typeName, attributes);
                return struct;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClientInfo()", (Object)this.jndiName, (Object)"Connection");
                }
                Properties properties = c.getClientInfo();
                return properties;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] getClientInfo(%s)", (Object)this.jndiName, (Object)"Connection", (Object)name);
                }
                String string = c.getClientInfo(name);
                return string;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.lock();
        try {
            Connection c = this.getUnderlyingConnection();
            try {
                if (this.spy) {
                    spyLogger.debugf("%s [%s] isValid(%s)", (Object)this.jndiName, (Object)"Connection", (Object)timeout);
                }
                boolean bl = c.isValid(timeout);
                return bl;
            }
            catch (Throwable t) {
                throw this.checkException(t);
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.lock();
            try {
                Connection c = this.getUnderlyingConnection();
                try {
                    if (this.spy) {
                        spyLogger.debugf("%s [%s] setClientInfo(%s)", (Object)this.jndiName, (Object)"Connection", (Object)properties);
                    }
                    c.setClientInfo(properties);
                }
                catch (Throwable t) {
                    throw this.checkException(t);
                }
            }
            catch (SQLClientInfoException e) {
                throw e;
            }
            catch (SQLException e) {
                SQLClientInfoException t = new SQLClientInfoException();
                t.initCause(e);
                throw t;
            }
        }
        catch (SQLException e) {
            SQLClientInfoException t = new SQLClientInfoException();
            t.initCause(e);
            throw t;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.lock();
            try {
                Connection c = this.getUnderlyingConnection();
                try {
                    if (this.spy) {
                        spyLogger.debugf("%s [%s] setClientInfo(%s, %s)", new Object[]{this.jndiName, "Connection", name, value});
                    }
                    c.setClientInfo(name, value);
                }
                catch (Throwable t) {
                    throw this.checkException(t);
                }
            }
            catch (SQLClientInfoException e) {
                throw e;
            }
            catch (SQLException e) {
                SQLClientInfoException t = new SQLClientInfoException();
                t.initCause(e);
                throw t;
            }
        }
        catch (SQLException e) {
            SQLClientInfoException t = new SQLClientInfoException();
            t.initCause(e);
            throw t;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getUnderlyingConnection() throws SQLException {
        this.lock();
        try {
            this.checkTransaction();
            Connection connection = this.mc.getConnection();
            return connection;
        }
        finally {
            this.unlock();
        }
    }

    public boolean isXA() {
        return this.mc.isXA();
    }

    public XAResource getXAResource() throws ResourceException {
        return this.mc.getXAResource();
    }

    @Override
    protected Connection getWrappedObject() throws SQLException {
        return this.getUnderlyingConnection();
    }

    protected void checkTransaction() throws SQLException {
        this.checkStatus();
        this.mc.checkTransaction();
    }

    void checkTransactionActive() throws SQLException {
        if (this.dataSource == null) {
            return;
        }
        this.dataSource.checkTransactionActive();
    }

    protected void checkStatus() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection handle has been closed and is unusable");
        }
        if (this.mc == null) {
            throw new SQLException("Connection handle is not currently associated with a ManagedConnection");
        }
        this.checkTransactionActive();
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        Throwable result = null;
        if (t instanceof AbstractMethodError) {
            t = new SQLFeatureNotSupportedException("Method is not implemented by JDBC driver", t);
        }
        if (this.mc != null) {
            result = this.mc.connectionError(t);
        }
        if (result instanceof SQLException) {
            throw (SQLException)result;
        }
        throw new SQLException("Error", result);
    }

    int getTrackStatements() {
        return this.trackStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements == null) {
                this.statements = new HashMap(1);
            }
            if (this.trackStatements == 1) {
                this.statements.put(ws, new Throwable("STACKTRACE"));
            } else {
                this.statements.put(ws, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterStatement(WrappedStatement ws) {
        if (this.trackStatements == 0) {
            return;
        }
        WrappedConnection wrappedConnection = this;
        synchronized (wrappedConnection) {
            if (this.statements != null) {
                this.statements.remove(ws);
            }
        }
    }

    void checkConfiguredQueryTimeout(WrappedStatement ws) throws SQLException {
        if (this.mc == null || this.dataSource == null) {
            return;
        }
        int timeout = 0;
        if (this.mc.isTransactionQueryTimeout()) {
            timeout = this.dataSource.getTimeLeftBeforeTransactionTimeout();
        }
        if (timeout <= 0) {
            timeout = this.mc.getQueryTimeout();
        }
        if (timeout > 0) {
            ws.setQueryTimeout(timeout);
        }
    }

    Logger getLogger() {
        return log;
    }
}

