/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.CachedCallableStatement;
import org.jboss.jca.adapters.jdbc.CachedPreparedStatement;
import org.jboss.jca.adapters.jdbc.ManagedConnectionMetaDataImpl;
import org.jboss.jca.adapters.jdbc.PreparedStatementCache;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.StaleConnectionException;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedConnectionFactory;
import org.jboss.jca.adapters.jdbc.spi.reauth.ReauthPlugin;
import org.jboss.jca.adapters.jdbc.util.ReentrantLock;
import org.jboss.logging.Logger;

public abstract class BaseWrapperManagedConnection
implements ManagedConnection {
    private static final WrappedConnectionFactory WRAPPED_CONNECTION_FACTORY;
    private static final String JDBC41_FACTORY = "org.jboss.jca.adapters.jdbc.jdk7.WrappedConnectionFactoryJDK7";
    private boolean trace;
    protected final BaseWrapperManagedConnectionFactory mcf;
    protected final Connection con;
    protected Properties props;
    private final int transactionIsolation;
    private final boolean readOnly;
    private ReentrantLock lock = new ReentrantLock(true);
    private final Collection<ConnectionEventListener> cels = new ArrayList<ConnectionEventListener>();
    private final Set<WrappedConnection> handles = new HashSet<WrappedConnection>();
    private PreparedStatementCache psCache = null;
    protected final Object stateLock = new Object();
    protected boolean inManagedTransaction = false;
    protected AtomicBoolean inLocalTransaction = new AtomicBoolean(false);
    protected boolean jdbcAutoCommit = true;
    protected static boolean ignoreInManagedAutoCommitCalls;
    protected boolean underlyingAutoCommit = true;
    protected boolean jdbcReadOnly;
    protected boolean underlyingReadOnly;
    protected int jdbcTransactionIsolation;
    protected boolean destroyed = false;
    protected ManagedConnectionMetaData metadata;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseWrapperManagedConnection(BaseWrapperManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize) throws SQLException {
        this.mcf = mcf;
        this.con = con;
        this.props = props;
        this.trace = mcf.log.isTraceEnabled();
        if (psCacheSize > 0) {
            this.psCache = new PreparedStatementCache(psCacheSize, mcf.getStatistics());
            mcf.getStatistics().registerPreparedStatementCache(this.psCache);
        }
        if (transactionIsolation == -1) {
            this.transactionIsolation = con.getTransactionIsolation();
        } else {
            this.transactionIsolation = transactionIsolation;
            con.setTransactionIsolation(transactionIsolation);
        }
        this.readOnly = con.isReadOnly();
        if (mcf.getNewConnectionSQL() != null) {
            try (Statement s = con.createStatement();){
                s.execute(mcf.getNewConnectionSQL());
            }
        }
        this.underlyingReadOnly = this.readOnly;
        this.jdbcReadOnly = this.readOnly;
        this.jdbcTransactionIsolation = this.transactionIsolation;
        this.metadata = new ManagedConnectionMetaDataImpl(con, props.getProperty("user"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener cel) {
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            this.cels.add(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener cel) {
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            this.cels.remove(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object handle) throws ResourceException {
        if (!(handle instanceof WrappedConnection)) {
            throw new ResourceException("Wrong kind of connection handle to associate " + handle);
        }
        WrappedConnection wc = (WrappedConnection)handle;
        wc.setManagedConnection(this);
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add(wc);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.metadata;
    }

    public void setLogWriter(PrintWriter param1) throws ResourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        boolean isActive = false;
        if (this.lock.hasQueuedThreads()) {
            Collection<Thread> threads = this.lock.getQueuedThreads();
            for (Thread thread : threads) {
                Throwable t = new Throwable("Thread waiting for lock during cleanup");
                t.setStackTrace(thread.getStackTrace());
                this.mcf.log.warn((Object)t.getMessage(), t);
            }
            if (this.lock.hasQueuedThreads()) {
                isActive = true;
            }
        }
        if (this.lock.isLocked()) {
            Thread owner = this.lock.getOwner();
            if (owner != null) {
                Throwable t = new Throwable("Lock owned during cleanup");
                t.setStackTrace(owner.getStackTrace());
                this.mcf.log.warn((Object)t.getMessage(), t);
            } else {
                this.mcf.log.warn((Object)"Lock is locked during cleanup without an owner");
            }
            if (this.lock.isLocked()) {
                isActive = true;
            }
        }
        Object object = this.handles;
        synchronized (object) {
            for (WrappedConnection lc : this.handles) {
                lc.setManagedConnection(null);
            }
            this.handles.clear();
        }
        object = this.stateLock;
        synchronized (object) {
            this.jdbcAutoCommit = true;
            this.jdbcReadOnly = this.readOnly;
            if (this.jdbcTransactionIsolation != this.transactionIsolation) {
                try {
                    this.con.setTransactionIsolation(this.transactionIsolation);
                    this.jdbcTransactionIsolation = this.transactionIsolation;
                }
                catch (SQLException e) {
                    this.mcf.log.warn((Object)"Error resetting transaction isolation ", (Throwable)e);
                }
            }
        }
        if (isActive) {
            throw new ResourceException("Still active locks");
        }
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void tryLock() throws SQLException {
        int tryLock;
        if (this.trace) {
            this.dumpLockInformation(true);
        }
        if ((tryLock = this.mcf.getUseTryLock().intValue()) <= 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(tryLock, TimeUnit.SECONDS)) {
                throw new SQLException("Unable to obtain lock in " + tryLock + " seconds: " + this);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException("Interrupted attempting lock: " + this);
        }
    }

    protected void unlock() {
        if (this.trace) {
            this.dumpLockInformation(false);
        }
        if (this.lock.isHeldByCurrentThread()) {
            this.lock.unlock();
        }
    }

    private void dumpLockInformation(boolean l) {
        this.getLog().tracef("%s: HeldByCurrentThread: %s, Locked: %s, HoldCount: %d, QueueLength: %d", new Object[]{l ? "Lock" : "Unlock", this.lock.isHeldByCurrentThread() ? "Yes" : "No", this.lock.isLocked() ? "Yes" : "No", this.lock.getHoldCount(), this.lock.getQueueLength()});
        if (this.lock.isLocked()) {
            this.getLog().tracef("Owner: %s", (Object)this.lock.getOwner().toString());
        }
        if (this.lock.hasQueuedThreads()) {
            Collection<Thread> threads = this.lock.getQueuedThreads();
            for (Thread thread : threads) {
                this.getLog().tracef("Queued: %s", (Object)thread.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (Boolean.TRUE.equals(this.mcf.getReauthEnabled())) {
            this.mcf.loadReauthPlugin();
        }
        this.checkIdentity(subject, cri);
        WrappedConnection lc = WRAPPED_CONNECTION_FACTORY.createWrappedConnection(this, this.mcf.getSpy(), this.mcf.getJndiName());
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add(lc);
        }
        return lc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourceException {
        block10: {
            block9: {
                Object object = this.stateLock;
                synchronized (object) {
                    this.destroyed = true;
                }
                this.cleanup();
                try {
                    if (!this.underlyingAutoCommit) {
                        this.con.rollback();
                    }
                }
                catch (SQLException ignored) {
                    if (!this.trace) break block9;
                    this.getLog().trace((Object)"Ignored error during rollback: ", (Throwable)ignored);
                }
            }
            try {
                this.con.close();
            }
            catch (SQLException ignored) {
                if (!this.trace) break block10;
                this.getLog().trace((Object)"Ignored error during close: ", (Throwable)ignored);
            }
        }
        if (this.psCache != null) {
            this.mcf.getStatistics().deregisterPreparedStatementCache(this.psCache);
        }
    }

    public boolean checkValid() {
        SQLException e = this.mcf.isValidConnection(this.con);
        if (e == null) {
            return true;
        }
        this.getLog().warn((Object)("Destroying connection that is not valid, due to the following exception: " + this.con), (Throwable)e);
        this.broadcastConnectionError(e);
        return false;
    }

    public Properties getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeHandle(WrappedConnection handle) {
        Set<WrappedConnection> set = this.stateLock;
        synchronized (set) {
            if (this.destroyed) {
                return;
            }
        }
        set = this.handles;
        synchronized (set) {
            this.handles.remove(handle);
        }
        ArrayList<ConnectionEventListener> copy = null;
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            if (this.cels != null && this.cels.size() > 0) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
        }
        if (copy != null) {
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1);
            ce.setConnectionHandle((Object)handle);
            for (ConnectionEventListener cel : copy) {
                cel.connectionClosed(ce);
            }
        }
    }

    Throwable connectionError(Throwable t) {
        if (t instanceof SQLException) {
            if (this.mcf.isStaleConnection((SQLException)t)) {
                t = new StaleConnectionException((SQLException)t);
            } else if (this.mcf.isExceptionFatal((SQLException)t)) {
                this.broadcastConnectionError(t);
            }
        } else {
            this.broadcastConnectionError(t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastConnectionError(Throwable e) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.destroyed) {
                if (this.trace) {
                    this.getLog().trace((Object)("Not broadcasting error, already destroyed " + this), e);
                }
                return;
            }
        }
        Exception ex = null;
        ex = e instanceof Exception ? (Exception)e : new ResourceAdapterInternalException("Unexpected error", e);
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 5, ex);
        ArrayList<ConnectionEventListener> copy = null;
        Collection<ConnectionEventListener> collection = this.cels;
        synchronized (collection) {
            copy = new ArrayList<ConnectionEventListener>(this.cels);
        }
        for (ConnectionEventListener cel : copy) {
            try {
                cel.connectionErrorOccurred(ce);
            }
            catch (Throwable t) {
                this.getLog().warn((Object)("Error notifying of connection error for listener: " + cel), t);
            }
        }
    }

    Connection getConnection() throws SQLException {
        if (this.con == null) {
            throw new SQLException("Connection has been destroyed!!!");
        }
        return this.con;
    }

    /*
     * Enabled aggressive block sorting
     */
    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.psCache == null) return this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
        this.mcf.getStatistics().deltaPreparedStatementCacheAccessCount();
        PreparedStatementCache.Key key = new PreparedStatementCache.Key(sql, 1, resultSetType, resultSetConcurrency);
        CachedPreparedStatement cachedps = this.psCache.get(key);
        if (cachedps == null) {
            PreparedStatement ps = this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
            cachedps = WRAPPED_CONNECTION_FACTORY.createCachedPreparedStatement(ps);
            this.psCache.put(key, cachedps);
            this.mcf.getStatistics().deltaPreparedStatementCacheAddCount();
            return cachedps;
        }
        if (this.canUse(cachedps)) {
            this.mcf.getStatistics().deltaPreparedStatementCacheHitCount();
            cachedps.inUse();
            return cachedps;
        }
        this.mcf.getStatistics().deltaPreparedStatementCacheMissCount();
        return this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    PreparedStatement doPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    /*
     * Enabled aggressive block sorting
     */
    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.psCache == null) return this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
        this.mcf.getStatistics().deltaPreparedStatementCacheAccessCount();
        PreparedStatementCache.Key key = new PreparedStatementCache.Key(sql, 2, resultSetType, resultSetConcurrency);
        CachedCallableStatement cachedps = (CachedCallableStatement)this.psCache.get(key);
        if (cachedps == null) {
            CallableStatement cs = this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
            cachedps = WRAPPED_CONNECTION_FACTORY.createCachedCallableStatement(cs);
            this.psCache.put(key, cachedps);
            this.mcf.getStatistics().deltaPreparedStatementCacheAddCount();
            return cachedps;
        }
        if (this.canUse(cachedps)) {
            this.mcf.getStatistics().deltaPreparedStatementCacheHitCount();
            cachedps.inUse();
            return cachedps;
        }
        this.mcf.getStatistics().deltaPreparedStatementCacheMissCount();
        return this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
    }

    CallableStatement doPrepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    boolean canUse(CachedPreparedStatement cachedps) {
        if (!cachedps.isInUse()) {
            return true;
        }
        if (this.underlyingAutoCommit) {
            return false;
        }
        return this.mcf.sharePS;
    }

    protected Logger getLog() {
        return this.mcf.log;
    }

    private void checkIdentity(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.mcf.getConnectionProperties(subject, cri);
        if (Boolean.TRUE.equals(this.mcf.getReauthEnabled())) {
            if (this.props.equals(newProps)) {
                return;
            }
            if (!this.props.getProperty("user").equals(newProps.getProperty("user")) || !this.props.getProperty("password").equals(newProps.getProperty("password"))) {
                try {
                    ReauthPlugin plugin = this.mcf.getReauthPlugin();
                    plugin.reauthenticate(this.con, newProps.getProperty("user"), newProps.getProperty("password"));
                    this.props = newProps;
                }
                catch (SQLException se) {
                    throw new ResourceException("Error during reauthentication", (Throwable)se);
                }
            }
        } else if (!this.props.equals(newProps)) {
            throw new ResourceException("Wrong credentials passed to getConnection!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTransaction() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                return;
            }
            if (this.jdbcAutoCommit != this.underlyingAutoCommit) {
                this.con.setAutoCommit(this.jdbcAutoCommit);
                this.underlyingAutoCommit = this.jdbcAutoCommit;
            }
        }
        if (this.mcf.isJTA().booleanValue() && !this.jdbcAutoCommit && !this.inLocalTransaction.getAndSet(true)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 2);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionStarted(ce);
                }
                catch (Throwable t) {
                    if (!this.trace) continue;
                    this.getLog().trace((Object)("Error notifying of connection committed for listener: " + cel), t);
                }
            }
        }
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.jdbcReadOnly != this.underlyingReadOnly) {
                this.con.setReadOnly(this.jdbcReadOnly);
                this.underlyingReadOnly = this.jdbcReadOnly;
            }
        }
    }

    boolean isJdbcAutoCommit() {
        return this.inManagedTransaction ? false : this.jdbcAutoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcAutoCommit(boolean jdbcAutoCommit) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                if (!ignoreInManagedAutoCommitCalls) {
                    throw new SQLException("You cannot set autocommit during a managed transaction!");
                }
                return;
            }
            this.jdbcAutoCommit = jdbcAutoCommit;
        }
        if (this.mcf.isJTA().booleanValue() && jdbcAutoCommit && this.inLocalTransaction.getAndSet(false)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 3);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionCommitted(ce);
                }
                catch (Throwable t) {
                    if (!this.trace) continue;
                    this.getLog().trace((Object)("Error notifying of connection committed for listener: " + cel), t);
                }
            }
        }
    }

    boolean isJdbcReadOnly() {
        return this.jdbcReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcReadOnly(boolean readOnly) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot set read only during a managed transaction!");
            }
            this.jdbcReadOnly = readOnly;
        }
    }

    int getJdbcTransactionIsolation() {
        return this.jdbcTransactionIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcTransactionIsolation(int isolationLevel) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.jdbcTransactionIsolation = isolationLevel;
            this.con.setTransactionIsolation(this.jdbcTransactionIsolation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcCommit() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot commit during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot commit with autocommit set!");
            }
        }
        this.con.commit();
        if (this.mcf.isJTA().booleanValue() && this.inLocalTransaction.getAndSet(false)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 3);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionCommitted(ce);
                }
                catch (Throwable t) {
                    if (!this.trace) continue;
                    this.getLog().trace((Object)("Error notifying of connection committed for listener: " + cel), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot rollback during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot rollback with autocommit set!");
            }
        }
        this.con.rollback();
        if (this.mcf.isJTA().booleanValue() && this.inLocalTransaction.getAndSet(false)) {
            ArrayList<ConnectionEventListener> copy = null;
            Collection<ConnectionEventListener> collection = this.cels;
            synchronized (collection) {
                copy = new ArrayList<ConnectionEventListener>(this.cels);
            }
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 4);
            for (ConnectionEventListener cel : copy) {
                try {
                    cel.localTransactionRolledback(ce);
                }
                catch (Throwable t) {
                    if (!this.trace) continue;
                    this.getLog().trace((Object)("Error notifying of connection rollback for listener: " + cel), t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback(Savepoint savepoint) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException("You cannot rollback during a managed transaction!");
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException("You cannot rollback with autocommit set!");
            }
        }
        this.con.rollback(savepoint);
    }

    int getTrackStatements() {
        return this.mcf.trackStatements;
    }

    boolean isTransactionQueryTimeout() {
        return this.mcf.isTransactionQueryTimeout;
    }

    int getQueryTimeout() {
        return this.mcf.getQueryTimeout();
    }

    protected void checkException(SQLException e) throws ResourceException {
        this.connectionError(e);
        throw new ResourceException("SQLException", (Throwable)e);
    }

    public abstract boolean isXA();

    static {
        ignoreInManagedAutoCommitCalls = false;
        Class<?> connectionFactory = null;
        try {
            connectionFactory = Class.forName(JDBC41_FACTORY);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException("Unabled to load wrapped connection factory", cnfe);
        }
        try {
            WRAPPED_CONNECTION_FACTORY = (WrappedConnectionFactory)connectionFactory.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializign connection factory", e);
        }
        String ignAutoCommit = SecurityActions.getSystemProperty("ironjacamar.jdbc.ignoreautocommit");
        if (ignAutoCommit != null) {
            ignoreInManagedAutoCommitCalls = Boolean.valueOf(ignAutoCommit);
        }
    }
}

