/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.util;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jboss.jca.adapters.jdbc.util.SecurityActions;

public class Injection {
    public void inject(Object object, String propertyName, Object propertyValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.inject(object, propertyName, propertyValue, null, false);
    }

    public void inject(Object object, String propertyName, Object propertyValue, String propertyType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        this.inject(object, propertyName, propertyValue, propertyType, false);
    }

    public void inject(Object object, String propertyName, Object propertyValue, String propertyType, boolean includeFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method;
        if (object == null) {
            throw new IllegalArgumentException("Object is null");
        }
        if (propertyName == null || propertyName.trim().equals("")) {
            throw new IllegalArgumentException("PropertyName is undefined");
        }
        String methodName = "set" + propertyName.substring(0, 1).toUpperCase(Locale.US);
        if (propertyName.length() > 1) {
            methodName = methodName + propertyName.substring(1);
        }
        if ((method = this.findMethod(object.getClass(), methodName, propertyType)) != null) {
            Class<?> parameterClass = method.getParameterTypes()[0];
            Object parameterValue = null;
            try {
                parameterValue = this.getValue(propertyName, parameterClass, propertyValue, object.getClass().getClassLoader());
            }
            catch (Throwable t) {
                throw new InvocationTargetException(t, t.getMessage());
            }
            if (!parameterClass.isPrimitive() || parameterValue != null) {
                method.invoke(object, parameterValue);
            }
        } else {
            if (!includeFields) {
                throw new NoSuchMethodException("Method " + methodName + " not found");
            }
            Field field = this.findField(object.getClass(), propertyName, propertyType);
            if (field != null) {
                Class<?> fieldClass = field.getType();
                Object fieldValue = null;
                try {
                    fieldValue = this.getValue(propertyName, fieldClass, propertyValue, object.getClass().getClassLoader());
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t, t.getMessage());
                }
                field.set(object, fieldValue);
            } else {
                throw new NoSuchMethodException("Field " + propertyName + " not found");
            }
        }
    }

    protected Method findMethod(Class<?> clz, String methodName, String propertyType) {
        while (!clz.equals(Object.class)) {
            Method[] methods = clz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!methodName.equals(method.getName()) || method.getParameterTypes().length != 1 || propertyType != null && !propertyType.equals(method.getParameterTypes()[0].getName())) continue;
                return method;
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    protected Field findField(Class<?> clz, String fieldName, String fieldType) {
        while (!clz.equals(Object.class)) {
            Field[] fields = clz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!fieldName.equals(field.getName()) || fieldType != null && !fieldType.equals(field.getType().getName())) continue;
                return field;
            }
            clz = clz.getSuperclass();
        }
        return null;
    }

    protected Object getValue(String name, Class<?> clz, Object v, ClassLoader cl) throws Exception {
        if (v instanceof String) {
            String substituredValue = this.getSubstitutionValue((String)v);
            if (clz.equals(String.class)) {
                v = substituredValue;
            } else if (clz.equals(Byte.TYPE) || clz.equals(Byte.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Byte.valueOf(substituredValue);
                }
            } else if (clz.equals(Short.TYPE) || clz.equals(Short.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Short.valueOf(substituredValue);
                }
            } else if (clz.equals(Integer.TYPE) || clz.equals(Integer.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Integer.valueOf(substituredValue);
                }
            } else if (clz.equals(Long.TYPE) || clz.equals(Long.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Long.valueOf(substituredValue);
                }
            } else if (clz.equals(Float.TYPE) || clz.equals(Float.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Float.valueOf(substituredValue);
                }
            } else if (clz.equals(Double.TYPE) || clz.equals(Double.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Double.valueOf(substituredValue);
                }
            } else if (clz.equals(Boolean.TYPE) || clz.equals(Boolean.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Boolean.valueOf(substituredValue);
                }
            } else if (clz.equals(Character.TYPE) || clz.equals(Character.class)) {
                if (substituredValue != null && !substituredValue.trim().equals("")) {
                    v = Character.valueOf(substituredValue.charAt(0));
                }
            } else if (clz.equals(InetAddress.class)) {
                v = InetAddress.getByName(substituredValue);
            } else if (clz.equals(Class.class)) {
                v = Class.forName(substituredValue, true, cl);
            } else if (clz.equals(Properties.class)) {
                Properties prop = new Properties();
                StringTokenizer st = new StringTokenizer(substituredValue, " ,");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    String key = "";
                    String value = "";
                    int index = token.indexOf("=");
                    if (index != -1) {
                        key = token.substring(0, index);
                        if (token.length() > index + 1) {
                            value = token.substring(index + 1);
                        }
                    } else {
                        key = token;
                    }
                    if ("".equals(key)) continue;
                    prop.setProperty(key, value);
                }
                v = prop;
            } else {
                try {
                    Constructor<?> constructor = clz.getConstructor(String.class);
                    v = constructor.newInstance(substituredValue);
                }
                catch (Throwable t) {
                    try {
                        Method valueOf = clz.getMethod("valueOf", String.class);
                        v = valueOf.invoke((Object)null, substituredValue);
                    }
                    catch (Throwable inner) {
                        throw new IllegalArgumentException("Unknown property resolution for property " + name);
                    }
                }
            }
        }
        return v;
    }

    protected String getSubstitutionValue(String input) {
        if (input == null || input.trim().equals("")) {
            return input;
        }
        while (input.indexOf("${") != -1) {
            int from = input.indexOf("${");
            int to = input.indexOf("}");
            int dv = input.indexOf(":", from + 2);
            if (dv != -1 && dv > to) {
                dv = -1;
            }
            String systemProperty = "";
            String defaultValue = "";
            if (dv == -1) {
                String s = input.substring(from + 2, to);
                systemProperty = "/".equals(s) ? File.separator : (":".equals(s) ? File.pathSeparator : SecurityActions.getSystemProperty(s));
            } else {
                systemProperty = SecurityActions.getSystemProperty(input.substring(from + 2, dv));
                defaultValue = input.substring(dv + 1, to);
            }
            String prefix = "";
            String postfix = "";
            if (from != 0) {
                prefix = input.substring(0, from);
            }
            if (to + 1 < input.length() - 1) {
                postfix = input.substring(to + 1);
            }
            if (systemProperty != null && !systemProperty.trim().equals("")) {
                input = prefix + systemProperty + postfix;
                continue;
            }
            if (defaultValue != null && !defaultValue.trim().equals("")) {
                input = prefix + defaultValue + postfix;
                continue;
            }
            input = prefix + postfix;
        }
        return input;
    }
}

