/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;
import javax.transaction.RollbackException;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.DataSourceRepository;
import org.jboss.jca.adapters.jdbc.JBossWrapper;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedConnectionRequestInfo;
import org.jboss.jca.core.spi.transaction.TransactionTimeoutConfiguration;
import org.jboss.jca.core.spi.transaction.TxUtils;

public class WrapperDataSource
extends JBossWrapper
implements Referenceable,
DataSource,
Serializable {
    private static final long serialVersionUID = 1L;
    private static org.jboss.logging.Logger spyLogger = org.jboss.logging.Logger.getLogger((String)"jboss.jdbc.spy");
    private BaseWrapperManagedConnectionFactory mcf;
    private ConnectionManager cm;
    private PrintWriter logger;
    private Reference reference;
    private TransactionSynchronizationRegistry tsr;
    private UserTransaction userTransaction;
    private boolean initialized = false;
    private ConnectionRequestInfo defaultCRI;

    private WrapperDataSource() {
    }

    protected WrapperDataSource(BaseWrapperManagedConnectionFactory mcf, ConnectionManager cm) {
        this.mcf = mcf;
        this.cm = cm;
        this.tsr = null;
        this.userTransaction = null;
        this.defaultCRI = mcf.getUserName() != null ? new WrappedConnectionRequestInfo(mcf.getUserName(), mcf.getPassword()) : null;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.logger;
    }

    @Override
    public void setLogWriter(PrintWriter pw) throws SQLException {
        this.logger = pw;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    @Override
    public void setLoginTimeout(int param1) throws SQLException {
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, this.defaultCRI);
            wc.setDataSource(this);
            wc.setSpy(this.mcf.getSpy());
            wc.setJndiName(this.mcf.getJndiName());
            return wc;
        }
        catch (ResourceException re) {
            throw new SQLException(re);
        }
    }

    @Override
    public Connection getConnection(String user, String password) throws SQLException {
        WrappedConnectionRequestInfo cri = new WrappedConnectionRequestInfo(user, password);
        try {
            WrappedConnection wc = (WrappedConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, (ConnectionRequestInfo)cri);
            wc.setDataSource(this);
            wc.setSpy(this.mcf.getSpy());
            wc.setJndiName(this.mcf.getJndiName());
            return wc;
        }
        catch (ResourceException re) {
            throw new SQLException(re);
        }
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public Reference getReference() {
        return this.reference;
    }

    protected int getTimeLeftBeforeTransactionTimeout() throws SQLException {
        try {
            if (this.cm instanceof TransactionTimeoutConfiguration) {
                long timeout = ((TransactionTimeoutConfiguration)this.cm).getTimeLeftBeforeTransactionTimeout(true);
                if (timeout == -1L) {
                    return -1;
                }
                long result = timeout / 1000L;
                if (result % 1000L != 0L) {
                    ++result;
                }
                return (int)result;
            }
            return -1;
        }
        catch (RollbackException e) {
            throw new SQLException(e);
        }
    }

    protected void checkTransactionActive() throws SQLException {
        if (!this.mcf.isJTA().booleanValue()) {
            return;
        }
        if (this.initialized && this.userTransaction == null && this.tsr == null) {
            return;
        }
        if (!this.initialized) {
            try {
                this.initTransactionIntegration();
            }
            catch (SQLException e) {
                org.jboss.logging.Logger.getLogger(this.getClass()).debugf("UserTransaction not found", (Object)e);
                return;
            }
        }
        try {
            int status = 6;
            status = this.tsr != null ? this.tsr.getTransactionStatus() : this.userTransaction.getStatus();
            if (status == 6) {
                return;
            }
            if (status != 0 && status != 7 && status != 2 && status != 8) {
                throw new SQLException("Transaction cannot proceed " + TxUtils.getStatusAsString((int)status));
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage(), t);
        }
    }

    private void initTransactionIntegration() throws SQLException {
        if (this.mcf.getTransactionSynchronizationRegistry() != null) {
            this.tsr = this.mcf.getTransactionSynchronizationRegistry();
            this.initialized = true;
        }
        if (!this.initialized && this.mcf.getUserTransaction() != null) {
            this.userTransaction = this.mcf.getUserTransaction();
            this.initialized = true;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.initUserTransaction();
        }
    }

    private void initUserTransaction() throws SQLException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            this.userTransaction = (UserTransaction)context.lookup(this.mcf.getUserTransactionJndiName());
        }
        catch (Throwable t) {
            throw new SQLException(t.getMessage(), t);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private BaseWrapperManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    private ConnectionManager getConnectionManager() {
        return this.cm;
    }

    private PrintWriter getLogger() {
        return this.logger;
    }

    private TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.tsr;
    }

    private UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    private boolean isInitialized() {
        return this.initialized;
    }

    private ConnectionRequestInfo getDefaultCRI() {
        return this.defaultCRI;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeLong(DataSourceRepository.addDataSource(this));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        WrapperDataSource wd = DataSourceRepository.removeDataSource(in.readLong());
        if (wd == null) {
            throw new IOException("WrapperDataSource is null");
        }
        this.mcf = wd.getManagedConnectionFactory();
        this.cm = wd.getConnectionManager();
        this.logger = wd.getLogger();
        this.reference = wd.getReference();
        this.tsr = wd.getTransactionSynchronizationRegistry();
        this.userTransaction = wd.getUserTransaction();
        this.initialized = wd.isInitialized();
        this.defaultCRI = wd.getDefaultCRI();
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new StreamCorruptedException();
    }
}

