/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc;

import java.io.PrintWriter;
import java.lang.invoke.MethodHandle;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import org.jboss.jca.adapters.AdaptersBundle;
import org.jboss.jca.adapters.AdaptersLogger;
import org.jboss.jca.adapters.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.jca.adapters.jdbc.CachedCallableStatement;
import org.jboss.jca.adapters.jdbc.CachedPreparedStatement;
import org.jboss.jca.adapters.jdbc.ManagedConnectionMetaDataImpl;
import org.jboss.jca.adapters.jdbc.PreparedStatementCache;
import org.jboss.jca.adapters.jdbc.SecurityActions;
import org.jboss.jca.adapters.jdbc.StaleConnectionException;
import org.jboss.jca.adapters.jdbc.WrappedConnection;
import org.jboss.jca.adapters.jdbc.WrappedConnectionFactory;
import org.jboss.jca.adapters.jdbc.spi.reauth.ReauthPlugin;
import org.jboss.jca.adapters.jdbc.util.ReentrantLock;
import org.jboss.jca.core.spi.transaction.ConnectableResource;
import org.jboss.jca.core.spi.transaction.ConnectableResourceListener;
import org.jboss.logging.Messages;

public abstract class BaseWrapperManagedConnection
implements ManagedConnection,
ConnectableResource {
    private static final WrappedConnectionFactory WRAPPED_CONNECTION_FACTORY;
    private static final String JDBC42_FACTORY = "org.jboss.jca.adapters.jdbc.jdk8.WrappedConnectionFactoryJDK8";
    private static final String JDBC41_FACTORY = "org.jboss.jca.adapters.jdbc.jdk7.WrappedConnectionFactoryJDK7";
    protected static AdaptersBundle bundle;
    protected final BaseWrapperManagedConnectionFactory mcf;
    protected final Connection con;
    protected Properties props;
    private final int transactionIsolation;
    private final boolean readOnly;
    private ReentrantLock lock = new ReentrantLock(true);
    private int tryLock;
    private final Collection<ConnectionEventListener> cels = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final Set<WrappedConnection> handles = new HashSet<WrappedConnection>();
    private PreparedStatementCache psCache = null;
    protected final Object stateLock = new Object();
    protected boolean inManagedTransaction = false;
    protected AtomicBoolean inLocalTransaction = new AtomicBoolean(false);
    protected boolean jdbcAutoCommit = true;
    protected static boolean ignoreInManagedAutoCommitCalls;
    protected boolean underlyingAutoCommit = true;
    protected boolean jdbcReadOnly;
    protected boolean underlyingReadOnly;
    protected int jdbcTransactionIsolation;
    protected boolean destroyed = false;
    protected ManagedConnectionMetaData metadata;
    private Optional<MethodHandle> requestBegin;
    private Optional<MethodHandle> requestEnd;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseWrapperManagedConnection(BaseWrapperManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize) throws SQLException {
        this.mcf = mcf;
        this.con = con;
        this.props = props;
        this.tryLock = mcf.getUseTryLock();
        if (psCacheSize > 0) {
            this.psCache = new PreparedStatementCache(psCacheSize, mcf.getStatistics());
            mcf.getStatistics().registerPreparedStatementCache(this.psCache);
        }
        if (transactionIsolation == -1) {
            this.transactionIsolation = con.getTransactionIsolation();
        } else {
            this.transactionIsolation = transactionIsolation;
            con.setTransactionIsolation(transactionIsolation);
        }
        this.readOnly = con.isReadOnly();
        if (mcf.getNewConnectionSQL() != null) {
            try (Statement s = con.createStatement();){
                s.execute(mcf.getNewConnectionSQL());
            }
        }
        this.underlyingReadOnly = this.readOnly;
        this.jdbcReadOnly = this.readOnly;
        this.jdbcTransactionIsolation = this.transactionIsolation;
        this.metadata = new ManagedConnectionMetaDataImpl(con, props.getProperty("user"));
    }

    public void addConnectionEventListener(ConnectionEventListener cel) {
        this.cels.add(cel);
    }

    public void removeConnectionEventListener(ConnectionEventListener cel) {
        this.cels.remove(cel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object handle) throws ResourceException {
        if (!(handle instanceof WrappedConnection)) {
            throw new ResourceException(bundle.wrongConnectionHandle(handle.toString()));
        }
        WrappedConnection wc = (WrappedConnection)handle;
        wc.setManagedConnection(this);
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add(wc);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return this.metadata;
    }

    public void setLogWriter(PrintWriter param1) throws ResourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        boolean isActive = false;
        if (this.lock.hasQueuedThreads()) {
            Thread currentThread = Thread.currentThread();
            Throwable currentThrowable = new Throwable("Detected queued threads during cleanup from: " + currentThread.getName());
            currentThrowable.setStackTrace(SecurityActions.getStackTrace(currentThread));
            this.mcf.log.queuedThreadName(currentThread.getName(), currentThrowable);
            Collection<Thread> threads = this.lock.getQueuedThreads();
            for (Thread thread : threads) {
                Throwable t = new Throwable("Queued thread: " + thread.getName());
                t.setStackTrace(SecurityActions.getStackTrace(thread));
                this.mcf.log.queuedThread(thread.getName(), t);
            }
            if (this.lock.hasQueuedThreads()) {
                isActive = true;
            }
        }
        if (this.lock.isLocked()) {
            Thread owner = this.lock.getOwner();
            if (owner != null) {
                Throwable t = new Throwable("Lock owned during cleanup: " + owner.getName());
                t.setStackTrace(SecurityActions.getStackTrace(owner));
                this.mcf.log.lockOwned(owner.getName(), t);
            } else {
                this.mcf.log.lockOwnedWithoutOwner();
            }
            if (this.lock.isLocked()) {
                isActive = true;
            }
        }
        Object object = this.handles;
        synchronized (object) {
            for (WrappedConnection lc : this.handles) {
                lc.setManagedConnection(null);
                this.closeHandle(lc);
            }
            this.handles.clear();
        }
        object = this.stateLock;
        synchronized (object) {
            this.jdbcAutoCommit = true;
            this.jdbcReadOnly = this.readOnly;
            if (this.jdbcTransactionIsolation != this.transactionIsolation) {
                try {
                    this.con.setTransactionIsolation(this.transactionIsolation);
                    this.jdbcTransactionIsolation = this.transactionIsolation;
                }
                catch (SQLException e) {
                    this.mcf.log.transactionIsolationReset(this.mcf.getJndiName(), e);
                }
            }
        }
        if (isActive) {
            throw new ResourceException(bundle.activeLocks());
        }
    }

    protected void lock() {
        this.lock.lock();
    }

    protected void tryLock() throws SQLException {
        if (this.tryLock < 0) {
            return;
        }
        if (this.getLog().isTraceEnabled()) {
            this.dumpLockInformation(true);
        }
        if (this.tryLock == 0) {
            this.lock();
            return;
        }
        try {
            if (!this.lock.tryLock(this.tryLock, TimeUnit.SECONDS)) {
                throw new SQLException(bundle.unableToObtainLock(this.tryLock, this));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SQLException(bundle.interruptedWhileLock(this));
        }
    }

    protected void unlock() {
        try {
            if (this.getLog().isTraceEnabled()) {
                this.dumpLockInformation(false);
            }
        }
        finally {
            if (this.lock.isHeldByCurrentThread()) {
                this.lock.unlock();
            }
        }
    }

    private void dumpLockInformation(boolean l) {
        this.getLog().tracef("%s: HeldByCurrentThread: %s, Locked: %s, HoldCount: %d, QueueLength: %d", new Object[]{l ? "Lock" : "Unlock", this.lock.isHeldByCurrentThread() ? "Yes" : "No", this.lock.isLocked() ? "Yes" : "No", this.lock.getHoldCount(), this.lock.getQueueLength()});
        if (this.lock.isLocked()) {
            this.getLog().tracef("Owner: %s", this.lock.getOwner().toString());
        }
        if (this.lock.hasQueuedThreads()) {
            Collection<Thread> threads = this.lock.getQueuedThreads();
            for (Thread thread : threads) {
                this.getLog().tracef("Queued: %s", thread.toString());
            }
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        if (Boolean.TRUE.equals(this.mcf.getReauthEnabled())) {
            this.mcf.loadReauthPlugin();
        }
        this.checkIdentity(subject, cri);
        return this.getWrappedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws ResourceException {
        block10: {
            block9: {
                Object object = this.stateLock;
                synchronized (object) {
                    this.destroyed = true;
                }
                this.cleanup();
                try {
                    if (!this.underlyingAutoCommit) {
                        this.con.rollback();
                    }
                }
                catch (SQLException ignored) {
                    if (!this.getLog().isTraceEnabled()) break block9;
                    this.getLog().trace("Ignored error during rollback: ", ignored);
                }
            }
            try {
                this.con.close();
            }
            catch (SQLException ignored) {
                if (!this.getLog().isTraceEnabled()) break block10;
                this.getLog().trace("Ignored error during close: ", ignored);
            }
        }
        if (this.psCache != null) {
            this.mcf.getStatistics().deregisterPreparedStatementCache(this.psCache);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public Object getConnection() throws Exception {
        return this.getWrappedConnection();
    }

    public void setConnectableResourceListener(ConnectableResourceListener crl) {
    }

    void errorHandle(WrappedConnection handle) {
        this.returnHandle(handle, true);
    }

    void closeHandle(WrappedConnection handle) {
        this.returnHandle(handle, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void returnHandle(WrappedConnection handle, boolean error) {
        Set<WrappedConnection> set = this.stateLock;
        synchronized (set) {
            if (this.destroyed) {
                return;
            }
        }
        set = this.handles;
        synchronized (set) {
            this.handles.remove(handle);
            if (this.handles.size() == 0 && this.mcf.getConnectionListenerPlugin() != null) {
                try {
                    this.mcf.getConnectionListenerPlugin().passivated(this.con);
                }
                catch (SQLException se) {
                    this.mcf.log.errorDuringConnectionListenerPassivation(this.mcf.getJndiName(), se);
                }
            }
        }
        ConnectionEvent ce = null;
        ce = !error ? new ConnectionEvent((ManagedConnection)this, 1) : new ConnectionEvent((ManagedConnection)this, 5, (Exception)new SQLException(bundle.invalidConnection()));
        ce.setConnectionHandle((Object)handle);
        for (ConnectionEventListener cel : this.cels) {
            if (!error) {
                cel.connectionClosed(ce);
                continue;
            }
            cel.connectionErrorOccurred(ce);
        }
    }

    Throwable connectionError(Throwable t) {
        if (t instanceof SQLException) {
            if (this.mcf.isStaleConnection((SQLException)t)) {
                t = new StaleConnectionException((SQLException)t);
            } else if (this.mcf.isExceptionFatal((SQLException)t)) {
                this.broadcastConnectionError(t);
            }
        } else {
            this.broadcastConnectionError(t);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastConnectionError(Throwable e) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.destroyed) {
                if (this.getLog().isTraceEnabled()) {
                    this.getLog().trace("Not broadcasting error, already destroyed " + this, e);
                }
                return;
            }
        }
        this.unlock();
        Exception ex = null;
        ex = e instanceof Exception ? (Exception)e : new ResourceAdapterInternalException("Unexpected error", e);
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 5, ex);
        for (ConnectionEventListener cel : this.cels) {
            try {
                cel.connectionErrorOccurred(ce);
            }
            catch (Throwable t) {
                this.getLog().errorNotifyingConnectionListener(cel.toString(), t);
            }
        }
    }

    Connection getRealConnection() throws SQLException {
        if (this.con == null) {
            throw new SQLException(bundle.connectionDestroyed());
        }
        return this.con;
    }

    /*
     * Enabled aggressive block sorting
     */
    PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.psCache == null) return this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
        this.mcf.getStatistics().deltaPreparedStatementCacheAccessCount();
        PreparedStatementCache.Key key = new PreparedStatementCache.Key(sql, 1, resultSetType, resultSetConcurrency);
        CachedPreparedStatement cachedps = this.psCache.get(key);
        if (cachedps == null) {
            PreparedStatement ps = this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
            cachedps = WRAPPED_CONNECTION_FACTORY.createCachedPreparedStatement(ps);
            this.psCache.put(key, cachedps);
            this.mcf.getStatistics().deltaPreparedStatementCacheAddCount();
            return cachedps;
        }
        if (this.canUse(cachedps)) {
            this.mcf.getStatistics().deltaPreparedStatementCacheHitCount();
            cachedps.inUse();
            return cachedps;
        }
        this.mcf.getStatistics().deltaPreparedStatementCacheMissCount();
        return this.doPrepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    PreparedStatement doPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareStatement(sql, resultSetType, resultSetConcurrency);
    }

    /*
     * Enabled aggressive block sorting
     */
    CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.psCache == null) return this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
        this.mcf.getStatistics().deltaPreparedStatementCacheAccessCount();
        PreparedStatementCache.Key key = new PreparedStatementCache.Key(sql, 2, resultSetType, resultSetConcurrency);
        CachedCallableStatement cachedps = (CachedCallableStatement)this.psCache.get(key);
        if (cachedps == null) {
            CallableStatement cs = this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
            cachedps = WRAPPED_CONNECTION_FACTORY.createCachedCallableStatement(cs);
            this.psCache.put(key, cachedps);
            this.mcf.getStatistics().deltaPreparedStatementCacheAddCount();
            return cachedps;
        }
        if (this.canUse(cachedps)) {
            this.mcf.getStatistics().deltaPreparedStatementCacheHitCount();
            cachedps.inUse();
            return cachedps;
        }
        this.mcf.getStatistics().deltaPreparedStatementCacheMissCount();
        return this.doPrepareCall(sql, resultSetType, resultSetConcurrency);
    }

    CallableStatement doPrepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    boolean canUse(CachedPreparedStatement cachedps) {
        if (!cachedps.isInUse()) {
            return true;
        }
        if (this.underlyingAutoCommit) {
            return false;
        }
        return this.mcf.sharePS;
    }

    protected AdaptersLogger getLog() {
        return this.mcf.log;
    }

    private void checkIdentity(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.mcf.getConnectionProperties(this.props, subject, cri);
        if (Boolean.TRUE.equals(this.mcf.getReauthEnabled())) {
            if (this.props.equals(newProps)) {
                return;
            }
            if (!this.props.getProperty("user").equals(newProps.getProperty("user")) || !this.props.getProperty("password").equals(newProps.getProperty("password"))) {
                try {
                    ReauthPlugin plugin = this.mcf.getReauthPlugin();
                    plugin.reauthenticate(this.con, newProps.getProperty("user"), newProps.getProperty("password"));
                    this.props = newProps;
                }
                catch (SQLException se) {
                    throw new ResourceException(bundle.errorDuringReauthentication(), (Throwable)se);
                }
            }
        } else if (!this.props.equals(newProps)) {
            throw new ResourceException(bundle.wrongCredentials());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTransaction() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                return;
            }
            if (this.jdbcAutoCommit != this.underlyingAutoCommit) {
                this.con.setAutoCommit(this.jdbcAutoCommit);
                this.underlyingAutoCommit = this.jdbcAutoCommit;
            }
        }
        if (this.mcf.isJTA().booleanValue() && !this.jdbcAutoCommit && !this.inLocalTransaction.getAndSet(true)) {
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 2);
            for (ConnectionEventListener cel : this.cels) {
                try {
                    cel.localTransactionStarted(ce);
                }
                catch (Throwable t) {
                    if (!this.getLog().isTraceEnabled()) continue;
                    this.getLog().trace("Error notifying of connection committed for listener: " + cel, t);
                }
            }
        }
        this.checkState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkState() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.jdbcReadOnly != this.underlyingReadOnly) {
                this.con.setReadOnly(this.jdbcReadOnly);
                this.underlyingReadOnly = this.jdbcReadOnly;
            }
        }
    }

    boolean isJdbcAutoCommit() {
        return this.inManagedTransaction ? false : this.jdbcAutoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcAutoCommit(boolean jdbcAutoCommit) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                if (!ignoreInManagedAutoCommitCalls) {
                    throw new SQLException(bundle.autocommitManagedTransaction());
                }
                return;
            }
            this.jdbcAutoCommit = jdbcAutoCommit;
        }
        if (this.mcf.isJTA().booleanValue() && jdbcAutoCommit && this.inLocalTransaction.getAndSet(false)) {
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 3);
            for (ConnectionEventListener cel : this.cels) {
                try {
                    cel.localTransactionCommitted(ce);
                }
                catch (Throwable t) {
                    if (!this.getLog().isTraceEnabled()) continue;
                    this.getLog().trace("Error notifying of connection committed for listener: " + cel, t);
                }
            }
        }
    }

    boolean isJdbcReadOnly() {
        return this.jdbcReadOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcReadOnly(boolean readOnly) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException(bundle.readonlyManagedTransaction());
            }
            this.jdbcReadOnly = readOnly;
        }
    }

    int getJdbcTransactionIsolation() {
        return this.jdbcTransactionIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJdbcTransactionIsolation(int isolationLevel) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            this.con.setTransactionIsolation(isolationLevel);
            this.jdbcTransactionIsolation = isolationLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcCommit() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException(bundle.commitManagedTransaction());
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException(bundle.commitAutocommit());
            }
        }
        this.con.commit();
        if (this.mcf.isJTA().booleanValue() && this.inLocalTransaction.getAndSet(false)) {
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 3);
            for (ConnectionEventListener cel : this.cels) {
                try {
                    cel.localTransactionCommitted(ce);
                }
                catch (Throwable t) {
                    if (!this.getLog().isTraceEnabled()) continue;
                    this.getLog().trace("Error notifying of connection committed for listener: " + cel, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback() throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException(bundle.rollbackManagedTransaction());
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException(bundle.rollbackAutocommit());
            }
        }
        this.con.rollback();
        if (this.mcf.isJTA().booleanValue() && this.inLocalTransaction.getAndSet(false)) {
            ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 4);
            for (ConnectionEventListener cel : this.cels) {
                try {
                    cel.localTransactionRolledback(ce);
                }
                catch (Throwable t) {
                    if (!this.getLog().isTraceEnabled()) continue;
                    this.getLog().trace("Error notifying of connection rollback for listener: " + cel, t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jdbcRollback(Savepoint savepoint) throws SQLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.inManagedTransaction) {
                throw new SQLException(bundle.rollbackManagedTransaction());
            }
            if (this.jdbcAutoCommit) {
                throw new SQLException(bundle.rollbackAutocommit());
            }
        }
        this.con.rollback(savepoint);
    }

    int getTrackStatements() {
        return this.mcf.trackStatements;
    }

    boolean isTransactionQueryTimeout() {
        return this.mcf.isTransactionQueryTimeout;
    }

    int getQueryTimeout() {
        return this.mcf.getQueryTimeout();
    }

    protected void checkException(SQLException e) throws ResourceException {
        this.connectionError(e);
        throw new ResourceException("SQLException", (Throwable)e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WrappedConnection getWrappedConnection() throws ResourceException {
        WrappedConnection lc = WRAPPED_CONNECTION_FACTORY.createWrappedConnection(this, this.mcf.getSpy(), this.mcf.getJndiName(), this.mcf.isDoLocking(), this.mcf.getClassLoaderPlugin());
        Set<WrappedConnection> set = this.handles;
        synchronized (set) {
            this.handles.add(lc);
            if (this.handles.size() == 1 && this.mcf.getConnectionListenerPlugin() != null) {
                try {
                    this.mcf.getConnectionListenerPlugin().activated(this.con);
                }
                catch (SQLException se) {
                    this.mcf.log.errorDuringConnectionListenerActivation(this.mcf.getJndiName(), se);
                }
            }
        }
        return lc;
    }

    protected Optional<MethodHandle> getEndRequestNotify() {
        return this.requestEnd;
    }

    protected void setEndRequestNotify(Optional<MethodHandle> endRequest) {
        this.requestEnd = endRequest;
    }

    protected Optional<MethodHandle> getBeginRequestNotify() {
        return this.requestBegin;
    }

    protected void setBeginRequestNotify(Optional<MethodHandle> beginRequest) {
        this.requestBegin = beginRequest;
    }

    public abstract boolean isXA();

    static {
        bundle = (AdaptersBundle)Messages.getBundle(AdaptersBundle.class);
        ignoreInManagedAutoCommitCalls = false;
        Class<?> connectionFactory = null;
        try {
            connectionFactory = Class.forName(JDBC42_FACTORY);
        }
        catch (ClassNotFoundException cnfe8) {
            try {
                connectionFactory = Class.forName(JDBC41_FACTORY);
            }
            catch (ClassNotFoundException cnfe7) {
                throw new RuntimeException("Unabled to load wrapped connection factory", cnfe7);
            }
        }
        try {
            WRAPPED_CONNECTION_FACTORY = (WrappedConnectionFactory)connectionFactory.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializign connection factory", e);
        }
        String ignAutoCommit = SecurityActions.getSystemProperty("ironjacamar.jdbc.ignoreautocommit");
        if (ignAutoCommit != null) {
            ignoreInManagedAutoCommitCalls = Boolean.valueOf(ignAutoCommit);
        }
    }
}

