/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.adapters.jdbc.extensions.mysql;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import org.jboss.jca.adapters.jdbc.extensions.mysql.SecurityActions;
import org.jboss.jca.adapters.jdbc.spi.reauth.ReauthPlugin;

public class MySQLReauthPlugin
implements ReauthPlugin {
    @Override
    public synchronized void initialize(ClassLoader cl) throws SQLException {
        ClassLoader tccl2;
        Class<?> mysqlConnection = null;
        try {
            mysqlConnection = Class.forName("com.mysql.cj.jdbc.JdbcConnection", true, cl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (mysqlConnection == null) {
            try {
                mysqlConnection = Class.forName("com.mysql.cj.jdbc.JdbcConnection", true, SecurityActions.getClassLoader(this.getClass()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (mysqlConnection == null) {
            try {
                tccl2 = SecurityActions.getThreadContextClassLoader();
                mysqlConnection = Class.forName("com.mysql.cj.jdbc.JdbcConnection", true, tccl2);
            }
            catch (Throwable tccl2) {
                // empty catch block
            }
        }
        if (mysqlConnection == null) {
            try {
                mysqlConnection = Class.forName("com.mysql.jdbc.Connection", true, cl);
            }
            catch (Throwable tccl2) {
                // empty catch block
            }
        }
        if (mysqlConnection == null) {
            try {
                mysqlConnection = Class.forName("com.mysql.jdbc.Connection", true, SecurityActions.getClassLoader(this.getClass()));
            }
            catch (Throwable tccl2) {
                // empty catch block
            }
        }
        if (mysqlConnection == null) {
            try {
                tccl2 = SecurityActions.getThreadContextClassLoader();
                mysqlConnection = Class.forName("com.mysql.jdbc.Connection", true, tccl2);
            }
            catch (Throwable t) {
                throw new SQLException("Cannot resolve MySQL connection class", t);
            }
        }
        try {
            SecurityActions.getMethod(mysqlConnection, "changeUser", String.class, String.class);
        }
        catch (Throwable t) {
            throw new SQLException("Cannot resolve MySQL connection changeUser method", t);
        }
    }

    @Override
    public synchronized void reauthenticate(Connection c, String userName, String password) throws SQLException {
        Object[] params = new Object[]{userName, password};
        try {
            Method changeUser = SecurityActions.getMethod(c.getClass(), "changeUser", String.class, String.class);
            SecurityActions.setAccessible(changeUser);
            changeUser.invoke((Object)c, params);
        }
        catch (Throwable t) {
            Throwable cause = t.getCause();
            if (cause instanceof SQLException) {
                throw (SQLException)cause;
            }
            throw new SQLException("Unexpected error in changeUser", t);
        }
    }
}

