/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.sjc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jca.sjc.SecurityActions;

public class ProcessController {
    private static final ProcessController INSTANCE = new ProcessController();
    private static String java = SecurityActions.getSystemProperty("java.home") + File.separator + "bin" + File.separator + "java";
    private Map<String, Process> instances = Collections.synchronizedMap(new HashMap());

    private ProcessController() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                for (Process p : ProcessController.this.instances.values()) {
                    try {
                        p.destroy();
                    }
                    catch (Throwable throwable) {}
                }
            }
        });
    }

    public static ProcessController getInstance() {
        return INSTANCE;
    }

    public static void setJava(String v) {
        java = v;
    }

    public boolean start(String home) {
        return this.start(home, null);
    }

    public boolean start(String home, File options) {
        File homeDirectory = new File(home);
        if (!homeDirectory.exists()) {
            return false;
        }
        this.stop(home);
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add(java);
            command.add("-Xmx512m");
            command.add("-Diron.jacamar.home=" + home);
            if (options != null && options.exists()) {
                command.add("-Diron.jacamar.options=" + options.getAbsolutePath());
            }
            command.add("-Djava.net.preferIPv4Stack=true");
            command.add("-Djgroups.bind_addr=127.0.0.1");
            command.add("-Dorg.jboss.logging.Logger.pluginClass=org.jboss.logging.logmanager.LoggerPluginImpl");
            command.add("-Dlog4j.defaultInitOverride=true");
            command.add("-jar");
            command.add(home + "/bin/ironjacamar-sjc.jar");
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.redirectErrorStream(true);
            Map<String, String> environment = pb.environment();
            environment.put("iron.jacamar.home", home);
            Process p = pb.start();
            this.instances.put(home, p);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stop(String home) {
        Process p = this.instances.get(home);
        if (p != null) {
            try {
                p.destroy();
                int n = p.exitValue();
                return n;
            }
            catch (Throwable t) {
                int n = -1;
                return n;
            }
            finally {
                this.instances.remove(home);
            }
        }
        return 0;
    }
}

