/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.sjc.ant;

import java.io.File;
import java.io.Serializable;
import org.apache.tools.ant.BuildException;
import org.jboss.jca.sjc.ant.AbstractHostPortTask;

public class Undeploy
extends AbstractHostPortTask {
    private File file = null;

    public void setFile(File v) {
        this.file = v;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() throws BuildException {
        if (this.file == null) {
            throw new BuildException("File not defined");
        }
        if (!this.file.exists()) {
            throw new BuildException("File doesn't exists: " + this.file);
        }
        try {
            Boolean result = null;
            if (this.isLocal()) {
                Serializable value = this.executeCommand("local-undeploy", new Serializable[]{this.file.toURI().toURL()});
                if (!(value instanceof Boolean)) throw (Throwable)value;
                result = (Boolean)value;
            } else {
                Serializable value = this.executeCommand("remote-undeploy", new Serializable[]{this.file.getName()});
                if (!(value instanceof Boolean)) throw (Throwable)value;
                result = (Boolean)value;
            }
            if (result.booleanValue()) {
                this.log("Undeployed: " + this.file.getName());
                return;
            } else {
                this.log(this.file.getName() + " wasn't undeployed");
            }
            return;
        }
        catch (Throwable t) {
            throw new BuildException("Unable to undeploy to " + this.getHost() + ":" + this.getPort() + " (" + t.getMessage() + ")", t);
        }
    }
}

