/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.sjc;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getThreadContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setThreadContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    static Properties getSystemProperties() {
        return (Properties)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperties();
            }
        });
    }

    static String getSystemProperty(final String name) {
        return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty(name);
            }
        });
    }

    static void setSystemProperty(final String name, final String value) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty(name, value);
                return null;
            }
        });
    }

    static URLClassLoader createURLCLassLoader(final URL[] urls, final ClassLoader parent) {
        return (URLClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return new URLClassLoader(urls, parent);
            }
        });
    }
}

