/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.validator;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.jca.common.annotations.Annotations;
import org.jboss.jca.common.api.metadata.ra.AdminObject;
import org.jboss.jca.common.api.metadata.ra.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.ra.Connector;
import org.jboss.jca.common.api.metadata.ra.MessageListener;
import org.jboss.jca.common.api.metadata.ra.ResourceAdapter1516;
import org.jboss.jca.common.api.metadata.ra.XsdString;
import org.jboss.jca.common.api.metadata.ra.ra10.Connector10;
import org.jboss.jca.common.api.metadata.ra.ra16.Activationspec16;
import org.jboss.jca.common.metadata.MetadataFactory;
import org.jboss.jca.common.spi.annotations.repository.AnnotationRepository;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScanner;
import org.jboss.jca.common.spi.annotations.repository.AnnotationScannerFactory;
import org.jboss.jca.validator.Failure;
import org.jboss.jca.validator.FailureHelper;
import org.jboss.jca.validator.Key;
import org.jboss.jca.validator.SecurityActions;
import org.jboss.jca.validator.Validate;
import org.jboss.jca.validator.ValidateClass;
import org.jboss.jca.validator.Validator;

public class Validation {
    private static final int SUCCESS = 0;
    private static final int FAIL = 1;
    private static final int OTHER = 2;

    public static int validate(URL url, String output) {
        return Validation.validate(url, output, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int validate(URL url, String output, String[] classpath) {
        if (url == null || !url.toExternalForm().endsWith(".rar") && !url.toExternalForm().endsWith(".rar/")) {
            return 1;
        }
        int exitCode = 0;
        File destination = null;
        URLClassLoader cl = null;
        try {
            List<Failure> classFailures;
            URL[] allurls;
            File f = new File(url.toURI());
            if (!f.exists()) {
                throw new IOException("Archive " + url.toExternalForm() + " doesnt exists");
            }
            File root = null;
            if (f.isFile()) {
                destination = new File(SecurityActions.getSystemProperty("java.io.tmpdir"), "/tmp/");
                root = Validation.extract(f, destination);
            } else {
                root = f;
            }
            URL[] urls = Validation.getUrls(root);
            if (classpath != null && classpath.length > 0) {
                ArrayList<URL> listUrl = new ArrayList<URL>();
                for (URL u : urls) {
                    listUrl.add(u);
                }
                for (String jar : classpath) {
                    if (!jar.endsWith(".jar")) continue;
                    listUrl.add(new File(jar).toURI().toURL());
                }
                allurls = listUrl.toArray(new URL[listUrl.size()]);
            } else {
                allurls = urls;
            }
            cl = SecurityActions.createURLClassLoader(allurls, SecurityActions.getThreadContextClassLoader());
            SecurityActions.setThreadContextClassLoader(cl);
            MetadataFactory metadataFactory = new MetadataFactory();
            Connector cmd = metadataFactory.getStandardMetaData(root);
            Annotations annotator = new Annotations();
            AnnotationScanner scanner = AnnotationScannerFactory.getAnnotationScanner();
            AnnotationRepository repository = scanner.scan(cl.getURLs(), (ClassLoader)cl);
            cmd = annotator.merge(cmd, repository, (ClassLoader)cl);
            ArrayList<Validate> validateClasses = new ArrayList<Validate>();
            ArrayList<Failure> failures = new ArrayList<Failure>();
            Validator validator = new Validator();
            validateClasses.addAll(Validation.createResourceAdapter(cmd, failures, validator.getResourceBundle(), cl));
            validateClasses.addAll(Validation.createManagedConnectionFactory(cmd, failures, validator.getResourceBundle(), cl));
            validateClasses.addAll(Validation.createActivationSpec(cmd, failures, validator.getResourceBundle(), cl));
            validateClasses.addAll(Validation.createAdminObject(cmd, failures, validator.getResourceBundle(), cl));
            if (Validation.validateClassesInPackage(root)) {
                Failure failure = new Failure(0, "20.2", validator.getResourceBundle().getString("pak.cip"));
                failures.add(failure);
            }
            if ((classFailures = validator.validate(validateClasses)) != null && classFailures.size() > 0) {
                failures.addAll(classFailures);
            }
            if (failures.size() > 0) {
                int lastSepaIndex;
                int lastIndex;
                FailureHelper fh = new FailureHelper(failures);
                File reportDirectory = new File(output);
                if (!reportDirectory.exists() && !reportDirectory.mkdirs()) {
                    throw new IOException("The output directory '" + output + "' can't be created");
                }
                String reportName = url.getFile();
                int lastSlashIndex = reportName.lastIndexOf("/");
                int n = lastIndex = lastSlashIndex > (lastSepaIndex = reportName.lastIndexOf(File.separator)) ? lastSlashIndex : lastSepaIndex;
                if (lastIndex != -1) {
                    reportName = reportName.substring(lastIndex + 1);
                }
                reportName = reportName + ".log";
                File report = new File(reportDirectory, reportName);
                FileWriter fw = null;
                BufferedWriter bw = null;
                try {
                    fw = new FileWriter(report);
                    bw = new BufferedWriter(fw, 8192);
                    bw.write(fh.asText(validator.getResourceBundle()));
                    bw.flush();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    try {
                        if (bw != null) {
                            bw.close();
                        }
                        if (fw != null) {
                            fw.close();
                        }
                    }
                    catch (IOException ignore) {}
                }
                exitCode = 1;
            } else {
                exitCode = 0;
            }
            SecurityActions.closeURLClassLoader(cl);
        }
        catch (Exception e) {
            e.printStackTrace();
            exitCode = 2;
        }
        finally {
            SecurityActions.closeURLClassLoader(cl);
        }
        if (destination != null) {
            try {
                Validation.recursiveDelete(destination);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return exitCode;
    }

    private static List<Validate> createResourceAdapter(Connector cmd, List<Failure> failures, ResourceBundle rb, ClassLoader cl) {
        ArrayList<Validate> result = new ArrayList<Validate>();
        if (!(cmd instanceof Connector10) && cmd.getResourceadapter() != null && ((ResourceAdapter1516)cmd.getResourceadapter()).getResourceadapterClass() != null) {
            try {
                Class<?> clazz = Class.forName(((ResourceAdapter1516)cmd.getResourceadapter()).getResourceadapterClass(), true, cl);
                List configProperties = cmd.getResourceadapter().getConfigProperties();
                ValidateClass vc = new ValidateClass(Key.RESOURCE_ADAPTER, clazz, configProperties);
                result.add(vc);
            }
            catch (ClassNotFoundException e) {
                Failure failure = new Failure(1, rb.getString("uncategorized"), rb.getString("ra.cnfe"), e.getMessage());
                failures.add(failure);
            }
        }
        return result;
    }

    private static List<Validate> createManagedConnectionFactory(Connector cmd, List<Failure> failures, ResourceBundle rb, ClassLoader cl) {
        List cdMetas;
        ArrayList<Validate> result = new ArrayList<Validate>();
        if (cmd.getResourceadapter() != null && cmd.getVersion() != Connector.Version.V_10 && ((ResourceAdapter1516)cmd.getResourceadapter()).getOutboundResourceadapter() != null && ((ResourceAdapter1516)cmd.getResourceadapter()).getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
            for (ConnectionDefinition cdMeta : cdMetas) {
                if (cdMeta.getManagedConnectionFactoryClass() == null) continue;
                try {
                    Class<?> clazz = Class.forName(cdMeta.getManagedConnectionFactoryClass().getValue(), true, cl);
                    List configProperties = cdMeta.getConfigProperties();
                    ValidateClass vc = new ValidateClass(Key.MANAGED_CONNECTION_FACTORY, clazz, configProperties);
                    result.add(vc);
                }
                catch (ClassNotFoundException e) {
                    Failure failure = new Failure(1, rb.getString("uncategorized"), rb.getString("mcf.cnfe"), e.getMessage());
                    failures.add(failure);
                }
            }
        }
        return result;
    }

    private static List<Validate> createActivationSpec(Connector cmd, List<Failure> failures, ResourceBundle rb, ClassLoader cl) {
        List mlMetas;
        ArrayList<Validate> result = new ArrayList<Validate>();
        if (cmd.getResourceadapter() != null && cmd.getVersion() != Connector.Version.V_10 && ((ResourceAdapter1516)cmd.getResourceadapter()).getInboundResourceadapter() != null && ((ResourceAdapter1516)cmd.getResourceadapter()).getInboundResourceadapter().getMessageadapter() != null && ((ResourceAdapter1516)cmd.getResourceadapter()).getInboundResourceadapter().getMessageadapter().getMessagelisteners() != null && (mlMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getInboundResourceadapter().getMessageadapter().getMessagelisteners()).size() > 0) {
            for (MessageListener mlMeta : mlMetas) {
                if (mlMeta.getActivationspec() == null || mlMeta.getActivationspec().getActivationspecClass() == null || mlMeta.getActivationspec().getActivationspecClass().equals((Object)XsdString.NULL_XSDSTRING) || !(mlMeta.getActivationspec() instanceof Activationspec16)) continue;
                try {
                    Class<?> clazz = Class.forName(mlMeta.getActivationspec().getActivationspecClass().getValue(), true, cl);
                    List configProperties = ((Activationspec16)mlMeta.getActivationspec()).getConfigProperties();
                    ValidateClass vc = new ValidateClass(Key.ACTIVATION_SPEC, clazz, configProperties);
                    result.add(vc);
                }
                catch (ClassNotFoundException e) {
                    Failure failure = new Failure(1, rb.getString("uncategorized"), rb.getString("as.cnfe"), e.getMessage());
                    failures.add(failure);
                }
            }
        }
        return result;
    }

    private static List<Validate> createAdminObject(Connector cmd, List<Failure> failures, ResourceBundle rb, ClassLoader cl) {
        List aoMetas;
        ArrayList<Validate> result = new ArrayList<Validate>();
        if (cmd.getResourceadapter() != null && cmd.getVersion() != Connector.Version.V_10 && ((ResourceAdapter1516)cmd.getResourceadapter()).getAdminObjects() != null && (aoMetas = ((ResourceAdapter1516)cmd.getResourceadapter()).getAdminObjects()).size() > 0) {
            for (AdminObject aoMeta : aoMetas) {
                if (aoMeta.getAdminobjectClass() == null || aoMeta.getAdminobjectClass().equals((Object)XsdString.NULL_XSDSTRING)) continue;
                try {
                    Class<?> clazz = Class.forName(aoMeta.getAdminobjectClass().getValue(), true, cl);
                    List configProperties = aoMeta.getConfigProperties();
                    ValidateClass vc = new ValidateClass(Key.ADMIN_OBJECT, clazz, configProperties);
                    result.add(vc);
                }
                catch (ClassNotFoundException e) {
                    Failure failure = new Failure(1, rb.getString("uncategorized"), rb.getString("ao.cnfe"), e.getMessage());
                    failures.add(failure);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extract(File file, File directory) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (directory == null) {
            throw new IllegalArgumentException("Directory is null");
        }
        File target = new File(directory, file.getName());
        if (target.exists()) {
            Validation.recursiveDelete(target);
        }
        if (!target.mkdirs()) {
            throw new IOException("Could not create " + target);
        }
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                File copy = new File(target, je.getName());
                if (!je.isDirectory()) {
                    BufferedInputStream in = null;
                    OutputStream out = null;
                    if (copy.getParentFile() != null && !copy.getParentFile().exists() && !copy.getParentFile().mkdirs()) {
                        throw new IOException("Could not create " + copy.getParentFile());
                    }
                    try {
                        int nBytes;
                        in = new BufferedInputStream(jar.getInputStream(je));
                        out = new BufferedOutputStream(new FileOutputStream(copy));
                        byte[] buffer = new byte[4096];
                        while ((nBytes = ((InputStream)in).read(buffer)) > 0) {
                            out.write(buffer, 0, nBytes);
                        }
                        out.flush();
                        continue;
                    }
                    finally {
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (IOException ignore) {}
                        try {
                            if (in == null) continue;
                            ((InputStream)in).close();
                        }
                        catch (IOException ignore) {}
                        continue;
                    }
                }
                if (!copy.exists()) {
                    if (copy.mkdirs()) continue;
                    throw new IOException("Could not create " + copy);
                }
                if (copy.isDirectory()) continue;
                throw new IOException(copy + " isn't a directory");
            }
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ignore) {}
        }
        return target;
    }

    private static void recursiveDelete(File f) throws IOException {
        if (f != null && f.exists()) {
            File[] files = f.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Validation.recursiveDelete(files[i]);
                        continue;
                    }
                    if (files[i].delete()) continue;
                    throw new IOException("Could not delete " + files[i]);
                }
            }
            if (!f.delete()) {
                throw new IOException("Could not delete " + f);
            }
        }
    }

    private static URL[] getUrls(File directory) throws MalformedURLException, IOException {
        LinkedList<URL> list = new LinkedList<URL>();
        if (directory.exists() && directory.isDirectory()) {
            list.add(directory.toURI().toURL());
            File[] jars = directory.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (jars != null) {
                for (int j = 0; j < jars.length; ++j) {
                    list.add(jars[j].getCanonicalFile().toURI().toURL());
                }
            }
        }
        return list.toArray(new URL[list.size()]);
    }

    private static boolean validateClassesInPackage(File root) {
        File[] files;
        boolean hasClass = false;
        for (File file : files = root.listFiles()) {
            if (file.getName().lastIndexOf(".class") > 0) {
                return true;
            }
            if (file.isDirectory()) {
                hasClass = Validation.validateClassesInPackage(file);
            }
            if (!hasClass) continue;
            return true;
        }
        return hasClass;
    }
}

