/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.web;

import com.github.fungal.spi.deployers.DeployerPhases;
import java.util.concurrent.ExecutorService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.bio.SocketConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jboss.jca.web.ExecutorThreadPool;
import org.jboss.logging.Logger;

public class WebServer
implements DeployerPhases {
    private static Logger log = Logger.getLogger(WebServer.class);
    private Server server = null;
    private String host = "localhost";
    private int port = 8080;
    private int acceptQueueSize = 64;
    private ExecutorService executorService = null;
    private HandlerList handlers = new HandlerList();

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getAcceptQueueSize() {
        return this.acceptQueueSize;
    }

    public void setAcceptQueueSize(int v) {
        this.acceptQueueSize = v;
    }

    public void setExecutorService(ExecutorService service) {
        this.executorService = service;
    }

    public void start() throws Throwable {
        this.stop();
        this.server = new Server();
        SocketConnector connector = new SocketConnector();
        connector.setHost(this.host);
        connector.setPort(this.port);
        connector.setAcceptors(2 * Runtime.getRuntime().availableProcessors());
        connector.setAcceptQueueSize(this.acceptQueueSize);
        this.server.setConnectors(new Connector[]{connector});
        if (this.executorService != null) {
            this.server.setThreadPool((ThreadPool)new ExecutorThreadPool(this.executorService));
        }
        log.info((Object)("Jetty " + Server.getVersion() + " started"));
    }

    public void stop() throws Throwable {
        if (this.server != null && this.server.isRunning()) {
            this.server.stop();
            this.handlers = new HandlerList();
            log.info((Object)("Jetty " + Server.getVersion() + " stopped"));
        }
    }

    public void preDeploy() throws Throwable {
    }

    public void postDeploy() throws Throwable {
        if (this.server != null && !this.server.isRunning() && this.handlers != null && this.handlers.getHandlers() != null && this.handlers.getHandlers().length > 0) {
            try {
                ContextHandlerCollection chc = new ContextHandlerCollection();
                chc.setHandlers(this.handlers.getHandlers());
                this.server.setHandler((Handler)chc);
                this.server.start();
            }
            catch (Exception e) {
                log.error((Object)"Could not start Jetty webserver", (Throwable)e);
            }
        }
    }

    public void preUndeploy() throws Throwable {
    }

    public void postUndeploy() throws Throwable {
    }

    void addHandler(Handler handler) {
        handler.setServer(this.server);
        this.handlers.addHandler(handler);
    }
}

