/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.web.console;

import java.io.IOException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.AttributeList;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.jca.web.console.MBeanData;
import org.jboss.jca.web.console.OpResultInfo;
import org.jboss.jca.web.console.Server;
import org.jboss.logging.Logger;

public class HtmlAdaptorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(HtmlAdaptorServlet.class);
    private static final String ACTION_PARAM = "action";
    private static final String DISPLAY_MBEANS_ACTION = "displayMBeans";
    private static final String INSPECT_MBEAN_ACTION = "inspectMBean";
    private static final String UPDATE_ATTRIBUTES_ACTION = "updateAttributes";
    private static final String INVOKE_OP_ACTION = "invokeOp";
    private static final String INVOKE_OP_BY_NAME_ACTION = "invokeOpByName";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String action = request.getParameter(ACTION_PARAM);
        if (action == null) {
            action = DISPLAY_MBEANS_ACTION;
        }
        if (action.equals(DISPLAY_MBEANS_ACTION)) {
            this.displayMBeans(request, response);
        } else if (action.equals(INSPECT_MBEAN_ACTION)) {
            this.inspectMBean(request, response);
        } else if (action.equals(UPDATE_ATTRIBUTES_ACTION)) {
            this.updateAttributes(request, response);
        } else if (action.equals(INVOKE_OP_ACTION)) {
            this.invokeOp(request, response);
        } else if (action.equals(INVOKE_OP_BY_NAME_ACTION)) {
            this.invokeOpByName(request, response);
        }
    }

    private void displayMBeans(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Iterator mbeans;
        try {
            mbeans = this.getDomainData();
        }
        catch (Exception e) {
            throw new ServletException("Failed to get MBeans", (Throwable)e);
        }
        request.setAttribute("mbeans", (Object)mbeans);
        RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/displaymbeans.jsp");
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    private void inspectMBean(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        log.tracef("inspectMBean, name=%s", (Object)name);
        try {
            MBeanData data = this.getMBeanData(name);
            request.setAttribute("mbeanData", (Object)data);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/inspectmbean.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new ServletException("Failed to get MBean data", (Throwable)e);
        }
    }

    private void updateAttributes(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        log.tracef("updateAttributes, name=%s", (Object)name);
        Enumeration paramNames = request.getParameterNames();
        HashMap<String, String> attributes = new HashMap<String, String>();
        while (paramNames.hasMoreElements()) {
            String param = (String)paramNames.nextElement();
            if (param.equals("name") || param.equals(ACTION_PARAM)) continue;
            String value = request.getParameter(param);
            log.tracef("name=%s, value='%s'", (Object)param, (Object)value);
            if (value == null || value.length() == 0) continue;
            attributes.put(param, value);
        }
        try {
            AttributeList newAttributes = this.setAttributes(name, attributes);
            MBeanData data = this.getMBeanData(name);
            request.setAttribute("mbeanData", (Object)data);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/inspectmbean.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new ServletException("Failed to update attributes", (Throwable)e);
        }
    }

    private void invokeOp(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String reqname = request.getParameter("name");
        String name = URLDecoder.decode(reqname, "UTF-8");
        log.tracef("invokeOp, name=%s", (Object)name);
        String[] args = this.getArgs(request);
        String methodIndex = request.getParameter("methodIndex");
        if (methodIndex == null || methodIndex.length() == 0) {
            throw new ServletException("No methodIndex given in invokeOp form");
        }
        int index = Integer.parseInt(methodIndex);
        try {
            OpResultInfo opResult = this.invokeOp(name, index, args);
            request.setAttribute("opResultInfo", (Object)opResult);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/displayopresult.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new ServletException("Failed to invoke operation", (Throwable)e);
        }
    }

    private void invokeOpByName(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String name = request.getParameter("name");
        log.tracef("invokeOpByName, name=%s", (Object)name);
        String[] argTypes = request.getParameterValues("argType");
        String[] args = this.getArgs(request);
        String methodName = request.getParameter("methodName");
        if (methodName == null) {
            throw new ServletException("No methodName given in invokeOpByName form");
        }
        try {
            OpResultInfo opResult = this.invokeOpByName(name, methodName, argTypes, args);
            request.setAttribute("opResultInfo", (Object)opResult);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher("/displayopresult.jsp");
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new ServletException("Failed to invoke operation", (Throwable)e);
        }
    }

    private String[] getArgs(HttpServletRequest request) {
        String name;
        String value;
        ArrayList<String> argList = new ArrayList<String>();
        int i = 0;
        while ((value = request.getParameter(name = "arg" + i)) != null) {
            argList.add(value);
            log.tracef("%s=%s", (Object)name, (Object)value);
            ++i;
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        return args;
    }

    private MBeanData getMBeanData(final String name) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<MBeanData>(){

            @Override
            public MBeanData run() throws Exception {
                return Server.getMBeanData(name);
            }
        });
    }

    private Iterator getDomainData() throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Iterator>(){

            @Override
            public Iterator run() throws Exception {
                return Server.getDomainData();
            }
        });
    }

    private OpResultInfo invokeOp(final String name, final int index, final String[] args) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<OpResultInfo>(){

            @Override
            public OpResultInfo run() throws Exception {
                return Server.invokeOp(name, index, args);
            }
        });
    }

    private OpResultInfo invokeOpByName(final String name, final String methodName, final String[] argTypes, final String[] args) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<OpResultInfo>(){

            @Override
            public OpResultInfo run() throws Exception {
                return Server.invokeOpByName(name, methodName, argTypes, args);
            }
        });
    }

    private AttributeList setAttributes(final String name, final HashMap attributes) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<AttributeList>(){

            @Override
            public AttributeList run() throws Exception {
                return Server.setAttributes(name, attributes);
            }
        });
    }
}

