/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.web;

import com.github.fungal.api.util.JMX;
import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.LinkRef;
import javax.naming.NamingEnumeration;
import org.jboss.jca.web.SecurityActions;
import org.jboss.logging.Logger;

public class JNDIViewer {
    private static Logger log = Logger.getLogger(JNDIViewer.class);
    private static boolean trace = log.isTraceEnabled();
    private static final String NEW_LINE = SecurityActions.getSystemProperty("line.separator");
    private MBeanServer mbeanServer = null;
    private String domain = "";
    private ObjectName objectName = null;

    public void setMBeanServer(MBeanServer v) {
        this.mbeanServer = v;
    }

    public void setDomain(String v) {
        this.domain = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String list() {
        StringBuilder sb = new StringBuilder();
        InitialContext c = null;
        try {
            c = new InitialContext();
            Context context = (Context)c.lookup("java:");
            sb.append("java:").append(NEW_LINE);
            this.list(context, " ", sb);
        }
        catch (Throwable t) {
            log.debug((Object)t.getMessage(), t);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable context) {}
            }
        }
        return sb.toString();
    }

    private void list(Context ctx, String indent, StringBuilder buffer) throws Throwable {
        NamingEnumeration<Binding> bindings = ctx.listBindings("");
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            String name = binding.getName();
            String className = binding.getClassName();
            boolean recursive = Context.class.isAssignableFrom(binding.getObject().getClass());
            boolean isLinkRef = LinkRef.class.isAssignableFrom(binding.getObject().getClass());
            buffer.append(indent + " +- " + name);
            if (isLinkRef) {
                try {
                    Object obj = ctx.lookupLink(name);
                    LinkRef link = (LinkRef)obj;
                    buffer.append("[link -> ");
                    buffer.append(link.getLinkName());
                    buffer.append(']');
                }
                catch (Throwable t) {
                    log.debugf(t, "Invalid LinkRef for: %s", (Object)name);
                    buffer.append("invalid]");
                }
            }
            buffer.append(" (class: " + className + ")");
            buffer.append(NEW_LINE);
            if (!recursive) continue;
            try {
                Object value = ctx.lookup(name);
                if (value instanceof Context) {
                    Context subctx = (Context)value;
                    this.list(subctx, indent + " |  ", buffer);
                    continue;
                }
                buffer.append(indent + " |   NonContext: " + value);
                buffer.append(NEW_LINE);
            }
            catch (Throwable t) {
                buffer.append("Failed to lookup: " + name + ", errmsg=" + t.getMessage());
                buffer.append(NEW_LINE);
            }
        }
        bindings.close();
    }

    public void start() throws Throwable {
        if (this.mbeanServer != null) {
            DynamicMBean dmb = JMX.createMBean((Object)this, (String)"JNDIViewer");
            this.objectName = new ObjectName(this.domain + ":name=JNDIViewer");
            this.mbeanServer.registerMBean(dmb, this.objectName);
        }
    }

    public void stop() throws Throwable {
        if (this.mbeanServer != null && this.objectName != null) {
            this.mbeanServer.unregisterMBean(this.objectName);
        }
    }
}

