/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package javax.xml.registry;

import javax.xml.registry.infomodel.Key;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision: 84268 $
 */
public class RegistryException
   extends JAXRException
{
   private static final long serialVersionUID = -2972094643801708304L;
   
   private Key key;

	public RegistryException()
   {
   }
	public RegistryException(String msg)
   {
      this(msg, null);
   }
	public RegistryException(String msg, Throwable cause)
   {
      super(msg, cause);
   }

	public RegistryException(Throwable cause)
   {
      super(cause);
   }

	public Key getErrorObjectKey() throws JAXRException
   {
      return key;
   }
	public void setErrorObjectKey(Key key) throws JAXRException
   {
      this.key = key;
   }
}
