/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxr.scout.transport;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.jaxr.scout.transport.Normalizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class DOMWriter {
    private PrintWriter out;
    private boolean canonical;
    private boolean prettyprint;
    private boolean writeXMLDeclaration;
    private boolean ignoreWhitespace;
    private String charsetName;
    private int prettyIndent;
    private boolean wroteXMLDeclaration;
    private Node rootNode;
    private boolean completeNamespaces = true;
    private String currentDefaultNamespace;

    DOMWriter(Writer w) {
        this.out = new PrintWriter(w);
    }

    DOMWriter(Writer w, String charsetName) {
        this.out = new PrintWriter(w);
        this.charsetName = charsetName;
        this.writeXMLDeclaration = true;
    }

    DOMWriter(OutputStream stream) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    DOMWriter(OutputStream stream, String charsetName) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(stream, charsetName));
            this.charsetName = charsetName;
            this.writeXMLDeclaration = true;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported encoding: " + charsetName);
        }
    }

    static String printNode(Node node, boolean prettyprint) {
        StringWriter strw = new StringWriter();
        new DOMWriter(strw).setPrettyprint(prettyprint).print(node);
        return strw.toString();
    }

    boolean isCanonical() {
        return this.canonical;
    }

    DOMWriter setCanonical(boolean canonical) {
        this.canonical = canonical;
        return this;
    }

    boolean isIgnoreWhitespace() {
        return this.ignoreWhitespace;
    }

    DOMWriter setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
        return this;
    }

    DOMWriter setCompleteNamespaces(boolean complete) {
        this.completeNamespaces = complete;
        return this;
    }

    boolean isPrettyprint() {
        return this.prettyprint;
    }

    DOMWriter setPrettyprint(boolean prettyprint) {
        this.prettyprint = prettyprint;
        return this;
    }

    boolean isWriteXMLDeclaration() {
        return this.writeXMLDeclaration;
    }

    DOMWriter setWriteXMLDeclaration(boolean flag) {
        this.writeXMLDeclaration = flag;
        return this;
    }

    public void print(Node node) {
        if (this.prettyprint && this.ignoreWhitespace) {
            throw new IllegalStateException("Cannot pretty print and ignore whitespace");
        }
        this.rootNode = node;
        this.printInternal(node, false);
    }

    private void printInternal(Node node, boolean indentEndMarker) {
        if (node == null) {
            return;
        }
        if (!this.wroteXMLDeclaration && this.writeXMLDeclaration && !this.canonical) {
            this.out.print("<?xml version='1.0'");
            if (this.charsetName != null) {
                this.out.print(" encoding='" + this.charsetName + "'");
            }
            this.out.print("?>");
            if (this.prettyprint) {
                this.out.println();
            }
            this.wroteXMLDeclaration = true;
        }
        short type = node.getNodeType();
        boolean hasChildNodes = node.getChildNodes().getLength() > 0;
        String nodeName = node.getNodeName();
        switch (type) {
            case 9: {
                NodeList children = node.getChildNodes();
                int len = children.getLength();
                for (int iChild = 0; iChild < len; ++iChild) {
                    this.printInternal(children.item(iChild), false);
                }
                this.out.flush();
                break;
            }
            case 1: {
                String defaultNamespace;
                Element element = (Element)node;
                if (this.prettyprint) {
                    for (int i = 0; i < this.prettyIndent; ++i) {
                        this.out.print(' ');
                    }
                    ++this.prettyIndent;
                }
                this.out.print('<');
                this.out.print(nodeName);
                HashMap<String, String> nsMap = new HashMap<String, String>();
                String elPrefix = node.getPrefix();
                String elNamespaceURI = node.getNamespaceURI();
                if (elPrefix != null) {
                    String nsURI = this.getNamespaceURI(elPrefix, element, this.rootNode);
                    nsMap.put(elPrefix, nsURI);
                }
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                for (int i = 0; i < attrs.length; ++i) {
                    Attr attr = attrs[i];
                    String atPrefix = attr.getPrefix();
                    String atName = attr.getNodeName();
                    String atValue = DOMWriter.normalize(attr.getNodeValue(), this.canonical);
                    if (atName.equals("xmlns")) {
                        this.currentDefaultNamespace = atValue;
                    }
                    if (atPrefix != null && !atPrefix.equals("xmlns") && !atPrefix.equals("xml")) {
                        String nsURI = this.getNamespaceURI(atPrefix, element, this.rootNode);
                        nsMap.put(atPrefix, nsURI);
                        if (atName.equals(atPrefix + ":type") && atValue.indexOf(":") > 0) {
                            if (nsURI == null) {
                                nsURI = this.getNamespaceURI(atPrefix, element, null);
                            }
                            if ("http://www.w3.org/2001/XMLSchema-instance".equals(nsURI)) {
                                String typePrefix = atValue.substring(0, atValue.indexOf(":"));
                                String typeURI = this.getNamespaceURI(typePrefix, element, this.rootNode);
                                nsMap.put(typePrefix, typeURI);
                            }
                        }
                    }
                    this.out.print(" " + atName + "='" + atValue + "'");
                }
                if (this.completeNamespaces) {
                    Iterator itPrefix = nsMap.keySet().iterator();
                    while (itPrefix.hasNext()) {
                        String prefix = (String)itPrefix.next();
                        String nsURI = (String)nsMap.get(prefix);
                        if (nsURI != null) continue;
                        nsURI = this.getNamespaceURI(prefix, element, null);
                        this.out.print(" xmlns:" + prefix + "='" + nsURI + "'");
                    }
                }
                if (elPrefix == null && elNamespaceURI != null && (defaultNamespace = element.getAttribute("xmlns")).length() == 0 && !elNamespaceURI.equals(this.currentDefaultNamespace)) {
                    this.out.print(" xmlns='" + elNamespaceURI + "'");
                    this.currentDefaultNamespace = elNamespaceURI;
                }
                if (hasChildNodes) {
                    this.out.print('>');
                }
                if (indentEndMarker = this.isEndMarkerIndented(node)) {
                    this.out.print('\n');
                }
                NodeList childNodes = node.getChildNodes();
                int len = childNodes.getLength();
                for (int i = 0; i < len; ++i) {
                    Node childNode = childNodes.item(i);
                    this.printInternal(childNode, false);
                }
                break;
            }
            case 5: {
                NodeList children;
                if (this.canonical) {
                    children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    for (int i = 0; i < len; ++i) {
                        this.printInternal(children.item(i), false);
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(nodeName);
                this.out.print(';');
                break;
            }
            case 4: {
                if (this.canonical) {
                    this.out.print(DOMWriter.normalize(node.getNodeValue(), this.canonical));
                    break;
                }
                this.out.print("<![CDATA[");
                this.out.print(node.getNodeValue());
                this.out.print("]]>");
                break;
            }
            case 3: {
                String text = DOMWriter.normalize(node.getNodeValue(), this.canonical);
                if (text.trim().length() > 0) {
                    this.out.print(text);
                    break;
                }
                if (this.prettyprint || this.ignoreWhitespace) break;
                this.out.print(text);
                break;
            }
            case 7: {
                this.out.print("<?");
                this.out.print(nodeName);
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.out.print(' ');
                    this.out.print(data);
                }
                this.out.print("?>");
                break;
            }
            case 8: {
                for (int i = 0; i < this.prettyIndent; ++i) {
                    this.out.print(' ');
                }
                this.out.print("<!--");
                String data = node.getNodeValue();
                if (data != null) {
                    this.out.print(data);
                }
                this.out.print("-->");
                if (!this.prettyprint) break;
                this.out.print('\n');
                break;
            }
        }
        if (type == 1) {
            if (this.prettyprint) {
                --this.prettyIndent;
            }
            if (!hasChildNodes) {
                this.out.print("/>");
            } else {
                if (indentEndMarker) {
                    for (int i = 0; i < this.prettyIndent; ++i) {
                        this.out.print(' ');
                    }
                }
                this.out.print("</");
                this.out.print(nodeName);
                this.out.print('>');
            }
            if (this.prettyIndent > 0) {
                this.out.print('\n');
            }
        }
        this.out.flush();
    }

    private String getNamespaceURI(String prefix, Element element, Node stopNode) {
        Node parent = element.getParentNode();
        String nsURI = element.getAttribute("xmlns:" + prefix);
        if (nsURI.length() == 0 && element != stopNode && parent instanceof Element) {
            return this.getNamespaceURI(prefix, (Element)parent, stopNode);
        }
        return nsURI.length() > 0 ? nsURI : null;
    }

    private boolean isEndMarkerIndented(Node node) {
        if (this.prettyprint) {
            NodeList childNodes = node.getChildNodes();
            int len = childNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node children = childNodes.item(i);
                if (children.getNodeType() != 1) continue;
                return true;
            }
        }
        return false;
    }

    private Attr[] sortAttributes(NamedNodeMap attrs) {
        int i;
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        for (i = 0; i < len; ++i) {
            array[i] = (Attr)attrs.item(i);
        }
        for (i = 0; i < len - 1; ++i) {
            String name = array[i].getNodeName();
            int index = i;
            for (int j = i + 1; j < len; ++j) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) >= 0) continue;
                name = curName;
                index = j;
            }
            if (index == i) continue;
            Attr temp = array[i];
            array[i] = array[index];
            array[index] = temp;
        }
        return array;
    }

    static String normalize(String s, boolean canonical) {
        return Normalizer.normalize(s, canonical);
    }
}

