/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jaxr.scout.transport;

import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.ws.scout.registry.RegistryException;
import org.apache.ws.scout.transport.Transport;
import org.jboss.jaxr.scout.transport.DOMWriter;
import org.jboss.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class SaajTransport
implements Transport {
    private static Logger log = Logger.getLogger((Class)SaajTransport.class);

    public Element send(Element request, URI endpointURL) throws RegistryException {
        String requestMessage = DOMWriter.printNode(request, true);
        log.debug((Object)("Request message:" + requestMessage));
        Element response = null;
        try {
            SOAPMessage message = this.createSOAPMessage(request);
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnectionFactory.createConnection();
            SOAPMessage soapResponse = connection.call(message, (Object)endpointURL.toURL());
            SOAPBody soapBody = soapResponse.getSOAPBody();
            boolean hasFault = soapBody.hasFault();
            if (hasFault) {
                SOAPFault soapFault = soapBody.getFault();
                String faultStr = soapFault.getFaultCode() + "::" + soapFault.getFaultString();
                throw new RegistryException(faultStr);
            }
            response = this.getFirstChildElement((Element)soapBody);
        }
        catch (Exception ex) {
            log.error((Object)"Exception::", (Throwable)ex);
            throw new RegistryException(ex);
        }
        log.debug((Object)("Response message:" + DOMWriter.printNode(response, true)));
        return response;
    }

    public String send(String request, URI endpointURL) throws RegistryException {
        Element reqEl = SaajTransport.getElement(request);
        Element respEl = this.send(reqEl, endpointURL);
        StringWriter sw = new StringWriter();
        DOMWriter dw = new DOMWriter(sw);
        dw.print(respEl);
        return sw.toString();
    }

    private SOAPMessage createSOAPMessage(Element elem) throws Exception {
        String prefix = "";
        MessageFactory msgFactory = MessageFactory.newInstance();
        SOAPFactory factory = SOAPFactory.newInstance();
        SOAPMessage message = msgFactory.createMessage();
        message.getSOAPHeader().detachNode();
        SOAPPart soapPart = message.getSOAPPart();
        SOAPBody soapBody = soapPart.getEnvelope().getBody();
        String uddins = "urn:uddi-org:api_v2";
        Name bodyName = factory.createName(elem.getNodeName(), prefix, uddins);
        SOAPBodyElement bodyElement = soapBody.addBodyElement(bodyName);
        bodyElement.addNamespaceDeclaration(prefix, uddins);
        this.appendAttributes((SOAPElement)bodyElement, elem.getAttributes(), factory);
        this.appendElements((SOAPElement)bodyElement, elem.getChildNodes(), factory);
        return message;
    }

    private void appendAttributes(SOAPElement bodyElement, NamedNodeMap nnm, SOAPFactory factory) throws SOAPException {
        int len = nnm != null ? nnm.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            Node n = nnm.item(i);
            String nodename = n.getNodeName();
            String nodevalue = n.getNodeValue();
            if ("xmlns".equals(nodename) || nodename.startsWith("xmlns:")) continue;
            if ("xml:lang".equals(nodename)) {
                Name xmlLang = factory.createName("lang", "xml", "");
                bodyElement.addAttribute(xmlLang, nodevalue);
                continue;
            }
            bodyElement.addAttribute(factory.createName(nodename), nodevalue);
        }
    }

    private void appendElements(SOAPElement bodyElement, NodeList nlist, SOAPFactory factory) throws SOAPException {
        String prefix = "";
        String uddins = "urn:uddi-org:api_v2";
        int len = nlist != null ? nlist.getLength() : 0;
        for (int i = 0; i < len; ++i) {
            int nodeType;
            Node node = nlist.item(i);
            int n = nodeType = node != null ? (int)node.getNodeType() : -100;
            if (1 == nodeType) {
                Element el = (Element)node;
                Name name = factory.createName(el.getNodeName(), prefix, uddins);
                SOAPElement attachedEl = bodyElement.addChildElement(name);
                this.appendAttributes(attachedEl, el.getAttributes(), factory);
                this.appendElements(attachedEl, el.getChildNodes(), factory);
                continue;
            }
            if (nodeType != 3) continue;
            bodyElement.addTextNode(node.getNodeValue());
        }
    }

    private static Element getElement(String xmlFrag) {
        Document doc = null;
        Element reqElement = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            doc = factory.newDocumentBuilder().parse(new InputSource(new StringReader(xmlFrag)));
            reqElement = doc.getDocumentElement();
        }
        catch (Exception e) {
            log.error((Object)"Exception:", (Throwable)e);
        }
        return reqElement;
    }

    private Element getFirstChildElement(Element el) {
        return this.getFirstChildElement(el, null);
    }

    private Element getFirstChildElement(Element el, String tagName) {
        Element childEl = null;
        NodeList nlist = el != null ? el.getChildNodes() : null;
        int len = nlist != null ? nlist.getLength() : 0;
        for (int i = 0; childEl == null && i < len; ++i) {
            Node node = nlist.item(i);
            if (node.getNodeType() != 1 || tagName != null && !tagName.equals(node.getLocalName())) continue;
            childEl = (Element)node;
        }
        String responseObtained = DOMWriter.printNode(childEl, true);
        log.debug((Object)("Response obtained=" + responseObtained));
        return childEl;
    }
}

