/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.ejb.client.Attachable;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.ConstantContextSelector;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientConfiguration;
import org.jboss.ejb.client.EJBClientContextInitializer;
import org.jboss.ejb.client.EJBClientInterceptor;
import org.jboss.ejb.client.EJBClientPropertiesLoader;
import org.jboss.ejb.client.EJBReceiver;
import org.jboss.ejb.client.EJBReceiverContext;
import org.jboss.ejb.client.PropertiesBasedEJBClientConfiguration;
import org.jboss.ejb.client.SecurityActions;
import org.jboss.ejb.client.remoting.ConfigBasedEJBClientContextSelector;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;

public final class EJBClientContext
extends Attachable {
    private static final Logger logger = Logger.getLogger(EJBClientContext.class);
    private static final RuntimePermission SET_SELECTOR_PERMISSION = new RuntimePermission("setEJBClientContextSelector");
    private static final RuntimePermission ADD_INTERCEPTOR_PERMISSION = new RuntimePermission("registerInterceptor");
    private static final RuntimePermission CREATE_CONTEXT_PERMISSION = new RuntimePermission("createEJBClientContext");
    private static final AtomicReferenceFieldUpdater<EJBClientContext, EJBClientInterceptor.Registration[]> registrationsUpdater = AtomicReferenceFieldUpdater.newUpdater(EJBClientContext.class, EJBClientInterceptor.Registration[].class, "registrations");
    private static final EJBClientInterceptor.Registration[] NO_INTERCEPTORS = new EJBClientInterceptor.Registration[0];
    private static volatile ContextSelector<EJBClientContext> SELECTOR;
    private static volatile boolean SELECTOR_LOCKED;
    private final Map<EJBReceiver, EJBReceiverContext> ejbReceiverAssociations = new IdentityHashMap<EJBReceiver, EJBReceiverContext>();
    private final Map<EJBReceiverContext, EJBReceiverContextCloseHandler> receiverContextCloseHandlers = Collections.synchronizedMap(new IdentityHashMap());
    private volatile EJBClientInterceptor.Registration[] registrations = NO_INTERCEPTORS;
    private final Map<String, ClusterContext> clusterContexts = Collections.synchronizedMap(new HashMap());
    private final EJBClientConfiguration ejbClientConfiguration;

    private EJBClientContext(EJBClientConfiguration ejbClientConfiguration) {
        this.ejbClientConfiguration = ejbClientConfiguration;
    }

    private void init(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = EJBClientContext.class.getClassLoader();
        }
        for (EJBClientContextInitializer contextInitializer : SecurityActions.loadService(EJBClientContextInitializer.class, classLoader)) {
            try {
                contextInitializer.initialize(this);
            }
            catch (Throwable ignored) {
                logger.debug((Object)("EJB client context initializer " + contextInitializer + " failed to initialize context " + this), ignored);
            }
        }
    }

    public static EJBClientContext create() {
        return EJBClientContext.create(null, EJBClientContext.class.getClassLoader());
    }

    public static EJBClientContext create(ClassLoader classLoader) {
        return EJBClientContext.create(null, classLoader);
    }

    public static EJBClientContext create(EJBClientConfiguration ejbClientConfiguration) {
        return EJBClientContext.create(ejbClientConfiguration, EJBClientContext.class.getClassLoader());
    }

    public static EJBClientContext create(EJBClientConfiguration ejbClientConfiguration, ClassLoader classLoader) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_CONTEXT_PERMISSION);
        }
        EJBClientContext context = new EJBClientContext(ejbClientConfiguration);
        context.init(classLoader);
        return context;
    }

    public static ContextSelector<EJBClientContext> setSelector(ContextSelector<EJBClientContext> newSelector) {
        if (newSelector == null) {
            throw new IllegalArgumentException("EJB client context selector cannot be set to null");
        }
        if (SELECTOR_LOCKED) {
            throw new SecurityException("EJB client context selector may not be changed");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_SELECTOR_PERMISSION);
        }
        ContextSelector<EJBClientContext> oldSelector = SELECTOR;
        SELECTOR = newSelector;
        return oldSelector;
    }

    public static ContextSelector<EJBClientContext> setConstantContext(EJBClientContext context) {
        return EJBClientContext.setSelector(new ConstantContextSelector<EJBClientContext>(context));
    }

    public static void lockSelector() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SET_SELECTOR_PERMISSION);
        }
        SELECTOR_LOCKED = true;
    }

    public static EJBClientContext getCurrent() {
        return SELECTOR.getCurrent();
    }

    public static EJBClientContext requireCurrent() throws IllegalStateException {
        EJBClientContext clientContext = EJBClientContext.getCurrent();
        if (clientContext == null) {
            throw new IllegalStateException("No EJB client context is available");
        }
        return clientContext;
    }

    public void registerEJBReceiver(EJBReceiver receiver) {
        this.registerEJBReceiver(receiver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerEJBReceiver(EJBReceiver receiver, EJBReceiverContextCloseHandler receiverContextCloseHandler) {
        EJBReceiverContext ejbReceiverContext;
        if (receiver == null) {
            throw new IllegalArgumentException("receiver is null");
        }
        Map<EJBReceiver, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            if (this.ejbReceiverAssociations.containsKey(receiver)) {
                return;
            }
            ejbReceiverContext = new EJBReceiverContext(receiver, this);
            this.ejbReceiverAssociations.put(receiver, ejbReceiverContext);
            if (receiverContextCloseHandler != null) {
                this.receiverContextCloseHandlers.put(ejbReceiverContext, receiverContextCloseHandler);
            }
        }
        receiver.associate(ejbReceiverContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterEJBReceiver(EJBReceiver receiver) {
        if (receiver == null) {
            throw new IllegalArgumentException("Receiver cannot be null");
        }
        Map<EJBReceiver, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            EJBReceiverContextCloseHandler receiverContextCloseHandler;
            EJBReceiverContext receiverContext = this.ejbReceiverAssociations.remove(receiver);
            if (receiverContext != null && (receiverContextCloseHandler = this.receiverContextCloseHandlers.remove(receiverContext)) != null) {
                receiverContextCloseHandler.receiverContextClosed(receiverContext);
            }
        }
    }

    public void registerConnection(Connection connection) {
        this.registerEJBReceiver(new RemotingConnectionEJBReceiver(connection));
    }

    public EJBClientInterceptor.Registration registerInterceptor(int priority, EJBClientInterceptor clientInterceptor) throws IllegalArgumentException {
        Object[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        if (clientInterceptor == null) {
            throw new IllegalArgumentException("clientInterceptor is null");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ADD_INTERCEPTOR_PERMISSION);
        }
        EJBClientInterceptor.Registration newRegistration = new EJBClientInterceptor.Registration(this, clientInterceptor, priority);
        do {
            for (EJBClientInterceptor.Registration oldRegistration : oldRegistrations = this.registrations) {
                if (oldRegistration.getInterceptor() != clientInterceptor) continue;
                if (oldRegistration.compareTo(newRegistration) == 0) {
                    return oldRegistration;
                }
                throw new IllegalArgumentException("Interceptor '" + clientInterceptor + "' is already registered");
            }
            int length = oldRegistrations.length;
            newRegistrations = Arrays.copyOf(oldRegistrations, length + 1);
            newRegistrations[length] = newRegistration;
            Arrays.sort(newRegistrations);
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, (EJBClientInterceptor.Registration[])newRegistrations));
        return newRegistration;
    }

    public EJBClientConfiguration getEJBClientConfiguration() {
        return this.ejbClientConfiguration;
    }

    void removeInterceptor(EJBClientInterceptor.Registration registration) {
        EJBClientInterceptor.Registration[] newRegistrations;
        EJBClientInterceptor.Registration[] oldRegistrations;
        do {
            block5: {
                int newLength;
                int length;
                block4: {
                    oldRegistrations = this.registrations;
                    newRegistrations = null;
                    length = oldRegistrations.length;
                    newLength = length - 1;
                    if (length != 1) break block4;
                    if (oldRegistrations[0].getInterceptor() != registration) break block5;
                    newRegistrations = NO_INTERCEPTORS;
                    break block5;
                }
                for (int i = 0; i < length; ++i) {
                    if (oldRegistrations[i].getInterceptor() != registration) continue;
                    if (i == newLength) {
                        newRegistrations = Arrays.copyOf(oldRegistrations, newLength);
                        break;
                    }
                    newRegistrations = new EJBClientInterceptor.Registration[newLength];
                    if (i > 0) {
                        System.arraycopy(oldRegistrations, 0, newRegistrations, 0, i);
                    }
                    System.arraycopy(oldRegistrations, i + 1, newRegistrations, i, newLength - i);
                    break;
                }
            }
            if (newRegistrations != null) continue;
            return;
        } while (!registrationsUpdater.compareAndSet(this, oldRegistrations, newRegistrations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<EJBReceiver> getEJBReceivers(String appName, String moduleName, String distinctName) {
        HashSet<EJBReceiver> eligibleEJBReceivers = new HashSet<EJBReceiver>();
        Map<EJBReceiver, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            for (EJBReceiver ejbReceiver : this.ejbReceiverAssociations.keySet()) {
                if (!ejbReceiver.acceptsModule(appName, moduleName, distinctName)) continue;
                eligibleEJBReceivers.add(ejbReceiver);
            }
        }
        return eligibleEJBReceivers;
    }

    EJBReceiver getEJBReceiver(String appName, String moduleName, String distinctName) {
        Iterator<EJBReceiver> iterator = this.getEJBReceivers(appName, moduleName, distinctName).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBReceiver requireEJBReceiver(String appName, String moduleName, String distinctName) throws IllegalStateException {
        EJBReceiver ejbReceiver = null;
        Map<EJBReceiver, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            if (this.ejbReceiverAssociations.size() == 1) {
                ejbReceiver = this.ejbReceiverAssociations.keySet().iterator().next();
            }
        }
        if (ejbReceiver != null) {
            return ejbReceiver;
        }
        ejbReceiver = this.getEJBReceiver(appName, moduleName, distinctName);
        if (ejbReceiver == null) {
            throw new IllegalStateException("No EJB receiver available for handling [appName:" + appName + ",modulename:" + moduleName + ",distinctname:" + distinctName + "] combination");
        }
        return ejbReceiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBReceiverContext requireEJBReceiverContext(EJBReceiver receiver) throws IllegalStateException {
        Map<EJBReceiver, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            EJBReceiverContext receiverContext = this.ejbReceiverAssociations.get(receiver);
            if (receiverContext == null) {
                throw new IllegalStateException(receiver + " has not been associated with " + this);
            }
            return receiverContext;
        }
    }

    EJBReceiver requireNodeEJBReceiver(String nodeName) {
        EJBReceiver receiver = this.getNodeEJBReceiver(nodeName);
        if (receiver != null) {
            return receiver;
        }
        throw new IllegalStateException("No EJBReceiver available for node name " + nodeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EJBReceiver getNodeEJBReceiver(String nodeName) {
        if (nodeName == null) {
            throw new IllegalArgumentException("Node name cannot be null");
        }
        Map<EJBReceiver, EJBReceiverContext> map = this.ejbReceiverAssociations;
        synchronized (map) {
            for (EJBReceiver ejbReceiver : this.ejbReceiverAssociations.keySet()) {
                if (!nodeName.equals(ejbReceiver.getNodeName())) continue;
                return ejbReceiver;
            }
        }
        return null;
    }

    EJBReceiverContext requireNodeEJBReceiverContext(String nodeName) {
        EJBReceiver ejbReceiver = this.requireNodeEJBReceiver(nodeName);
        return this.requireEJBReceiverContext(ejbReceiver);
    }

    EJBReceiverContext getNodeEJBReceiverContext(String nodeName) {
        EJBReceiver ejbReceiver = this.getNodeEJBReceiver(nodeName);
        return ejbReceiver == null ? null : this.requireEJBReceiverContext(ejbReceiver);
    }

    boolean clusterContains(String clusterName, String nodeName) {
        ClusterContext clusterManager = this.clusterContexts.get(clusterName);
        if (clusterManager == null) {
            return false;
        }
        return clusterManager.isNodeAvailable(nodeName);
    }

    EJBReceiverContext getClusterEJBReceiverContext(String clusterName) throws IllegalArgumentException {
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            return null;
        }
        return clusterContext.getEJBReceiverContext();
    }

    EJBReceiverContext requireClusterEJBReceiverContext(String clusterName) throws IllegalArgumentException {
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            throw new IllegalArgumentException("No cluster context (and as a result EJB receiver context) available for cluster named " + clusterName);
        }
        return clusterContext.requireEJBReceiverContext();
    }

    EJBClientInterceptor[] getInterceptorChain() {
        EJBClientInterceptor.Registration[] registrations = this.registrations;
        EJBClientInterceptor[] interceptors = new EJBClientInterceptor[registrations.length];
        for (int i = 0; i < registrations.length; ++i) {
            interceptors[i] = registrations[i].getInterceptor();
        }
        return interceptors;
    }

    EJBReceiver getClusterEJBReceiver(String clusterName) {
        ClusterContext clusterManager = this.clusterContexts.get(clusterName);
        if (clusterManager == null) {
            return null;
        }
        EJBReceiverContext ejbReceiverContext = clusterManager.getEJBReceiverContext();
        return ejbReceiverContext == null ? null : ejbReceiverContext.getReceiver();
    }

    public synchronized ClusterContext getOrCreateClusterContext(String clusterName) {
        ClusterContext clusterContext = this.clusterContexts.get(clusterName);
        if (clusterContext == null) {
            clusterContext = new ClusterContext(clusterName, this, this.ejbClientConfiguration);
            this.clusterContexts.put(clusterName, clusterContext);
        }
        return clusterContext;
    }

    public synchronized ClusterContext getClusterContext(String clusterName) {
        return this.clusterContexts.get(clusterName);
    }

    public synchronized void removeCluster(String clusterName) {
        ClusterContext clusterContext = this.clusterContexts.remove(clusterName);
        if (clusterContext == null) {
            return;
        }
        try {
            clusterContext.close();
        }
        catch (Throwable t) {
            logger.debug((Object)("Ignoring an error that occured while closing a cluster context for cluster named " + clusterName), t);
        }
    }

    static {
        Properties ejbClientProperties = EJBClientPropertiesLoader.loadEJBClientProperties();
        if (ejbClientProperties == null) {
            SELECTOR = new ConfigBasedEJBClientContextSelector(null);
        } else {
            PropertiesBasedEJBClientConfiguration clientConfiguration = new PropertiesBasedEJBClientConfiguration(ejbClientProperties);
            SELECTOR = new ConfigBasedEJBClientContextSelector(clientConfiguration);
        }
    }

    static interface EJBReceiverContextCloseHandler {
        public void receiverContextClosed(EJBReceiverContext var1);
    }
}

