/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.ejb.client.EJBReceiverInvocationContext;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.remoting.ChannelAssociation;
import org.jboss.ejb.client.remoting.PackedInteger;
import org.jboss.ejb.client.remoting.ProtocolMessageHandler;
import org.jboss.ejb.client.remoting.RemotingAttachments;
import org.jboss.logging.Logger;
import org.jboss.remoting3.MessageInputStream;

class SessionOpenResponseHandler
extends ProtocolMessageHandler {
    private static final Logger logger = Logger.getLogger(SessionOpenResponseHandler.class);
    private final ChannelAssociation channelAssociation;

    SessionOpenResponseHandler(ChannelAssociation channelAssociation) {
        this.channelAssociation = channelAssociation;
    }

    @Override
    protected void processMessage(MessageInputStream messageInputStream) throws IOException {
        if (messageInputStream == null) {
            throw new IllegalArgumentException("Cannot read from null stream");
        }
        DataInputStream input = new DataInputStream((InputStream)messageInputStream);
        short invocationId = input.readShort();
        SessionIDResultProducer resultProducer = new SessionIDResultProducer(input);
        this.channelAssociation.resultReady(invocationId, resultProducer);
    }

    private class SessionIDResultProducer
    implements EJBReceiverInvocationContext.ResultProducer {
        private final DataInputStream input;

        SessionIDResultProducer(DataInputStream input) {
            this.input = input;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getResult() throws Exception {
            try {
                int sessionIdLength = PackedInteger.readPackedInteger(this.input);
                byte[] sessionIdBytes = new byte[sessionIdLength];
                this.input.read(sessionIdBytes);
                RemotingAttachments attachments = SessionOpenResponseHandler.this.readAttachments(this.input);
                SessionID sessionID = SessionID.createSessionID(sessionIdBytes);
                return sessionID;
            }
            finally {
                this.input.close();
            }
        }

        @Override
        public void discardResult() {
        }
    }
}

