/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.remoting.MaxAttemptsReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class ClusterContextConnectionReconnectHandler
extends MaxAttemptsReconnectHandler {
    private static Logger logger = Logger.getLogger(ClusterContextConnectionReconnectHandler.class);
    private final ClusterContext clusterContext;
    private final long reconnectTimeout;
    private final TimeUnit reconnectTimeUnit;

    ClusterContextConnectionReconnectHandler(ClusterContext clusterContext, Endpoint endpoint, String destinationHost, int destinationPort, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, OptionMap channelCreationOptions, int maxReconnectAttempts, long reconnectTimeout, TimeUnit timeoutTimeUnit) {
        super(endpoint, destinationHost, destinationPort, connectionCreationOptions, callbackHandler, channelCreationOptions, maxReconnectAttempts);
        this.clusterContext = clusterContext;
        this.reconnectTimeout = reconnectTimeout;
        this.reconnectTimeUnit = timeoutTimeUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws IOException {
        Connection connection = null;
        try {
            connection = this.tryConnect(this.reconnectTimeout, this.reconnectTimeUnit);
            if (connection == null) {
                return;
            }
            RemotingConnectionEJBReceiver ejbReceiver = new RemotingConnectionEJBReceiver(connection, this, this.channelCreationOptions);
            this.clusterContext.registerEJBReceiver(ejbReceiver);
        }
        finally {
            if (connection != null || !this.hasMoreAttempts()) {
                this.clusterContext.getEJBClientContext().unregisterReconnectHandler(this);
            }
        }
    }
}

