/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.EJBClientContextListener;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;

class RemotingCleanupHandler
implements EJBClientContextListener {
    private static final Logger logger = Logger.getLogger(RemotingCleanupHandler.class);
    private final List<Connection> connections = new ArrayList<Connection>();
    private final List<Endpoint> endpoints = new ArrayList<Endpoint>();

    RemotingCleanupHandler() {
    }

    @Override
    public void contextClosed(EJBClientContext ejbClientContext) {
        this.closeAll();
    }

    void addEndpoint(Endpoint endpoint) {
        if (endpoint == null) {
            return;
        }
        this.endpoints.add(endpoint);
    }

    void addConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        this.connections.add(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAll() {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                this.safeClose((Closeable)connection);
            }
        }
        list = this.endpoints;
        synchronized (list) {
            for (Endpoint endpoint : this.endpoints) {
                this.safeClose((Closeable)endpoint);
            }
        }
    }

    private void safeClose(Closeable closable) {
        try {
            logger.debug((Object)("Closing " + closable));
            closable.close();
        }
        catch (Throwable e) {
            logger.debug((Object)("Exception closing " + closable), e);
        }
    }
}

