/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client.remoting;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.ejb.client.ClusterContext;
import org.jboss.ejb.client.remoting.MaxAttemptsReconnectHandler;
import org.jboss.ejb.client.remoting.RemotingConnectionEJBReceiver;
import org.jboss.logging.Logger;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.xnio.OptionMap;

class ClusterContextConnectionReconnectHandler
extends MaxAttemptsReconnectHandler {
    private static Logger logger = Logger.getLogger(ClusterContextConnectionReconnectHandler.class);
    private final ClusterContext clusterContext;

    ClusterContextConnectionReconnectHandler(ClusterContext clusterContext, Endpoint endpoint, URI uri, OptionMap connectionCreationOptions, CallbackHandler callbackHandler, OptionMap channelCreationOptions, int maxReconnectAttempts) {
        super(endpoint, uri, connectionCreationOptions, callbackHandler, channelCreationOptions, maxReconnectAttempts);
        this.clusterContext = clusterContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() throws IOException {
        Connection connection = null;
        try {
            connection = this.tryConnect(5000L, TimeUnit.SECONDS);
            if (connection == null) {
                return;
            }
            RemotingConnectionEJBReceiver ejbReceiver = new RemotingConnectionEJBReceiver(connection, this, this.channelCreationOptions);
            this.clusterContext.registerEJBReceiver(ejbReceiver);
        }
        finally {
            if (connection != null || !this.hasMoreAttempts()) {
                this.clusterContext.getEJBClientContext().unregisterReconnectHandler(this);
            }
        }
    }
}

